/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3;

import com.zoyi.io.socket.okhttp3.CacheControl$Builder;
import com.zoyi.io.socket.okhttp3.Headers;
import com.zoyi.io.socket.okhttp3.internal.http.HttpHeaders;
import java.util.concurrent.TimeUnit;

public final class CacheControl {
    public static final CacheControl FORCE_NETWORK = new CacheControl$Builder().noCache().build();
    public static final CacheControl FORCE_CACHE = new CacheControl$Builder().onlyIfCached().maxStale(Integer.MAX_VALUE, TimeUnit.SECONDS).build();
    private final boolean noCache;
    private final boolean noStore;
    private final int maxAgeSeconds;
    private final int sMaxAgeSeconds;
    private final boolean isPrivate;
    private final boolean isPublic;
    private final boolean mustRevalidate;
    private final int maxStaleSeconds;
    private final int minFreshSeconds;
    private final boolean onlyIfCached;
    private final boolean noTransform;
    String headerValue;

    private CacheControl(boolean bl, boolean bl2, int n2, int n3, boolean bl3, boolean bl4, boolean bl5, int n4, int n5, boolean bl6, boolean bl7, String string) {
        this.noCache = bl;
        this.noStore = bl2;
        this.maxAgeSeconds = n2;
        this.sMaxAgeSeconds = n3;
        this.isPrivate = bl3;
        this.isPublic = bl4;
        this.mustRevalidate = bl5;
        this.maxStaleSeconds = n4;
        this.minFreshSeconds = n5;
        this.onlyIfCached = bl6;
        this.noTransform = bl7;
        this.headerValue = string;
    }

    CacheControl(CacheControl$Builder cacheControl$Builder) {
        this.noCache = cacheControl$Builder.noCache;
        this.noStore = cacheControl$Builder.noStore;
        this.maxAgeSeconds = cacheControl$Builder.maxAgeSeconds;
        this.sMaxAgeSeconds = -1;
        this.isPrivate = false;
        this.isPublic = false;
        this.mustRevalidate = false;
        this.maxStaleSeconds = cacheControl$Builder.maxStaleSeconds;
        this.minFreshSeconds = cacheControl$Builder.minFreshSeconds;
        this.onlyIfCached = cacheControl$Builder.onlyIfCached;
        this.noTransform = cacheControl$Builder.noTransform;
    }

    public final boolean noCache() {
        return this.noCache;
    }

    public final boolean noStore() {
        return this.noStore;
    }

    public final int maxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public final int sMaxAgeSeconds() {
        return this.sMaxAgeSeconds;
    }

    public final boolean isPrivate() {
        return this.isPrivate;
    }

    public final boolean isPublic() {
        return this.isPublic;
    }

    public final boolean mustRevalidate() {
        return this.mustRevalidate;
    }

    public final int maxStaleSeconds() {
        return this.maxStaleSeconds;
    }

    public final int minFreshSeconds() {
        return this.minFreshSeconds;
    }

    public final boolean onlyIfCached() {
        return this.onlyIfCached;
    }

    public final boolean noTransform() {
        return this.noTransform;
    }

    public static CacheControl parse(Headers headers) {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = -1;
        int n3 = -1;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n4 = -1;
        int n5 = -1;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = true;
        String string = null;
        int n6 = headers.size();
        for (int i2 = 0; i2 < n6; ++i2) {
            String string2 = headers.name(i2);
            String string3 = headers.value(i2);
            if (string2.equalsIgnoreCase("Cache-Control")) {
                if (string != null) {
                    bl8 = false;
                } else {
                    string = string3;
                }
            } else {
                if (!string2.equalsIgnoreCase("Pragma")) continue;
                bl8 = false;
            }
            int n7 = 0;
            while (n7 < string3.length()) {
                String string4;
                int n8 = n7;
                n7 = HttpHeaders.skipUntil(string3, n7, "=,;");
                String string5 = string3.substring(n8, n7).trim();
                if (n7 == string3.length() || string3.charAt(n7) == ',' || string3.charAt(n7) == ';') {
                    ++n7;
                    string4 = null;
                } else {
                    ++n7;
                    if ((n7 = HttpHeaders.skipWhitespace(string3, n7)) < string3.length() && string3.charAt(n7) == '\"') {
                        int n9 = ++n7;
                        n7 = HttpHeaders.skipUntil(string3, n7, "\"");
                        string4 = string3.substring(n9, n7);
                        ++n7;
                    } else {
                        int n10 = n7;
                        n7 = HttpHeaders.skipUntil(string3, n7, ",;");
                        string4 = string3.substring(n10, n7).trim();
                    }
                }
                if ("no-cache".equalsIgnoreCase(string5)) {
                    bl = true;
                    continue;
                }
                if ("no-store".equalsIgnoreCase(string5)) {
                    bl2 = true;
                    continue;
                }
                if ("max-age".equalsIgnoreCase(string5)) {
                    n2 = HttpHeaders.parseSeconds(string4, -1);
                    continue;
                }
                if ("s-maxage".equalsIgnoreCase(string5)) {
                    n3 = HttpHeaders.parseSeconds(string4, -1);
                    continue;
                }
                if ("private".equalsIgnoreCase(string5)) {
                    bl3 = true;
                    continue;
                }
                if ("public".equalsIgnoreCase(string5)) {
                    bl4 = true;
                    continue;
                }
                if ("must-revalidate".equalsIgnoreCase(string5)) {
                    bl5 = true;
                    continue;
                }
                if ("max-stale".equalsIgnoreCase(string5)) {
                    n4 = HttpHeaders.parseSeconds(string4, Integer.MAX_VALUE);
                    continue;
                }
                if ("min-fresh".equalsIgnoreCase(string5)) {
                    n5 = HttpHeaders.parseSeconds(string4, -1);
                    continue;
                }
                if ("only-if-cached".equalsIgnoreCase(string5)) {
                    bl6 = true;
                    continue;
                }
                if (!"no-transform".equalsIgnoreCase(string5)) continue;
                bl7 = true;
            }
        }
        if (!bl8) {
            string = null;
        }
        return new CacheControl(bl, bl2, n2, n3, bl3, bl4, bl5, n4, n5, bl6, bl7, string);
    }

    public final String toString() {
        String string = this.headerValue;
        if (string != null) {
            return string;
        }
        this.headerValue = this.headerValue();
        return this.headerValue;
    }

    private String headerValue() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.noCache) {
            stringBuilder.append("no-cache, ");
        }
        if (this.noStore) {
            stringBuilder.append("no-store, ");
        }
        if (this.maxAgeSeconds != -1) {
            stringBuilder.append("max-age=").append(this.maxAgeSeconds).append(", ");
        }
        if (this.sMaxAgeSeconds != -1) {
            stringBuilder.append("s-maxage=").append(this.sMaxAgeSeconds).append(", ");
        }
        if (this.isPrivate) {
            stringBuilder.append("private, ");
        }
        if (this.isPublic) {
            stringBuilder.append("public, ");
        }
        if (this.mustRevalidate) {
            stringBuilder.append("must-revalidate, ");
        }
        if (this.maxStaleSeconds != -1) {
            stringBuilder.append("max-stale=").append(this.maxStaleSeconds).append(", ");
        }
        if (this.minFreshSeconds != -1) {
            stringBuilder.append("min-fresh=").append(this.minFreshSeconds).append(", ");
        }
        if (this.onlyIfCached) {
            stringBuilder.append("only-if-cached, ");
        }
        if (this.noTransform) {
            stringBuilder.append("no-transform, ");
        }
        if (stringBuilder.length() == 0) {
            return "";
        }
        stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        return stringBuilder.toString();
    }
}

