/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3;

import com.zoyi.io.socket.okhttp3.CacheControl;
import java.util.concurrent.TimeUnit;

public final class CacheControl$Builder {
    boolean noCache;
    boolean noStore;
    int maxAgeSeconds = -1;
    int maxStaleSeconds = -1;
    int minFreshSeconds = -1;
    boolean onlyIfCached;
    boolean noTransform;

    public final CacheControl$Builder noCache() {
        this.noCache = true;
        return this;
    }

    public final CacheControl$Builder noStore() {
        this.noStore = true;
        return this;
    }

    public final CacheControl$Builder maxAge(int n2, TimeUnit timeUnit) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maxAge < 0: " + n2);
        }
        long l2 = timeUnit.toSeconds(n2);
        this.maxAgeSeconds = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
        return this;
    }

    public final CacheControl$Builder maxStale(int n2, TimeUnit timeUnit) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maxStale < 0: " + n2);
        }
        long l2 = timeUnit.toSeconds(n2);
        this.maxStaleSeconds = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
        return this;
    }

    public final CacheControl$Builder minFresh(int n2, TimeUnit timeUnit) {
        if (n2 < 0) {
            throw new IllegalArgumentException("minFresh < 0: " + n2);
        }
        long l2 = timeUnit.toSeconds(n2);
        this.minFreshSeconds = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
        return this;
    }

    public final CacheControl$Builder onlyIfCached() {
        this.onlyIfCached = true;
        return this;
    }

    public final CacheControl$Builder noTransform() {
        this.noTransform = true;
        return this;
    }

    public final CacheControl build() {
        return new CacheControl(this);
    }
}

