/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.engineio.client.transports;

import com.zoyi.io.socket.engineio.client.Transport;
import com.zoyi.io.socket.engineio.client.Transport$Options;
import com.zoyi.io.socket.engineio.client.Transport$ReadyState;
import com.zoyi.io.socket.engineio.client.transports.PollingXHR;
import com.zoyi.io.socket.engineio.client.transports.WebSocket$1;
import com.zoyi.io.socket.engineio.client.transports.WebSocket$2;
import com.zoyi.io.socket.engineio.client.transports.WebSocket$3;
import com.zoyi.io.socket.engineio.client.transports.WebSocket$4;
import com.zoyi.io.socket.engineio.parser.Packet;
import com.zoyi.io.socket.engineio.parser.Parser;
import com.zoyi.io.socket.okhttp3.Credentials;
import com.zoyi.io.socket.okhttp3.OkHttpClient;
import com.zoyi.io.socket.okhttp3.OkHttpClient$Builder;
import com.zoyi.io.socket.okhttp3.Request;
import com.zoyi.io.socket.okhttp3.Request$Builder;
import com.zoyi.io.socket.parseqs.ParseQS;
import com.zoyi.io.socket.utf8.UTF8Exception;
import com.zoyi.io.socket.yeast.Yeast;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocketFactory;

public class WebSocket
extends Transport {
    public static final String NAME = "websocket";
    private static final Logger logger = Logger.getLogger(PollingXHR.class.getName());
    private com.zoyi.io.socket.okhttp3.WebSocket ws;

    public WebSocket(Transport$Options transport$Options) {
        super(transport$Options);
        this.name = NAME;
    }

    @Override
    protected void doOpen() {
        Object object2;
        Object object3 = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        this.emit("requestHeaders", object3);
        WebSocket webSocket = this;
        OkHttpClient$Builder okHttpClient$Builder = new OkHttpClient$Builder().connectTimeout(0L, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).writeTimeout(0L, TimeUnit.MILLISECONDS);
        if (this.sslContext != null) {
            object2 = this.sslContext.getSocketFactory();
            okHttpClient$Builder.sslSocketFactory((SSLSocketFactory)object2);
        }
        if (this.hostnameVerifier != null) {
            okHttpClient$Builder.hostnameVerifier(this.hostnameVerifier);
        }
        if (this.proxy != null) {
            okHttpClient$Builder.proxy(this.proxy);
        }
        if (this.proxyLogin != null && !this.proxyLogin.isEmpty()) {
            object2 = Credentials.basic(this.proxyLogin, this.proxyPassword);
            okHttpClient$Builder.proxyAuthenticator(new WebSocket$1(this, (String)object2));
        }
        object2 = new Request$Builder().url(this.uri());
        for (Map.Entry object4 : object3.entrySet()) {
            for (String string : (List)object4.getValue()) {
                ((Request$Builder)object2).addHeader((String)object4.getKey(), string);
            }
        }
        object3 = ((Request$Builder)object2).build();
        OkHttpClient okHttpClient = okHttpClient$Builder.build();
        this.ws = okHttpClient.newWebSocket((Request)object3, new WebSocket$2(this, webSocket));
        okHttpClient.dispatcher().executorService().shutdown();
    }

    @Override
    protected void write(Packet[] packetArray) throws UTF8Exception {
        WebSocket webSocket = this;
        this.writable = false;
        WebSocket$3 webSocket$3 = new WebSocket$3(this, webSocket);
        int[] nArray = new int[]{packetArray.length};
        for (Packet packet : packetArray) {
            if (this.readyState != Transport$ReadyState.OPENING && this.readyState != Transport$ReadyState.OPEN) break;
            Parser.encodePacket(packet, new WebSocket$4(this, webSocket, nArray, webSocket$3));
        }
    }

    @Override
    protected void doClose() {
        if (this.ws != null) {
            try {
                this.ws.close(1000, "");
            }
            catch (IllegalStateException illegalStateException) {}
        }
        if (this.ws != null) {
            this.ws.cancel();
        }
    }

    protected String uri() {
        HashMap<String, String> hashMap = this.query;
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
        }
        String string = this.secure ? "wss" : "ws";
        String string2 = "";
        if (this.port > 0 && ("wss".equals(string) && this.port != 443 || "ws".equals(string) && this.port != 80)) {
            string2 = ":" + this.port;
        }
        if (this.timestampRequests) {
            hashMap.put(this.timestampParam, Yeast.yeast());
        }
        if (((String)((Object)(hashMap = ParseQS.encode(hashMap)))).length() > 0) {
            hashMap = "?" + (String)((Object)hashMap);
        }
        boolean bl = this.hostname.contains(":");
        return string + "://" + (bl ? "[" + this.hostname + "]" : this.hostname) + string2 + this.path + (String)((Object)hashMap);
    }

    static /* synthetic */ void access$000(WebSocket webSocket) {
        webSocket.onOpen();
    }

    static /* synthetic */ void access$100(WebSocket webSocket, String string) {
        webSocket.onData(string);
    }

    static /* synthetic */ void access$200(WebSocket webSocket, byte[] byArray) {
        webSocket.onData(byArray);
    }

    static /* synthetic */ void access$300(WebSocket webSocket) {
        webSocket.onClose();
    }

    static /* synthetic */ Transport access$400(WebSocket webSocket, String string, Exception exception) {
        return webSocket.onError(string, exception);
    }

    static /* synthetic */ com.zoyi.io.socket.okhttp3.WebSocket access$500(WebSocket webSocket) {
        return webSocket.ws;
    }

    static /* synthetic */ Logger access$600() {
        return logger;
    }
}

