/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.engineio.client;

import com.zoyi.io.socket.emitter.Emitter;
import com.zoyi.io.socket.emitter.Emitter$Listener;
import com.zoyi.io.socket.engineio.client.EngineIOException;
import com.zoyi.io.socket.engineio.client.HandshakeData;
import com.zoyi.io.socket.engineio.client.Socket$1;
import com.zoyi.io.socket.engineio.client.Socket$10;
import com.zoyi.io.socket.engineio.client.Socket$11;
import com.zoyi.io.socket.engineio.client.Socket$12;
import com.zoyi.io.socket.engineio.client.Socket$13;
import com.zoyi.io.socket.engineio.client.Socket$14;
import com.zoyi.io.socket.engineio.client.Socket$15;
import com.zoyi.io.socket.engineio.client.Socket$16;
import com.zoyi.io.socket.engineio.client.Socket$17;
import com.zoyi.io.socket.engineio.client.Socket$18;
import com.zoyi.io.socket.engineio.client.Socket$19;
import com.zoyi.io.socket.engineio.client.Socket$2;
import com.zoyi.io.socket.engineio.client.Socket$20;
import com.zoyi.io.socket.engineio.client.Socket$3;
import com.zoyi.io.socket.engineio.client.Socket$4;
import com.zoyi.io.socket.engineio.client.Socket$5;
import com.zoyi.io.socket.engineio.client.Socket$6;
import com.zoyi.io.socket.engineio.client.Socket$7;
import com.zoyi.io.socket.engineio.client.Socket$8;
import com.zoyi.io.socket.engineio.client.Socket$9;
import com.zoyi.io.socket.engineio.client.Socket$Options;
import com.zoyi.io.socket.engineio.client.Socket$ReadyState;
import com.zoyi.io.socket.engineio.client.Transport;
import com.zoyi.io.socket.engineio.client.Transport$Options;
import com.zoyi.io.socket.engineio.client.transports.Polling;
import com.zoyi.io.socket.engineio.client.transports.PollingXHR;
import com.zoyi.io.socket.engineio.client.transports.WebSocket;
import com.zoyi.io.socket.engineio.parser.Packet;
import com.zoyi.io.socket.parseqs.ParseQS;
import com.zoyi.io.socket.thread.EventThread;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.json.JSONException;

public class Socket
extends Emitter {
    private static final Logger logger = Logger.getLogger(Socket.class.getName());
    private static final String PROBE_ERROR = "probe error";
    public static final String EVENT_OPEN = "open";
    public static final String EVENT_CLOSE = "close";
    public static final String EVENT_MESSAGE = "message";
    public static final String EVENT_ERROR = "error";
    public static final String EVENT_UPGRADE_ERROR = "upgradeError";
    public static final String EVENT_FLUSH = "flush";
    public static final String EVENT_DRAIN = "drain";
    public static final String EVENT_HANDSHAKE = "handshake";
    public static final String EVENT_UPGRADING = "upgrading";
    public static final String EVENT_UPGRADE = "upgrade";
    public static final String EVENT_PACKET = "packet";
    public static final String EVENT_PACKET_CREATE = "packetCreate";
    public static final String EVENT_HEARTBEAT = "heartbeat";
    public static final String EVENT_DATA = "data";
    public static final String EVENT_PING = "ping";
    public static final String EVENT_PONG = "pong";
    public static final String EVENT_TRANSPORT = "transport";
    public static final int PROTOCOL = 3;
    private static boolean priorWebsocketSuccess = false;
    private static SSLContext defaultSSLContext;
    private static HostnameVerifier defaultHostnameVerifier;
    private boolean secure;
    private boolean upgrade;
    private boolean timestampRequests;
    private boolean upgrading;
    private boolean rememberUpgrade;
    int port;
    private int policyPort;
    private int prevBufferLen;
    private long pingInterval;
    private long pingTimeout;
    private String id;
    String hostname;
    private String path;
    private String timestampParam;
    private List<String> transports;
    private List<String> upgrades;
    private Map<String, String> query;
    LinkedList<Packet> writeBuffer = new LinkedList();
    Transport transport;
    private Future pingTimeoutTimer;
    private Future pingIntervalTimer;
    private SSLContext sslContext;
    private HostnameVerifier hostnameVerifier;
    public Proxy proxy;
    public String proxyLogin;
    public String proxyPassword;
    private Socket$ReadyState readyState;
    private ScheduledExecutorService heartbeatScheduler;
    private final Emitter$Listener onHeartbeatAsListener = new Socket$1(this);

    public Socket() {
        this(new Socket$Options());
    }

    public Socket(String string) throws URISyntaxException {
        this(string, null);
    }

    public Socket(URI uRI) {
        this(uRI, null);
    }

    public Socket(String string, Socket$Options socket$Options) throws URISyntaxException {
        this(string == null ? null : new URI(string), socket$Options);
    }

    public Socket(URI uRI, Socket$Options socket$Options) {
        this(uRI == null ? socket$Options : Socket$Options.access$100(uRI, socket$Options));
    }

    public Socket(Socket$Options socket$Options) {
        String[] stringArray;
        if (socket$Options.host != null) {
            String string = socket$Options.host;
            int n2 = string.split(":").length > 2 ? 1 : 0;
            if (n2 != 0) {
                n2 = string.indexOf(91);
                if (n2 != -1) {
                    string = string.substring(n2 + 1);
                }
                if ((n2 = string.lastIndexOf(93)) != -1) {
                    string = string.substring(0, n2);
                }
            }
            socket$Options.hostname = string;
        }
        this.secure = socket$Options.secure;
        if (socket$Options.port == -1) {
            socket$Options.port = this.secure ? 443 : 80;
        }
        this.sslContext = socket$Options.sslContext != null ? socket$Options.sslContext : defaultSSLContext;
        this.hostname = socket$Options.hostname != null ? socket$Options.hostname : "localhost";
        this.port = socket$Options.port;
        this.query = socket$Options.query != null ? ParseQS.decode(socket$Options.query) : new HashMap();
        this.upgrade = socket$Options.upgrade;
        this.path = (socket$Options.path != null ? socket$Options.path : "/engine.io").replaceAll("/$", "") + "/";
        this.timestampParam = socket$Options.timestampParam != null ? socket$Options.timestampParam : "t";
        this.timestampRequests = socket$Options.timestampRequests;
        if (socket$Options.transports != null) {
            stringArray = socket$Options.transports;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "polling";
            stringArray = stringArray2;
            stringArray2[1] = "websocket";
        }
        this.transports = new ArrayList<String>(Arrays.asList(stringArray));
        this.policyPort = socket$Options.policyPort != 0 ? socket$Options.policyPort : 843;
        this.rememberUpgrade = socket$Options.rememberUpgrade;
        this.hostnameVerifier = socket$Options.hostnameVerifier != null ? socket$Options.hostnameVerifier : defaultHostnameVerifier;
        this.proxy = socket$Options.proxy;
        this.proxyLogin = socket$Options.proxyLogin;
        this.proxyPassword = socket$Options.proxyPassword;
    }

    public static void setDefaultSSLContext(SSLContext sSLContext) {
        defaultSSLContext = sSLContext;
    }

    public static void setDefaultHostnameVerifier(HostnameVerifier hostnameVerifier) {
        defaultHostnameVerifier = hostnameVerifier;
    }

    public Socket open() {
        EventThread.exec(new Socket$2(this));
        return this;
    }

    private Transport createTransport(String object) {
        logger.fine(String.format("creating transport '%s'", object));
        HashMap<String, String> hashMap = new HashMap<String, String>(this.query);
        hashMap.put("EIO", "3");
        hashMap.put(EVENT_TRANSPORT, (String)object);
        if (this.id != null) {
            hashMap.put("sid", this.id);
        }
        Transport$Options transport$Options = new Transport$Options();
        new Transport$Options().sslContext = this.sslContext;
        transport$Options.hostname = this.hostname;
        transport$Options.port = this.port;
        transport$Options.secure = this.secure;
        transport$Options.path = this.path;
        transport$Options.query = hashMap;
        transport$Options.timestampRequests = this.timestampRequests;
        transport$Options.timestampParam = this.timestampParam;
        transport$Options.policyPort = this.policyPort;
        transport$Options.socket = this;
        transport$Options.hostnameVerifier = this.hostnameVerifier;
        transport$Options.proxy = this.proxy;
        transport$Options.proxyLogin = this.proxyLogin;
        transport$Options.proxyPassword = this.proxyPassword;
        if ("websocket".equals(object)) {
            object = new WebSocket(transport$Options);
        } else if ("polling".equals(object)) {
            object = new PollingXHR(transport$Options);
        } else {
            throw new RuntimeException();
        }
        this.emit(EVENT_TRANSPORT, object);
        return object;
    }

    private void setTransport(Transport transport) {
        logger.fine(String.format("setting transport %s", transport.name));
        Socket socket = this;
        if (this.transport != null) {
            logger.fine(String.format("clearing existing transport %s", this.transport.name));
            this.transport.off();
        }
        this.transport = transport;
        transport.on(EVENT_DRAIN, new Socket$6(this, socket)).on(EVENT_PACKET, new Socket$5(this, socket)).on(EVENT_ERROR, new Socket$4(this, socket)).on(EVENT_CLOSE, new Socket$3(this, socket));
    }

    private void probe(String object) {
        logger.fine(String.format("probing transport '%s'", object));
        Transport[] transportArray = new Transport[]{this.createTransport((String)object)};
        Object object2 = new boolean[]{false};
        Socket socket = this;
        priorWebsocketSuccess = false;
        Runnable[] runnableArray = new Runnable[1];
        Socket$7 socket$7 = new Socket$7(this, (boolean[])object2, (String)object, transportArray, socket, runnableArray);
        object2 = new Socket$8(this, (boolean[])object2, runnableArray, transportArray);
        object = new Socket$9(this, transportArray, (Emitter$Listener)object2, (String)object, socket);
        Socket$10 socket$10 = new Socket$10(this, (Emitter$Listener)object);
        Socket$11 socket$11 = new Socket$11(this, (Emitter$Listener)object);
        object2 = new Socket$12(this, transportArray, (Emitter$Listener)object2);
        runnableArray[0] = new Socket$13(this, transportArray, socket$7, (Emitter$Listener)object, socket$10, socket, socket$11, (Emitter$Listener)object2);
        transportArray[0].once(EVENT_OPEN, socket$7);
        transportArray[0].once(EVENT_ERROR, (Emitter$Listener)object);
        transportArray[0].once(EVENT_CLOSE, socket$10);
        this.once(EVENT_CLOSE, socket$11);
        this.once(EVENT_UPGRADING, (Emitter$Listener)object2);
        transportArray[0].open();
    }

    private void onOpen() {
        logger.fine("socket open");
        this.readyState = Socket$ReadyState.OPEN;
        priorWebsocketSuccess = "websocket".equals(this.transport.name);
        this.emit(EVENT_OPEN, new Object[0]);
        this.flush();
        if (this.readyState == Socket$ReadyState.OPEN && this.upgrade && this.transport instanceof Polling) {
            logger.fine("starting upgrade probes");
            for (String string : this.upgrades) {
                this.probe(string);
            }
        }
    }

    private void onPacket(Packet packet) {
        if (this.readyState == Socket$ReadyState.OPENING || this.readyState == Socket$ReadyState.OPEN) {
            logger.fine(String.format("socket received: type '%s', data '%s'", packet.type, packet.data));
            this.emit(EVENT_PACKET, packet);
            this.emit(EVENT_HEARTBEAT, new Object[0]);
            if (EVENT_OPEN.equals(packet.type)) {
                try {
                    this.onHandshake(new HandshakeData((String)packet.data));
                    return;
                }
                catch (JSONException jSONException) {
                    this.emit(EVENT_ERROR, new EngineIOException(jSONException));
                    return;
                }
            }
            if (EVENT_PONG.equals(packet.type)) {
                this.setPing();
                this.emit(EVENT_PONG, new Object[0]);
                return;
            }
            if (EVENT_ERROR.equals(packet.type)) {
                EngineIOException engineIOException = new EngineIOException("server error");
                new EngineIOException("server error").code = packet.data;
                this.onError(engineIOException);
                return;
            }
            if (EVENT_MESSAGE.equals(packet.type)) {
                this.emit(EVENT_DATA, packet.data);
                this.emit(EVENT_MESSAGE, packet.data);
                return;
            }
        } else {
            logger.fine(String.format("packet received with socket readyState '%s'", new Object[]{this.readyState}));
        }
    }

    private void onHandshake(HandshakeData handshakeData) {
        this.emit(EVENT_HANDSHAKE, handshakeData);
        this.id = handshakeData.sid;
        this.transport.query.put("sid", handshakeData.sid);
        this.upgrades = this.filterUpgrades(Arrays.asList(handshakeData.upgrades));
        this.pingInterval = handshakeData.pingInterval;
        this.pingTimeout = handshakeData.pingTimeout;
        this.onOpen();
        if (Socket$ReadyState.CLOSED == this.readyState) {
            return;
        }
        this.setPing();
        this.off(EVENT_HEARTBEAT, this.onHeartbeatAsListener);
        this.on(EVENT_HEARTBEAT, this.onHeartbeatAsListener);
    }

    private void onHeartbeat(long l2) {
        if (this.pingTimeoutTimer != null) {
            this.pingTimeoutTimer.cancel(false);
        }
        if (l2 <= 0L) {
            l2 = this.pingInterval + this.pingTimeout;
        }
        Socket socket = this;
        this.pingTimeoutTimer = this.getHeartbeatScheduler().schedule(new Socket$14(this, socket), l2, TimeUnit.MILLISECONDS);
    }

    private void setPing() {
        if (this.pingIntervalTimer != null) {
            this.pingIntervalTimer.cancel(false);
        }
        Socket socket = this;
        this.pingIntervalTimer = this.getHeartbeatScheduler().schedule(new Socket$15(this, socket), this.pingInterval, TimeUnit.MILLISECONDS);
    }

    private void ping() {
        EventThread.exec(new Socket$16(this));
    }

    private void onDrain() {
        for (int i2 = 0; i2 < this.prevBufferLen; ++i2) {
            this.writeBuffer.poll();
        }
        this.prevBufferLen = 0;
        if (0 == this.writeBuffer.size()) {
            this.emit(EVENT_DRAIN, new Object[0]);
            return;
        }
        this.flush();
    }

    private void flush() {
        if (this.readyState != Socket$ReadyState.CLOSED && this.transport.writable && !this.upgrading && this.writeBuffer.size() != 0) {
            logger.fine(String.format("flushing %d packets in socket", this.writeBuffer.size()));
            this.prevBufferLen = this.writeBuffer.size();
            this.transport.send(this.writeBuffer.toArray(new Packet[this.writeBuffer.size()]));
            this.emit(EVENT_FLUSH, new Object[0]);
        }
    }

    public void write(String string) {
        this.write(string, null);
    }

    public void write(String string, Runnable runnable) {
        this.send(string, runnable);
    }

    public void write(byte[] byArray) {
        this.write(byArray, null);
    }

    public void write(byte[] byArray, Runnable runnable) {
        this.send(byArray, runnable);
    }

    public void send(String string) {
        this.send(string, null);
    }

    public void send(byte[] byArray) {
        this.send(byArray, null);
    }

    public void send(String string, Runnable runnable) {
        EventThread.exec(new Socket$17(this, string, runnable));
    }

    public void send(byte[] byArray, Runnable runnable) {
        EventThread.exec(new Socket$18(this, byArray, runnable));
    }

    private void sendPacket(String string, Runnable runnable) {
        this.sendPacket(new Packet(string), runnable);
    }

    private void sendPacket(String object, String string, Runnable runnable) {
        object = new Packet<String>((String)object, string);
        this.sendPacket((Packet)object, runnable);
    }

    private void sendPacket(String object, byte[] byArray, Runnable runnable) {
        object = new Packet<byte[]>((String)object, byArray);
        this.sendPacket((Packet)object, runnable);
    }

    private void sendPacket(Packet packet, Runnable runnable) {
        if (Socket$ReadyState.CLOSING == this.readyState || Socket$ReadyState.CLOSED == this.readyState) {
            return;
        }
        this.emit(EVENT_PACKET_CREATE, packet);
        this.writeBuffer.offer(packet);
        if (runnable != null) {
            this.once(EVENT_FLUSH, new Socket$19(this, runnable));
        }
        this.flush();
    }

    public Socket close() {
        EventThread.exec(new Socket$20(this));
        return this;
    }

    private void onError(Exception exception) {
        logger.fine(String.format("socket error %s", exception));
        priorWebsocketSuccess = false;
        this.emit(EVENT_ERROR, exception);
        this.onClose("transport error", exception);
    }

    private void onClose(String string) {
        this.onClose(string, null);
    }

    private void onClose(String string, Exception exception) {
        if (Socket$ReadyState.OPENING == this.readyState || Socket$ReadyState.OPEN == this.readyState || Socket$ReadyState.CLOSING == this.readyState) {
            logger.fine(String.format("socket close with reason: %s", string));
            Socket socket = this;
            if (this.pingIntervalTimer != null) {
                this.pingIntervalTimer.cancel(false);
            }
            if (this.pingTimeoutTimer != null) {
                this.pingTimeoutTimer.cancel(false);
            }
            if (this.heartbeatScheduler != null) {
                this.heartbeatScheduler.shutdown();
            }
            this.transport.off(EVENT_CLOSE);
            this.transport.close();
            this.transport.off();
            this.readyState = Socket$ReadyState.CLOSED;
            this.id = null;
            this.emit(EVENT_CLOSE, string, exception);
            socket.writeBuffer.clear();
            socket.prevBufferLen = 0;
        }
    }

    List<String> filterUpgrades(List<String> object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (!this.transports.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public String id() {
        return this.id;
    }

    private ScheduledExecutorService getHeartbeatScheduler() {
        if (this.heartbeatScheduler == null || this.heartbeatScheduler.isShutdown()) {
            this.heartbeatScheduler = Executors.newSingleThreadScheduledExecutor();
        }
        return this.heartbeatScheduler;
    }

    static /* synthetic */ void access$000(Socket socket, long l2) {
        socket.onHeartbeat(l2);
    }

    static /* synthetic */ boolean access$200(Socket socket) {
        return socket.rememberUpgrade;
    }

    static /* synthetic */ boolean access$300() {
        return priorWebsocketSuccess;
    }

    static /* synthetic */ List access$400(Socket socket) {
        return socket.transports;
    }

    static /* synthetic */ Socket$ReadyState access$502(Socket socket, Socket$ReadyState socket$ReadyState) {
        socket.readyState = socket$ReadyState;
        return socket.readyState;
    }

    static /* synthetic */ Transport access$600(Socket socket, String string) {
        return socket.createTransport(string);
    }

    static /* synthetic */ void access$700(Socket socket, Transport transport) {
        socket.setTransport(transport);
    }

    static /* synthetic */ void access$800(Socket socket, String string) {
        socket.onClose(string);
    }

    static /* synthetic */ void access$900(Socket socket, Exception exception) {
        socket.onError(exception);
    }

    static /* synthetic */ void access$1000(Socket socket, Packet packet) {
        socket.onPacket(packet);
    }

    static /* synthetic */ void access$1100(Socket socket) {
        socket.onDrain();
    }

    static /* synthetic */ Logger access$1200() {
        return logger;
    }

    static /* synthetic */ boolean access$1302(Socket socket, boolean bl) {
        socket.upgrading = bl;
        return socket.upgrading;
    }

    static /* synthetic */ boolean access$302(boolean bl) {
        priorWebsocketSuccess = bl;
        return priorWebsocketSuccess;
    }

    static /* synthetic */ Socket$ReadyState access$500(Socket socket) {
        return socket.readyState;
    }

    static /* synthetic */ void access$1400(Socket socket) {
        socket.flush();
    }

    static /* synthetic */ long access$1500(Socket socket) {
        return socket.pingTimeout;
    }

    static /* synthetic */ void access$1600(Socket socket) {
        socket.ping();
    }

    static /* synthetic */ void access$1700(Socket socket, String string, Runnable runnable) {
        socket.sendPacket(string, runnable);
    }

    static /* synthetic */ void access$1800(Socket socket, String string, String string2, Runnable runnable) {
        socket.sendPacket(string, string2, runnable);
    }

    static /* synthetic */ void access$1900(Socket socket, String string, byte[] byArray, Runnable runnable) {
        socket.sendPacket(string, byArray, runnable);
    }

    static /* synthetic */ boolean access$1300(Socket socket) {
        return socket.upgrading;
    }
}

