/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.client;

import com.zoyi.io.socket.client.Ack;
import com.zoyi.io.socket.client.Manager;
import com.zoyi.io.socket.client.On$Handle;
import com.zoyi.io.socket.client.Socket$1;
import com.zoyi.io.socket.client.Socket$2;
import com.zoyi.io.socket.client.Socket$3;
import com.zoyi.io.socket.client.Socket$4;
import com.zoyi.io.socket.client.Socket$5;
import com.zoyi.io.socket.client.Socket$6;
import com.zoyi.io.socket.client.Socket$7;
import com.zoyi.io.socket.client.Socket$8;
import com.zoyi.io.socket.emitter.Emitter;
import com.zoyi.io.socket.parser.Packet;
import com.zoyi.io.socket.thread.EventThread;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Socket
extends Emitter {
    private static final Logger logger = Logger.getLogger(Socket.class.getName());
    public static final String EVENT_CONNECT = "connect";
    public static final String EVENT_CONNECTING = "connecting";
    public static final String EVENT_DISCONNECT = "disconnect";
    public static final String EVENT_ERROR = "error";
    public static final String EVENT_MESSAGE = "message";
    public static final String EVENT_CONNECT_ERROR = "connect_error";
    public static final String EVENT_CONNECT_TIMEOUT = "connect_timeout";
    public static final String EVENT_RECONNECT = "reconnect";
    public static final String EVENT_RECONNECT_ERROR = "reconnect_error";
    public static final String EVENT_RECONNECT_FAILED = "reconnect_failed";
    public static final String EVENT_RECONNECT_ATTEMPT = "reconnect_attempt";
    public static final String EVENT_RECONNECTING = "reconnecting";
    public static final String EVENT_PING = "ping";
    public static final String EVENT_PONG = "pong";
    protected static Map<String, Integer> events = new Socket$1();
    String id;
    private volatile boolean connected;
    private int ids;
    private String nsp;
    private Manager io;
    private Map<Integer, Ack> acks = new HashMap<Integer, Ack>();
    private Queue<On$Handle> subs;
    private final Queue<List<Object>> receiveBuffer = new LinkedList<List<Object>>();
    private final Queue<Packet<JSONArray>> sendBuffer = new LinkedList<Packet<JSONArray>>();

    public Socket(Manager manager, String string) {
        this.io = manager;
        this.nsp = string;
    }

    private void subEvents() {
        if (this.subs != null) {
            return;
        }
        Manager manager = this.io;
        this.subs = new Socket$2(this, manager);
    }

    public Socket open() {
        EventThread.exec(new Socket$3(this));
        return this;
    }

    public Socket connect() {
        return this.open();
    }

    public Socket send(Object ... objectArray) {
        EventThread.exec(new Socket$4(this, objectArray));
        return this;
    }

    @Override
    public Emitter emit(String string, Object ... objectArray) {
        EventThread.exec(new Socket$5(this, string, objectArray));
        return this;
    }

    private static JSONArray remove(JSONArray jSONArray, int n2) {
        JSONArray jSONArray2 = new JSONArray();
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            Object object;
            if (i2 == n2) continue;
            try {
                object = jSONArray.get(i2);
            }
            catch (JSONException jSONException) {
                object = null;
            }
            jSONArray2.put(object);
        }
        return jSONArray2;
    }

    public Emitter emit(String string, Object[] objectArray, Ack ack) {
        EventThread.exec(new Socket$6(this, string, objectArray, ack));
        return this;
    }

    private void packet(Packet packet) {
        packet.nsp = this.nsp;
        this.io.packet(packet);
    }

    private void onopen() {
        logger.fine("transport is open - connecting");
        if (!"/".equals(this.nsp)) {
            this.packet(new Packet(0));
        }
    }

    private void onclose(String string) {
        logger.fine(String.format("close (%s)", string));
        this.connected = false;
        this.id = null;
        this.emit(EVENT_DISCONNECT, string);
    }

    private void onpacket(Packet<?> packet) {
        if (!this.nsp.equals(packet.nsp)) {
            return;
        }
        switch (packet.type) {
            case 0: {
                this.onconnect();
                return;
            }
            case 2: {
                this.onevent(packet);
                return;
            }
            case 5: {
                this.onevent(packet);
                return;
            }
            case 3: {
                this.onack(packet);
                return;
            }
            case 6: {
                this.onack(packet);
                return;
            }
            case 1: {
                this.ondisconnect();
                return;
            }
            case 4: {
                this.emit(EVENT_ERROR, packet.data);
            }
        }
    }

    private void onevent(Packet<JSONArray> object) {
        ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(Socket.toArray((JSONArray)((Packet)object).data)));
        logger.fine(String.format("emitting event %s", arrayList));
        if (((Packet)object).id >= 0) {
            logger.fine("attaching ack callback to event");
            arrayList.add(this.ack(((Packet)object).id));
        }
        if (this.connected) {
            if (arrayList.isEmpty()) {
                return;
            }
            object = arrayList.remove(0).toString();
            super.emit((String)object, arrayList.toArray());
            return;
        }
        this.receiveBuffer.add(arrayList);
    }

    private Ack ack(int n2) {
        Socket socket = this;
        boolean[] blArray = new boolean[]{false};
        return new Socket$7(this, blArray, n2, socket);
    }

    private void onack(Packet<JSONArray> packet) {
        Ack ack = this.acks.remove(packet.id);
        if (ack != null) {
            logger.fine(String.format("calling ack %s with %s", packet.id, packet.data));
            ack.call(Socket.toArray((JSONArray)packet.data));
            return;
        }
        logger.fine(String.format("bad ack %s", packet.id));
    }

    private void onconnect() {
        this.connected = true;
        this.emit(EVENT_CONNECT, new Object[0]);
        this.emitBuffered();
    }

    private void emitBuffered() {
        Object object;
        List<Object> list;
        while ((list = this.receiveBuffer.poll()) != null) {
            object = (String)list.get(0);
            super.emit((String)object, list.toArray());
        }
        this.receiveBuffer.clear();
        while ((object = this.sendBuffer.poll()) != null) {
            this.packet((Packet)object);
        }
        this.sendBuffer.clear();
    }

    private void ondisconnect() {
        logger.fine(String.format("server disconnect (%s)", this.nsp));
        this.destroy();
        this.onclose("io server disconnect");
    }

    private void destroy() {
        if (this.subs != null) {
            for (On$Handle on$Handle : this.subs) {
                on$Handle.destroy();
            }
            this.subs = null;
        }
        this.io.destroy(this);
    }

    public Socket close() {
        EventThread.exec(new Socket$8(this));
        return this;
    }

    public Socket disconnect() {
        return this.close();
    }

    public Manager io() {
        return this.io;
    }

    public boolean connected() {
        return this.connected;
    }

    public String id() {
        return this.id;
    }

    private static Object[] toArray(JSONArray jSONArray) {
        int n2 = jSONArray.length();
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            try {
                object = jSONArray.get(i2);
            }
            catch (JSONException jSONException) {
                logger.log(Level.WARNING, "An error occured while retrieving data from JSONArray", jSONException);
                object = null;
            }
            objectArray[i2] = JSONObject.NULL.equals(object) ? null : object;
        }
        return objectArray;
    }

    static /* synthetic */ void access$000(Socket socket) {
        socket.onopen();
    }

    static /* synthetic */ void access$100(Socket socket, Packet packet) {
        socket.onpacket(packet);
    }

    static /* synthetic */ void access$200(Socket socket, String string) {
        socket.onclose(string);
    }

    static /* synthetic */ boolean access$300(Socket socket) {
        return socket.connected;
    }

    static /* synthetic */ void access$400(Socket socket) {
        socket.subEvents();
    }

    static /* synthetic */ Manager access$500(Socket socket) {
        return socket.io;
    }

    static /* synthetic */ Emitter access$601(Socket socket, String string, Object[] objectArray) {
        return super.emit(string, objectArray);
    }

    static /* synthetic */ int access$700(Socket socket) {
        return socket.ids;
    }

    static /* synthetic */ Logger access$800() {
        return logger;
    }

    static /* synthetic */ Map access$900(Socket socket) {
        return socket.acks;
    }

    static /* synthetic */ JSONArray access$1000(JSONArray jSONArray, int n2) {
        return Socket.remove(jSONArray, n2);
    }

    static /* synthetic */ int access$708(Socket socket) {
        return socket.ids++;
    }

    static /* synthetic */ void access$1100(Socket socket, Packet packet) {
        socket.packet(packet);
    }

    static /* synthetic */ Queue access$1200(Socket socket) {
        return socket.sendBuffer;
    }

    static /* synthetic */ String access$1300(Socket socket) {
        return socket.nsp;
    }

    static /* synthetic */ void access$1400(Socket socket) {
        socket.destroy();
    }
}

