/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.client;

import com.zoyi.io.socket.client.IO$Options;
import com.zoyi.io.socket.client.Manager;
import com.zoyi.io.socket.client.Manager$Options;
import com.zoyi.io.socket.client.Socket;
import com.zoyi.io.socket.client.Url;
import com.zoyi.io.socket.parser.Parser;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class IO {
    private static final Logger logger = Logger.getLogger(IO.class.getName());
    private static final ConcurrentHashMap<String, Manager> managers = new ConcurrentHashMap();
    public static int protocol = Parser.protocol;

    public static void setDefaultSSLContext(SSLContext sSLContext) {
        Manager.defaultSSLContext = sSLContext;
    }

    public static void setDefaultHostnameVerifier(HostnameVerifier hostnameVerifier) {
        Manager.defaultHostnameVerifier = hostnameVerifier;
    }

    private IO() {
    }

    public static Socket socket(String string) throws URISyntaxException {
        return IO.socket(string, null);
    }

    public static Socket socket(String string, IO$Options iO$Options) throws URISyntaxException {
        return IO.socket(new URI(string), iO$Options);
    }

    public static Socket socket(URI uRI) {
        return IO.socket(uRI, null);
    }

    public static Socket socket(URI serializable, IO$Options object) {
        URI uRI;
        if (object == null) {
            object = new IO$Options();
        }
        serializable = Url.parse((URI)serializable);
        try {
            uRI = ((URL)serializable).toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        String string = Url.extractId((URL)serializable);
        String string2 = ((URL)serializable).getPath();
        boolean bl = managers.containsKey(string) && IO.managers.get((Object)string).nsps.containsKey(string2);
        bl = ((IO$Options)object).forceNew || !((IO$Options)object).multiplex || bl;
        if (bl) {
            logger.fine(String.format("ignoring socket cache for %s", uRI));
            object = new Manager(uRI, (Manager$Options)object);
        } else {
            if (!managers.containsKey(string)) {
                logger.fine(String.format("new io instance for %s", uRI));
                managers.putIfAbsent(string, new Manager(uRI, (Manager$Options)object));
            }
            object = managers.get(string);
        }
        return ((Manager)object).socket(((URL)serializable).getPath());
    }
}

