/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.chat.ChatActivity;
import com.zoyi.channel.plugin.android.activity.userchat_list.b;
import com.zoyi.channel.plugin.android.activity.userchat_list.d;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatContract$Presenter;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatContract$View;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatPresenter;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.external.fab.FloatingActionButton;
import com.zoyi.channel.plugin.android.view.layout.BigBar$MenuPosition;
import com.zoyi.channel.plugin.android.view.layout.MenuButton$ActionType;
import com.zoyi.channel.plugin.android.view.layout.MenuButton$MenuState;
import com.zoyi.channel.plugin.android.view.layout.ProfileLayout;

public class UserChatListActivity
extends BaseActivity
implements View.OnClickListener,
UserChatContract$View {
    private RelativeLayout profileLayout;
    private RecyclerView recyclerView;
    private FloatingActionButton fab;
    private LinearLayout profileList;
    private View reconnectLayout;
    private String tempChatId;
    private d adapter;
    private boolean profileVisible = false;
    private UserChatContract$Presenter presenter;

    @Override
    protected void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        this.init(R.layout.ch_plugin_activity_user_chat_list);
        if (this.getIntent() != null) {
            this.tempChatId = this.getIntent().getStringExtra("chatId");
        }
        ((TextView)this.findViewById(R.id.text_powered)).setText((CharSequence)Html.fromHtml((String)this.getString(R.string.ch_plugin_powered_label)));
        this.profileLayout = (RelativeLayout)this.findViewById(R.id.layout_profile);
        this.profileLayout.setOnClickListener((View.OnClickListener)this);
        this.profileList = (LinearLayout)this.findViewById(R.id.layout_profile_list);
        this.reconnectLayout = this.findViewById(R.id.layout_reconnect);
        this.fab = (FloatingActionButton)this.findViewById(R.id.fab);
        this.fab.setOnClickListener(this);
        this.fab.hide(false);
        this.findViewById(R.id.button_agreement).setOnClickListener((View.OnClickListener)this);
        this.getBigBar().withActivity(this).addMenu(MenuButton$ActionType.EXIT, BigBar$MenuPosition.LEFT).addMenu(MenuButton$ActionType.REFRESH, BigBar$MenuPosition.RIGHT, MenuButton$MenuState.HIDDEN).addMenu(MenuButton$ActionType.MORE, BigBar$MenuPosition.RIGHT, MenuButton$MenuState.HIDDEN).build();
        this.adapter = new d();
        this.presenter = new UserChatPresenter((Context)this);
        this.presenter.setView(this);
        this.presenter.setAdapterView(this.adapter);
        this.presenter.setAdapterModel(this.adapter);
        bundle = new LinearLayoutManager((Context)this);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recycler_view);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)bundle);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.recyclerView.setItemAnimator(null);
        this.recyclerView.getRecycledViewPool().setMaxRecycledViews(0, 40);
        this.recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)new b(this, (LinearLayoutManager)bundle, -1));
        if (SocketManager.isError()) {
            this.setRefreshVisibility(true);
            this.setReconnectVisibility(true);
        }
        this.setStyle();
        this.presenter.getUserChats();
    }

    protected void onActivityResult(int n2, int n3, Intent intent) {
        if (n3 == 22 && this.adapter.getItemCount() == 0) {
            this.finish();
        }
    }

    protected void onStart() {
        this.presenter.setRunningChatId(null);
        super.onStart();
    }

    public void onBackPressed() {
        if (this.profileVisible) {
            this.setProfileLayout(false);
            return;
        }
        super.onBackPressed();
    }

    public void onClick(View view) {
        int n2 = view.getId();
        if (n2 == R.id.fab) {
            this.startChat(null, this.presenter.getChatCount(null), false);
        }
        if (n2 == R.id.layout_profile) {
            this.setProfileLayout(false);
        }
        if (n2 == R.id.button_agreement) {
            String string2 = "http://channel.io/ko/terms_user?channel=" + (ChannelStore.getChannel() != null ? ChannelStore.getChannel().getName() : "");
            Executor.goWeb((Context)this, string2);
        }
    }

    @Override
    public void optionClicked(MenuButton$ActionType menuButton$ActionType) {
        super.optionClicked(menuButton$ActionType);
        switch (menuButton$ActionType) {
            case REFRESH: {
                this.getBigBar().setMenuState(MenuButton$ActionType.REFRESH, MenuButton$MenuState.HIDDEN);
                this.presenter.refresh();
                return;
            }
            case MORE: {
                this.setProfileLayout(!this.profileVisible);
            }
        }
    }

    private void setStyle() {
        Channel channel = ChannelStore.getChannel();
        Plugin plugin = ChannelStore.getPlugin();
        if (channel == null || plugin == null) {
            this.finish();
            return;
        }
        this.setStatusBarColor(plugin.getBackgroundColor());
        this.getBigBar().setTheme(plugin.getBackgroundColor(), plugin.getTextColor());
        this.getBigBar().setTitle(channel.getName());
        this.fab.setColorNormal(plugin.getBackgroundColor());
        this.fab.setColorPressed(Utils.addBlackMask(plugin.getBackgroundColor()));
        this.fab.setColorRipple(-1);
        this.fab.setImageResource(plugin.getTextColor() == -16777216 ? R.drawable.ch_plugin_ic_add_black_24dp : R.drawable.ch_plugin_ic_add_white_24dp);
        this.fab.attachToRecyclerView(this.recyclerView);
    }

    public void setProfileLayout(boolean bl) {
        this.profileVisible = bl;
        if (bl) {
            this.fab.hide();
            this.setProfile();
            this.profileLayout.setVisibility(0);
            return;
        }
        this.fab.show();
        this.profileLayout.setVisibility(8);
    }

    private void setProfile() {
        ProfileLayout profileLayout;
        boolean bl = false;
        this.profileList.removeAllViews();
        ChannelStore.getUser();
        if (ChannelStore.getName() != null) {
            bl = true;
            profileLayout = new ProfileLayout((Context)this);
            profileLayout.set(ResUtils.getString((Context)this, "ch.user_profile.user_name"), ChannelStore.getName());
            this.profileList.addView((View)profileLayout);
        }
        if (ChannelStore.getMobileNumber() != null) {
            bl = true;
            profileLayout = new ProfileLayout((Context)this);
            profileLayout.set(ResUtils.getString((Context)this, "ch.user_profile.mobile_number"), ChannelStore.getMobileNumber());
            this.profileList.addView((View)profileLayout);
        }
        if (!bl) {
            profileLayout = new ProfileLayout((Context)this);
            profileLayout.set(ResUtils.getString((Context)this, "ch.user_profile.empty"), "");
            this.profileList.addView((View)profileLayout);
        }
    }

    @Override
    public void userChatsFetched(UserChatsWrapper userChatsWrapper) {
        this.getBigBar().setMenuState(MenuButton$ActionType.MORE, MenuButton$MenuState.VISIBLE);
        if (!this.profileVisible) {
            this.fab.show();
        }
        if (this.tempChatId != null) {
            this.startChat(this.tempChatId, this.presenter.getChatCount(this.tempChatId), false);
            this.tempChatId = null;
            return;
        }
        if (this.adapter.getItemCount() == 0) {
            this.startChat(null, 0, true);
        }
    }

    @Override
    public void startChat(String string2, int n2, boolean bl) {
        IntentUtils.setNextActivity((Context)this, ChatActivity.class).putExtra("chatId", string2).putExtra("chatCount", n2).putExtra("chatEmpty", bl).startActivityForResult(21);
    }

    @Override
    public void setRefreshVisibility(boolean bl) {
        this.getBigBar().setMenuState(MenuButton$ActionType.REFRESH, bl ? MenuButton$MenuState.VISIBLE : MenuButton$MenuState.HIDDEN);
    }

    @Override
    public void setReconnectVisibility(boolean bl) {
        this.reconnectLayout.setVisibility(UIUtils.getVisible(bl, true));
    }

    @Override
    public void setPresenter(UserChatContract$Presenter userChatContract$Presenter) {
    }

    @Override
    public void receiveCommand(Command command, Object object) {
        this.presenter.receiveCommand(command, object);
    }

    @Override
    public void receiveData(ChannelModel channelModel, boolean bl) {
        this.presenter.receiveData(channelModel, bl);
    }
}

