/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Application;
import android.content.Context;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.OnChannelPluginChangedListener;
import com.zoyi.channel.plugin.android.e;
import com.zoyi.channel.plugin.android.event.BadgeBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.f;
import com.zoyi.channel.plugin.android.g;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.h;
import com.zoyi.channel.plugin.android.i;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.Script;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.model.rest.Veil;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ChannelStore {
    private static ChannelStore channelStore;
    private Application application;
    private String pluginId;
    private Plugin plugin;
    private Channel channel;
    private User user;
    private Veil veil;
    private boolean mainRunning = false;
    private Subscription pluginFetchSubscription;
    private Subscription socketSubscription;
    private Map<String, Script> scriptMap;
    private ArrayList<OnChannelPluginChangedListener> listeners;

    static void create(Application application, String string2) {
        if (channelStore == null) {
            channelStore = new ChannelStore(application, string2);
        }
    }

    private ChannelStore(Application application, String string2) {
        this.application = application;
        this.pluginId = string2;
        this.listeners = new ArrayList();
    }

    static void checkIn(PluginWrapper pluginWrapper) {
        if (channelStore != null) {
            PrefSupervisor.setVeilId((Context)ChannelStore.channelStore.application, pluginWrapper.getVeilId());
            if (pluginWrapper.getUser() != null) {
                ChannelStore.channelStore.user = pluginWrapper.getUser();
            }
            ChannelStore.channelStore.plugin = pluginWrapper.getPlugin();
            ChannelStore.channelStore.channel = pluginWrapper.getChannel();
            ChannelStore.channelStore.veil = pluginWrapper.getVeil();
            channelStore.startReceiveSocket();
            channelStore.startFetchPlugin();
            channelStore.fetchScripts();
        }
    }

    static void clear() {
        if (channelStore != null) {
            channelStore.stopFetchPlugin();
            channelStore.stopReceiveSocket();
            ChannelStore.channelStore.plugin = null;
            ChannelStore.channelStore.channel = null;
            ChannelStore.channelStore.user = null;
            ChannelStore.channelStore.veil = null;
        }
    }

    private void startReceiveSocket() {
        if (this.socketSubscription == null || this.socketSubscription.isUnsubscribed()) {
            this.socketSubscription = RxBus.observable().onBackpressureBuffer().observeOn(AndroidSchedulers.mainThread()).subscribe(new e(this));
        }
    }

    private void stopReceiveSocket() {
        if (this.socketSubscription != null && !this.socketSubscription.isUnsubscribed()) {
            this.socketSubscription.unsubscribe();
            this.socketSubscription = null;
        }
    }

    private void fetchMe() {
        ChannelPlugin.getApi().getMe().subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new f(this));
    }

    private void startFetchPlugin() {
        this.stopFetchPlugin();
        this.pluginFetchSubscription = Observable.interval(3L, TimeUnit.MINUTES).subscribe(new g(this));
    }

    private void stopFetchPlugin() {
        if (this.pluginFetchSubscription != null && !this.pluginFetchSubscription.isUnsubscribed()) {
            this.pluginFetchSubscription.unsubscribe();
            this.pluginFetchSubscription = null;
        }
    }

    private void fetchPlugin() {
        if (this.pluginId != null) {
            ChannelPlugin.getApi().getPlugin(this.pluginId).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new h(this));
        }
    }

    private void fetchScripts() {
        ChannelPlugin.getApi().getScripts().subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new i(this));
    }

    private void setScripts(List<Script> object) {
        if (this.scriptMap == null) {
            this.scriptMap = new HashMap<String, Script>();
        }
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                Script script = (Script)object.next();
                if (script.getKey() == null || script.getMessage() == null) continue;
                this.scriptMap.put(script.getKey(), script);
            }
        }
    }

    public static String getScript(String string2, String string3) {
        if (channelStore != null) {
            if (ChannelStore.channelStore.scriptMap != null && ChannelStore.channelStore.scriptMap.containsKey(string2)) {
                String string4 = Locale.getDefault().getLanguage();
                if (ChannelStore.channelStore.scriptMap.get(string2).getMessage(string4) != null) {
                    return ChannelStore.channelStore.scriptMap.get(string2).getMessage(string4);
                }
            }
            if (ChannelStore.channelStore.application != null) {
                return ResUtils.getString((Context)ChannelStore.channelStore.application, string3);
            }
        }
        return "";
    }

    public static Channel getChannel() {
        if (channelStore != null) {
            return ChannelStore.channelStore.channel;
        }
        return null;
    }

    public static User getUser() {
        if (channelStore != null) {
            return ChannelStore.channelStore.user;
        }
        return null;
    }

    public static String getName() {
        if (channelStore != null) {
            if (ChannelStore.channelStore.user != null && !ChannelStore.channelStore.user.isGhost().booleanValue()) {
                return ChannelStore.channelStore.user.getName();
            }
            if (ChannelStore.channelStore.veil != null && !ChannelStore.channelStore.veil.isGhost()) {
                return ChannelStore.channelStore.veil.getName();
            }
        }
        return null;
    }

    public static String getMobileNumber() {
        if (channelStore != null) {
            if (ChannelStore.channelStore.user != null) {
                return ChannelStore.channelStore.user.getMobileNumber();
            }
            if (ChannelStore.channelStore.veil != null) {
                return ChannelStore.channelStore.veil.getMobileNumber();
            }
        }
        return null;
    }

    public static String getPersonType() {
        if (channelStore != null && ChannelStore.channelStore.user != null) {
            return "User";
        }
        return "Veil";
    }

    public static String getPersonId() {
        if (channelStore != null) {
            if (ChannelStore.channelStore.user != null) {
                return ChannelStore.channelStore.user.getId();
            }
            return PrefSupervisor.getVeilId((Context)ChannelStore.channelStore.application);
        }
        return null;
    }

    public static String getVeilId() {
        if (channelStore != null && ChannelStore.channelStore.application != null) {
            return PrefSupervisor.getVeilId((Context)ChannelStore.channelStore.application);
        }
        return null;
    }

    public static String getUserId() {
        if (channelStore != null && ChannelStore.channelStore.user != null) {
            return ChannelStore.channelStore.user.getId();
        }
        return null;
    }

    public static boolean isWorking() {
        return channelStore != null && ChannelStore.channelStore.channel != null && ChannelStore.channelStore.channel.isWorking();
    }

    public static boolean hasName() {
        if (channelStore != null) {
            if (ChannelStore.channelStore.user != null) {
                return ChannelStore.channelStore.user.isGhost() == false;
            }
            if (ChannelStore.channelStore.veil != null) {
                return !ChannelStore.channelStore.veil.isGhost();
            }
        }
        return true;
    }

    public static void setUserVeil(User user, Veil veil) {
        if (channelStore != null) {
            if (user != null) {
                ChannelStore.channelStore.user = user;
            }
            if (veil != null) {
                ChannelStore.channelStore.veil = veil;
            }
            RxBus.post(new BadgeBus(ChannelStore.getCount()));
        }
    }

    public static Plugin getPlugin() {
        if (channelStore != null) {
            return ChannelStore.channelStore.plugin;
        }
        return null;
    }

    public static String getPluginId() {
        if (channelStore != null) {
            return ChannelStore.channelStore.pluginId;
        }
        return null;
    }

    static void setMainRunning(boolean bl) {
        if (channelStore != null) {
            ChannelStore.channelStore.mainRunning = bl;
        }
    }

    public static boolean isMainRunning() {
        return channelStore != null && ChannelStore.channelStore.mainRunning;
    }

    static boolean isDataStored() {
        return channelStore != null && ChannelStore.channelStore.channel != null && ChannelStore.channelStore.plugin != null;
    }

    static int getCount() {
        if (channelStore != null) {
            if (ChannelStore.channelStore.user != null) {
                return ChannelStore.channelStore.user.getAlert();
            }
            if (ChannelStore.channelStore.veil != null) {
                return ChannelStore.channelStore.veil.getAlert();
            }
        }
        return 0;
    }

    static void addOnChannelPluginChangedListener(OnChannelPluginChangedListener onChannelPluginChangedListener) {
        if (channelStore != null && ChannelStore.channelStore.listeners != null) {
            ChannelStore.channelStore.listeners.add(onChannelPluginChangedListener);
        }
    }

    static void removeOnChannelPluginChangedListener(OnChannelPluginChangedListener onChannelPluginChangedListener) {
        if (channelStore != null && ChannelStore.channelStore.listeners != null) {
            ChannelStore.channelStore.listeners.remove(onChannelPluginChangedListener);
        }
    }

    static /* synthetic */ void access$000(ChannelStore channelStore) {
        channelStore.fetchMe();
    }

    static /* synthetic */ ArrayList access$100(ChannelStore channelStore) {
        return channelStore.listeners;
    }

    static /* synthetic */ ChannelStore access$200() {
        return channelStore;
    }

    static /* synthetic */ void access$300(ChannelStore channelStore) {
        channelStore.fetchPlugin();
    }

    static /* synthetic */ Plugin access$402(ChannelStore channelStore, Plugin plugin) {
        channelStore.plugin = plugin;
        return channelStore.plugin;
    }

    static /* synthetic */ Channel access$502(ChannelStore channelStore, Channel channel) {
        channelStore.channel = channel;
        return channelStore.channel;
    }

    static /* synthetic */ void access$600(ChannelStore channelStore, List list) {
        channelStore.setScripts(list);
    }
}

