package com.zoyi.channel.plugin.android.activity.settings;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.SwitchCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;

public class SettingsChatFragment extends Fragment implements View.OnClickListener {

  private boolean completed = false;
  private boolean changed = false;

  @Nullable
  @Override
  public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
    return inflater.inflate(R.layout.ch_plugin_fragment_settings_chat, container, false);
  }

  @Override
  public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
    super.onViewCreated(view, savedInstanceState);

    view.findViewById(R.id.tv_chat_close).setOnClickListener(this);

    completed = PrefSupervisor.isShownClosedChat(getActivity());

    SwitchCompat switchCompleted = (SwitchCompat) view.findViewById(R.id.sw_show_closed_chat);
    switchCompleted.setChecked(completed);
    switchCompleted.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
      @Override
      public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        if (completed == isChecked) {
          changed = false;
          getActivity().setResult(Activity.RESULT_CANCELED);
        } else {
          changed = true;
          getActivity().setResult(Const.RESULT_CHAT_OPTION_CHANGED);
        }
        PrefSupervisor.setShowClosedChat(getActivity(), isChecked);
      }
    });
  }

  @Override
  public void onClick(View v) {
    int id = v.getId();
    if (id == R.id.tv_chat_close) {
      Intent data = new Intent();
      data.putExtra(Const.EXTRA_CHANGED_SETTING, changed);

      getActivity().setResult(Const.RESULT_CHAT_REMOVE, data);
      getActivity().finish();
    }
  }
}
