/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.com.bumptech.glide.load.engine.prefill;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import com.zoyi.com.bumptech.glide.load.DecodeFormat;
import com.zoyi.com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.zoyi.com.bumptech.glide.load.engine.cache.MemoryCache;
import com.zoyi.com.bumptech.glide.load.engine.prefill.BitmapPreFillRunner;
import com.zoyi.com.bumptech.glide.load.engine.prefill.PreFillQueue;
import com.zoyi.com.bumptech.glide.load.engine.prefill.PreFillType;
import com.zoyi.com.bumptech.glide.util.Util;
import java.util.HashMap;

public final class BitmapPreFiller {
    private final MemoryCache memoryCache;
    private final BitmapPool bitmapPool;
    private final DecodeFormat defaultFormat;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private BitmapPreFillRunner current;

    public BitmapPreFiller(MemoryCache memoryCache, BitmapPool bitmapPool, DecodeFormat defaultFormat) {
        this.memoryCache = memoryCache;
        this.bitmapPool = bitmapPool;
        this.defaultFormat = defaultFormat;
    }

    public void preFill(PreFillType.Builder ... bitmapAttributeBuilders) {
        if (this.current != null) {
            this.current.cancel();
        }
        PreFillType[] bitmapAttributes = new PreFillType[bitmapAttributeBuilders.length];
        for (int i = 0; i < bitmapAttributeBuilders.length; ++i) {
            PreFillType.Builder builder = bitmapAttributeBuilders[i];
            if (builder.getConfig() == null) {
                builder.setConfig(this.defaultFormat == DecodeFormat.ALWAYS_ARGB_8888 || this.defaultFormat == DecodeFormat.PREFER_ARGB_8888 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565);
            }
            bitmapAttributes[i] = builder.build();
        }
        PreFillQueue allocationOrder = this.generateAllocationOrder(bitmapAttributes);
        this.current = new BitmapPreFillRunner(this.bitmapPool, this.memoryCache, allocationOrder);
        this.handler.post((Runnable)this.current);
    }

    PreFillQueue generateAllocationOrder(PreFillType[] preFillSizes) {
        int maxSize = this.memoryCache.getMaxSize() - this.memoryCache.getCurrentSize() + this.bitmapPool.getMaxSize();
        int totalWeight = 0;
        for (PreFillType size : preFillSizes) {
            totalWeight += size.getWeight();
        }
        float bytesPerWeight = (float)maxSize / (float)totalWeight;
        HashMap<PreFillType, Integer> attributeToCount = new HashMap<PreFillType, Integer>();
        for (PreFillType size : preFillSizes) {
            int bytesForSize = Math.round(bytesPerWeight * (float)size.getWeight());
            int bytesPerBitmap = BitmapPreFiller.getSizeInBytes(size);
            int bitmapsForSize = bytesForSize / bytesPerBitmap;
            attributeToCount.put(size, bitmapsForSize);
        }
        return new PreFillQueue(attributeToCount);
    }

    private static int getSizeInBytes(PreFillType size) {
        return Util.getBitmapByteSize(size.getWidth(), size.getHeight(), size.getConfig());
    }
}

