/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.util.atomic;

import com.zoyi.rx.internal.util.unsafe.Pow2;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class SpscUnboundedAtomicArrayQueue<T>
implements Queue<T> {
    static final int MAX_LOOK_AHEAD_STEP = Integer.getInteger("jctools.spsc.max.lookahead.step", 4096);
    final AtomicLong producerIndex;
    int producerLookAheadStep;
    long producerLookAhead;
    int producerMask;
    AtomicReferenceArray<Object> producerBuffer;
    int consumerMask;
    AtomicReferenceArray<Object> consumerBuffer;
    final AtomicLong consumerIndex;
    private static final Object HAS_NEXT = new Object();

    public SpscUnboundedAtomicArrayQueue(int bufferSize) {
        int p2capacity = Pow2.roundToPowerOfTwo(Math.max(8, bufferSize));
        int mask = p2capacity - 1;
        this.producerIndex = new AtomicLong();
        this.consumerIndex = new AtomicLong();
        AtomicReferenceArray buffer = new AtomicReferenceArray(p2capacity + 1);
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.adjustLookAheadStep(p2capacity);
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.producerLookAhead = mask - 1;
        this.soProducerIndex(0L);
    }

    @Override
    public boolean offer(T e) {
        if (e == null) {
            throw new NullPointerException();
        }
        AtomicReferenceArray<Object> buffer = this.producerBuffer;
        long index = this.lpProducerIndex();
        int mask = this.producerMask;
        int offset = SpscUnboundedAtomicArrayQueue.calcWrappedOffset(index, mask);
        if (index < this.producerLookAhead) {
            return this.writeToQueue(buffer, e, index, offset);
        }
        int lookAheadStep = this.producerLookAheadStep;
        int lookAheadElementOffset = SpscUnboundedAtomicArrayQueue.calcWrappedOffset(index + (long)lookAheadStep, mask);
        if (null == SpscUnboundedAtomicArrayQueue.lvElement(buffer, lookAheadElementOffset)) {
            this.producerLookAhead = index + (long)lookAheadStep - 1L;
            return this.writeToQueue(buffer, e, index, offset);
        }
        if (null != SpscUnboundedAtomicArrayQueue.lvElement(buffer, SpscUnboundedAtomicArrayQueue.calcWrappedOffset(index + 1L, mask))) {
            return this.writeToQueue(buffer, e, index, offset);
        }
        this.resize(buffer, index, offset, e, mask);
        return true;
    }

    private boolean writeToQueue(AtomicReferenceArray<Object> buffer, T e, long index, int offset) {
        this.soProducerIndex(index + 1L);
        SpscUnboundedAtomicArrayQueue.soElement(buffer, offset, e);
        return true;
    }

    private void resize(AtomicReferenceArray<Object> oldBuffer, long currIndex, int offset, T e, long mask) {
        int capacity = oldBuffer.length();
        AtomicReferenceArray<Object> newBuffer = new AtomicReferenceArray<Object>(capacity);
        this.producerBuffer = newBuffer;
        this.producerLookAhead = currIndex + mask - 1L;
        this.soProducerIndex(currIndex + 1L);
        SpscUnboundedAtomicArrayQueue.soElement(newBuffer, offset, e);
        this.soNext(oldBuffer, newBuffer);
        SpscUnboundedAtomicArrayQueue.soElement(oldBuffer, offset, HAS_NEXT);
    }

    private void soNext(AtomicReferenceArray<Object> curr, AtomicReferenceArray<Object> next) {
        SpscUnboundedAtomicArrayQueue.soElement(curr, SpscUnboundedAtomicArrayQueue.calcDirectOffset(curr.length() - 1), next);
    }

    private AtomicReferenceArray<Object> lvNext(AtomicReferenceArray<Object> curr) {
        return (AtomicReferenceArray)SpscUnboundedAtomicArrayQueue.lvElement(curr, SpscUnboundedAtomicArrayQueue.calcDirectOffset(curr.length() - 1));
    }

    @Override
    public T poll() {
        boolean isNextBuffer;
        int mask;
        AtomicReferenceArray<Object> buffer = this.consumerBuffer;
        long index = this.lpConsumerIndex();
        int offset = SpscUnboundedAtomicArrayQueue.calcWrappedOffset(index, mask = this.consumerMask);
        Object e = SpscUnboundedAtomicArrayQueue.lvElement(buffer, offset);
        boolean bl = isNextBuffer = e == HAS_NEXT;
        if (null != e && !isNextBuffer) {
            this.soConsumerIndex(index + 1L);
            SpscUnboundedAtomicArrayQueue.soElement(buffer, offset, null);
            return (T)e;
        }
        if (isNextBuffer) {
            return this.newBufferPoll(this.lvNext(buffer), index, mask);
        }
        return null;
    }

    private T newBufferPoll(AtomicReferenceArray<Object> nextBuffer, long index, int mask) {
        this.consumerBuffer = nextBuffer;
        int offsetInNew = SpscUnboundedAtomicArrayQueue.calcWrappedOffset(index, mask);
        Object n = SpscUnboundedAtomicArrayQueue.lvElement(nextBuffer, offsetInNew);
        if (null == n) {
            return null;
        }
        this.soConsumerIndex(index + 1L);
        SpscUnboundedAtomicArrayQueue.soElement(nextBuffer, offsetInNew, null);
        return (T)n;
    }

    @Override
    public T peek() {
        int mask;
        AtomicReferenceArray<Object> buffer = this.consumerBuffer;
        long index = this.lpConsumerIndex();
        int offset = SpscUnboundedAtomicArrayQueue.calcWrappedOffset(index, mask = this.consumerMask);
        Object e = SpscUnboundedAtomicArrayQueue.lvElement(buffer, offset);
        if (e == HAS_NEXT) {
            return this.newBufferPeek(this.lvNext(buffer), index, mask);
        }
        return (T)e;
    }

    @Override
    public void clear() {
        while (this.poll() != null || !this.isEmpty()) {
        }
    }

    private T newBufferPeek(AtomicReferenceArray<Object> nextBuffer, long index, int mask) {
        this.consumerBuffer = nextBuffer;
        int offsetInNew = SpscUnboundedAtomicArrayQueue.calcWrappedOffset(index, mask);
        return (T)SpscUnboundedAtomicArrayQueue.lvElement(nextBuffer, offsetInNew);
    }

    @Override
    public int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after);
    }

    @Override
    public boolean isEmpty() {
        return this.lvProducerIndex() == this.lvConsumerIndex();
    }

    private void adjustLookAheadStep(int capacity) {
        this.producerLookAheadStep = Math.min(capacity / 4, MAX_LOOK_AHEAD_STEP);
    }

    private long lvProducerIndex() {
        return this.producerIndex.get();
    }

    private long lvConsumerIndex() {
        return this.consumerIndex.get();
    }

    private long lpProducerIndex() {
        return this.producerIndex.get();
    }

    private long lpConsumerIndex() {
        return this.consumerIndex.get();
    }

    private void soProducerIndex(long v) {
        this.producerIndex.lazySet(v);
    }

    private void soConsumerIndex(long v) {
        this.consumerIndex.lazySet(v);
    }

    private static int calcWrappedOffset(long index, int mask) {
        return SpscUnboundedAtomicArrayQueue.calcDirectOffset((int)index & mask);
    }

    private static int calcDirectOffset(int index) {
        return index;
    }

    private static void soElement(AtomicReferenceArray<Object> buffer, int offset, Object e) {
        buffer.lazySet(offset, e);
    }

    private static <E> Object lvElement(AtomicReferenceArray<Object> buffer, int offset) {
        return buffer.get(offset);
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T element() {
        throw new UnsupportedOperationException();
    }
}

