/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.Button;
import android.widget.EditText;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;

public class WatchedEditText
extends EditText {
    private EditTextChangedListener listener;
    private boolean block = false;
    private Button button;
    private int activeColor;
    private int deactiveColor;

    public WatchedEditText(Context context) {
        super(context);
    }

    public WatchedEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public WatchedEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setWatchedTextChangedListener(EditTextChangedListener listener) {
        this.listener = listener;
        this.listener.onWatchedTextChanged(this.getText().toString());
    }

    public void setHandledButton(Button button, int activeColor, int deactiveColor) {
        this.button = button;
        this.activeColor = activeColor;
        this.deactiveColor = deactiveColor;
        this.setButtonStyle(this.getString());
    }

    protected void onSelectionChanged(int start, int end) {
        super.onSelectionChanged(start, end);
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
        if (this.listener != null && !this.block) {
            this.listener.onWatchedTextChanged(text.toString());
        }
        this.setButtonStyle(text.toString());
    }

    private void setButtonStyle(String text) {
        if (this.button != null) {
            if ("".equals(StringUtils.stripEnd(text, null))) {
                this.button.setEnabled(false);
                this.button.setTextColor(this.deactiveColor);
            } else {
                this.button.setEnabled(true);
                this.button.setTextColor(this.activeColor);
            }
        }
    }

    public void setTextWithBlock(String text) {
        this.block = true;
        this.setText(text);
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    public String getString() {
        return this.getText().toString();
    }

    public boolean isEmpty() {
        return TextUtils.isEmpty((CharSequence)this.getString());
    }
}

