/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;
import com.zoyi.com.bumptech.glide.DrawableRequestBuilder;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;

public abstract class ProfileLayout
extends FrameLayout {
    protected static final int DEFAULT_TEXT_SIZE = 16;
    protected ImageView back;
    protected ImageView image;
    protected TextView text;
    protected int textSize = 16;

    public ProfileLayout(Context context) {
        super(context);
    }

    public ProfileLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ProfileLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public ProfileLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(Context context, View root, AttributeSet attrs) {
        this.textSize = 16;
        this.back = (ImageView)root.findViewById(R.id.back_profile);
        this.image = (ImageView)root.findViewById(R.id.image_profile);
        this.text = (TextView)root.findViewById(R.id.text_profile);
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ProfileLayout, 0, 0);
            try {
                this.textSize = typedArray.getDimensionPixelSize(R.styleable.ProfileLayout_ch_initial_text_ize, this.textSize);
            }
            finally {
                typedArray.recycle();
            }
        }
        this.text.setTextSize(0, (float)this.textSize);
    }

    public void set(ProfileEntity entity) {
        if (entity == null) {
            this.image.setVisibility(8);
            this.back.setBackgroundColor(-16777216);
            this.text.setTextColor(-1);
            this.text.setText((CharSequence)"?");
            this.text.setVisibility(0);
        } else if (entity.getAvatarUrl() != null) {
            this.image.setVisibility(0);
            this.back.setBackgroundColor(-1);
            this.text.setVisibility(8);
            ((DrawableRequestBuilder)((DrawableRequestBuilder)((DrawableRequestBuilder)Glide.with(this.getContext()).load(entity.getAvatarUrl()).centerCrop()).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.RESULT)).into(this.image);
        } else {
            this.image.setVisibility(8);
            this.back.setBackgroundColor(entity.getBackgroundColor());
            this.text.setTextColor(entity.getTextColor());
            this.text.setText((CharSequence)entity.getInitial());
            this.text.setVisibility(0);
        }
    }

    public void setTextSize(int size) {
        if (this.text != null) {
            this.text.setTextSize(2, (float)size);
        }
    }
}

