/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.settings.edit;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.settings.edit.ProfileEditActivity;
import com.zoyi.channel.plugin.android.lib.CountryCodeDialog;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;
import java.util.Locale;

public class EditMobileNumberActivity
extends ProfileEditActivity
implements View.OnClickListener,
CountryCodeDialog.OnCountryCodeSelectListener {
    private String mobileNumber;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setBigBarTitle(ResUtils.getString((Context)this, "ch.settings.phone_number_placeholder"));
        this.textLabel.setText((CharSequence)ResUtils.getString((Context)this, "ch.settings.edit.phone_number_label"));
        this.editText.setHint(ResUtils.getString((Context)this, "ch.settings.edit.phone_number_placeholder"));
        this.textDescription.setText((CharSequence)ResUtils.getString((Context)this, "ch.settings.edit.phone_number_description"));
        this.textCountryCode.setOnClickListener((View.OnClickListener)this);
        this.editText.setInputType(8194);
        if (this.getIntent() != null) {
            String value = this.getIntent().getStringExtra("input_value");
            if (TextUtils.isEmpty((CharSequence)value)) {
                this.mobileNumber = this.textCountryCode.getText().toString();
            } else {
                this.mobileNumber = value;
                this.setMobileNumberAndCountryCode(this.mobileNumber);
            }
        }
        this.setEditTextPadding((int)Utils.dpToPx((Context)this, 6.0f));
    }

    @Override
    public void onWatchedTextChanged(String s) {
        if (TextUtils.isEmpty((CharSequence)(s = s.trim()))) {
            this.getBigBar().setMenuState(MenuButton.ActionType.DONE, MenuButton.MenuState.DISABLED);
        } else {
            this.getBigBar().setMenuState(MenuButton.ActionType.DONE, this.getMobileNumber().equals(this.mobileNumber) ? MenuButton.MenuState.DISABLED : MenuButton.MenuState.VISIBLE);
        }
    }

    @Override
    public void optionClicked(MenuButton.ActionType actionType) {
        super.optionClicked(actionType);
        switch (actionType) {
            case DONE: {
                this.presenter.updateUserMobileNumber(this.getMobileNumber());
            }
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.tv_edit_country_code) {
            new CountryCodeDialog((Context)this, this.textCountryCode.getText().toString(), this).show();
        }
    }

    @Override
    protected void setEditTextPadding(int padding) {
        this.editText.setPadding(padding, 0, padding, 0);
    }

    @Override
    public void onCountryCodeSelected(String countryCode) {
        this.textCountryCode.setText((CharSequence)String.format("+%s", countryCode));
    }

    private void setMobileNumberAndCountryCode(String mobileNumber) {
        if (TextUtils.isEmpty((CharSequence)mobileNumber)) {
            return;
        }
        try {
            Phonenumber.PhoneNumber phonenumber = PhoneNumberUtil.getInstance().parse(mobileNumber, "");
            String number = Long.toString(phonenumber.getNationalNumber());
            this.textCountryCode.setText((CharSequence)String.format(Locale.US, "+%d", phonenumber.getCountryCode()));
            this.editText.setText(number);
            this.editText.setSelection(number.length());
            this.onWatchedTextChanged(number);
        }
        catch (NumberParseException e) {
            e.printStackTrace();
        }
    }

    private String getMobileNumber() {
        return String.format("%s%s", this.textCountryCode.getText().toString(), this.editText.getString().trim());
    }
}

