package com.zoyi.channel.plugin.android.activity.userchat_list;

import com.zoyi.channel.plugin.android.activity.base.BaseDictionary;
import com.zoyi.channel.plugin.android.model.rest.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by mika on 2016. 12. 16..
 */
public class UserChatListDataDictionary extends BaseDictionary {
  private Map<String, Manager> managerMap;
  private Map<String, Session> sessionMap;
  private Map<String, Message> referMessageMap;

  UserChatListDataDictionary() {
    managerMap = new HashMap<>();
    sessionMap = new HashMap<>();
    referMessageMap = new HashMap<>();
  }

  public <E extends ChannelModel> E get(Class<E> clazz, String id) {
    if (id != null) {
      String className = clazz.getSimpleName();
      switch (className) {
        case Manager.CLASSNAME:
          return (E) managerMap.get(id);
        case Session.CLASSNAME:
          return (E) sessionMap.get(id);
        case ReferMessage.CLASSNAME:
          return (E) referMessageMap.get(id);
      }
    }
    return null;
  }

  public void add(List<? extends ChannelModel> channelModels) {
    if (channelModels != null) {
      for (ChannelModel channelModel : channelModels) {
        if (checkCanUpdate(channelModel)) {
          String className = channelModel.getClass().getSimpleName();
          switch (className) {
            case Manager.CLASSNAME:
              managerMap.put(channelModel.getId(), (Manager) channelModel);
              break;

            case Session.CLASSNAME:
              sessionMap.put(channelModel.getId(), (Session) channelModel);
              break;

            case ReferMessage.CLASSNAME:
              referMessageMap.put(channelModel.getId(), (Message) channelModel);
              break;
          }
        }
      }
    }
  }

  public void remove(ChannelModel channelModel) {
    String className = channelModel.getClass().getSimpleName();
    switch (className) {
      case Manager.CLASSNAME:
        if (managerMap.containsKey(channelModel.getId())) {
          managerMap.remove(channelModel.getId());
        }
        break;

      case Session.CLASSNAME:
        if (sessionMap.containsKey(channelModel.getId())) {
          sessionMap.remove(channelModel.getId());
        }
        break;

      case ReferMessage.CLASSNAME:
        if (referMessageMap.containsKey(channelModel.getId())) {
          referMessageMap.remove(channelModel.getId());
        }
        break;
    }
  }
}
