/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.OnGuestUpdatedListener;
import com.zoyi.channel.plugin.android.event.BadgeBus;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.PushBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.etc.PushEvent;
import com.zoyi.channel.plugin.android.model.wrapper.ChannelWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.GuestWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ChannelIOManager {
    @Nullable
    private static ChannelIOManager channelIOManager;
    private Application application;
    private int activityRunningCount = 0;
    @Nullable
    private Subscription channelFetchSubscription;
    @Nullable
    private Subscription socketSubscription;
    private List<ChannelPluginListener> listeners;

    static void create(Application application) {
        if (channelIOManager == null) {
            channelIOManager = new ChannelIOManager(application);
        }
    }

    private ChannelIOManager(Application application) {
        this.application = application;
        this.listeners = new ArrayList<ChannelPluginListener>();
    }

    static void bootPlugin(PluginWrapper pluginWrapper) {
        if (channelIOManager != null) {
            PrefSupervisor.setVeilId((Context)ChannelIOManager.channelIOManager.application, pluginWrapper.getVeilId());
            channelIOManager.startReceiveSocket();
            channelIOManager.startFetchChannel();
        }
    }

    static void clear() {
        if (channelIOManager != null) {
            channelIOManager.stopFetchChannel();
            channelIOManager.stopReceiveSocket();
        }
    }

    static void fetchMe(final @Nullable OnGuestUpdatedListener listener) {
        if (channelIOManager != null) {
            ChannelIO.getApi().getMe().subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<GuestWrapper>(){

                @Override
                public void onNext(GuestWrapper repo) {
                    if (repo != null) {
                        repo.update();
                        if (listener != null) {
                            listener.onGuestUpdated();
                        }
                    }
                }
            });
        }
    }

    private void startReceiveSocket() {
        if (this.socketSubscription == null || this.socketSubscription.isUnsubscribed()) {
            this.socketSubscription = RxBus.observable().subscribe((Action1)new Action1<Object>(){

                public void call(Object o) {
                    if (o instanceof CommandBus) {
                        CommandBus commandBus = (CommandBus)o;
                        switch (commandBus.getCommand()) {
                            case READY: {
                                ChannelIOManager.fetchMe(null);
                            }
                        }
                    }
                    if (o instanceof BadgeBus) {
                        for (ChannelPluginListener listener : ChannelIOManager.this.listeners) {
                            if (listener == null) continue;
                            listener.onChangeBadge(((BadgeBus)o).getCount());
                        }
                    }
                    if (o instanceof PushBus) {
                        PushBus pushBus = (PushBus)o;
                        for (ChannelPluginListener listener : ChannelIOManager.this.listeners) {
                            if (listener == null) continue;
                            listener.onReceivePush(new PushEvent(pushBus));
                        }
                    }
                }
            });
        }
    }

    private void stopReceiveSocket() {
        if (this.socketSubscription != null && !this.socketSubscription.isUnsubscribed()) {
            this.socketSubscription.unsubscribe();
        }
    }

    private void startFetchChannel() {
        this.stopFetchChannel();
        this.channelFetchSubscription = Observable.interval((long)3L, (TimeUnit)TimeUnit.MINUTES).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Long>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(Long aLong) {
                if (channelIOManager != null) {
                    channelIOManager.fetchChannel();
                }
            }
        });
    }

    private void stopFetchChannel() {
        if (this.channelFetchSubscription != null && !this.channelFetchSubscription.isUnsubscribed()) {
            this.channelFetchSubscription.unsubscribe();
        }
    }

    private void fetchChannel() {
        ChannelIO.getApi().getChannels().subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<ChannelWrapper>(){

            @Override
            public void onNext(ChannelWrapper repo) {
                if (repo != null) {
                    repo.update();
                }
            }
        });
    }

    public static void increaseActivityRunningCount() {
        if (channelIOManager != null) {
            ++ChannelIOManager.channelIOManager.activityRunningCount;
        }
    }

    public static void decreaseActivityRunningCount() {
        if (channelIOManager != null) {
            --ChannelIOManager.channelIOManager.activityRunningCount;
        }
    }

    public static boolean isMainRunning() {
        return channelIOManager != null && ChannelIOManager.channelIOManager.activityRunningCount > 0;
    }

    @NonNull
    static List<ChannelPluginListener> getChannelPluginListeners() {
        if (channelIOManager == null) {
            return new ArrayList<ChannelPluginListener>();
        }
        return ChannelIOManager.channelIOManager.listeners;
    }

    static void addChannelPluginListener(ChannelPluginListener listener) {
        if (channelIOManager != null && ChannelIOManager.channelIOManager.listeners != null && listener != null) {
            ChannelIOManager.channelIOManager.listeners.add(listener);
        }
    }

    static void removeChannelPluginListener(ChannelPluginListener listener) {
        if (channelIOManager != null && ChannelIOManager.channelIOManager.listeners != null && listener != null) {
            ChannelIOManager.channelIOManager.listeners.remove(listener);
        }
    }
}

