/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Completable;
import com.zoyi.rx.CompletableSubscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.internal.operators.CompletableOnSubscribeMerge;
import com.zoyi.rx.internal.util.atomic.MpscLinkedAtomicQueue;
import com.zoyi.rx.internal.util.unsafe.MpscLinkedQueue;
import com.zoyi.rx.internal.util.unsafe.UnsafeAccess;
import com.zoyi.rx.subscriptions.CompositeSubscription;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompletableOnSubscribeMergeDelayErrorIterable
implements Completable.OnSubscribe {
    final Iterable<? extends Completable> sources;

    public CompletableOnSubscribeMergeDelayErrorIterable(Iterable<? extends Completable> sources) {
        this.sources = sources;
    }

    @Override
    public void call(final CompletableSubscriber s) {
        Iterator<? extends Completable> iterator;
        final CompositeSubscription set = new CompositeSubscription();
        s.onSubscribe(set);
        try {
            iterator = this.sources.iterator();
        }
        catch (Throwable e) {
            s.onError(e);
            return;
        }
        if (iterator == null) {
            s.onError(new NullPointerException("The source iterator returned is null"));
            return;
        }
        final AtomicInteger wip = new AtomicInteger(1);
        final AbstractQueue queue = UnsafeAccess.isUnsafeAvailable() ? new MpscLinkedQueue() : new MpscLinkedAtomicQueue();
        while (true) {
            Completable c;
            boolean b;
            if (set.isUnsubscribed()) {
                return;
            }
            try {
                b = iterator.hasNext();
            }
            catch (Throwable e) {
                queue.offer(e);
                if (wip.decrementAndGet() == 0) {
                    if (queue.isEmpty()) {
                        s.onCompleted();
                    } else {
                        s.onError(CompletableOnSubscribeMerge.collectErrors(queue));
                    }
                }
                return;
            }
            if (!b) break;
            if (set.isUnsubscribed()) {
                return;
            }
            try {
                c = iterator.next();
            }
            catch (Throwable e) {
                queue.offer(e);
                if (wip.decrementAndGet() == 0) {
                    if (queue.isEmpty()) {
                        s.onCompleted();
                    } else {
                        s.onError(CompletableOnSubscribeMerge.collectErrors(queue));
                    }
                }
                return;
            }
            if (set.isUnsubscribed()) {
                return;
            }
            if (c == null) {
                NullPointerException e = new NullPointerException("A completable source is null");
                queue.offer(e);
                if (wip.decrementAndGet() == 0) {
                    if (queue.isEmpty()) {
                        s.onCompleted();
                    } else {
                        s.onError(CompletableOnSubscribeMerge.collectErrors(queue));
                    }
                }
                return;
            }
            wip.getAndIncrement();
            c.unsafeSubscribe(new CompletableSubscriber(){

                public void onSubscribe(Subscription d) {
                    set.add(d);
                }

                public void onError(Throwable e) {
                    queue.offer(e);
                    this.tryTerminate();
                }

                public void onCompleted() {
                    this.tryTerminate();
                }

                void tryTerminate() {
                    if (wip.decrementAndGet() == 0) {
                        if (queue.isEmpty()) {
                            s.onCompleted();
                        } else {
                            s.onError(CompletableOnSubscribeMerge.collectErrors(queue));
                        }
                    }
                }
            });
        }
        if (wip.decrementAndGet() == 0) {
            if (queue.isEmpty()) {
                s.onCompleted();
            } else {
                s.onError(CompletableOnSubscribeMerge.collectErrors(queue));
            }
        }
    }
}

