/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util.message_format.message;

import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.message_format.message.MessagePattern;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class EmojiMessage
implements MessagePattern {
    private Pattern emojiPattern = Pattern.compile("(:)([a-zA-Z0-9_+-]+?)\\1");
    @Nullable
    private JSONObject emojiMap;

    public EmojiMessage(@Nullable JSONObject emojiMap) {
        this.emojiMap = emojiMap;
    }

    @Override
    public SpannableStringBuilder parse(SpannableStringBuilder span) {
        Matcher matcher = this.emojiPattern.matcher((CharSequence)span);
        while (matcher.find()) {
            try {
                int start = matcher.start();
                int end = matcher.end();
                String emojiKey = span.toString().substring(start + 1, end - 1);
                if (this.emojiMap != null) {
                    try {
                        String emojiValue = (String)this.emojiMap.get(emojiKey);
                        span.delete(start, end);
                        span.insert(start, (CharSequence)emojiValue);
                    }
                    catch (JSONException e) {
                        L.e(e.toString());
                        return span;
                    }
                }
                matcher = this.emojiPattern.matcher((CharSequence)span);
            }
            catch (IndexOutOfBoundsException indexException) {
                L.e(indexException.getMessage());
                return span;
            }
        }
        return span;
    }
}

