package com.zoyi.channel.plugin.android.util.message_format.message;

import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.UnderlineSpan;
import android.util.Patterns;

import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.message_format.span.LinkSpan;
import com.zoyi.channel.plugin.android.util.message_format.type.LinkType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by jerry on 2018. 3. 27..
 */

public class LinkMessage implements MessagePattern {

  private final Pattern linkPattern = Pattern.compile("(\\[[^\\n<>\\[\\]]+])?<[^\\n<>\\[\\]]+>");
  private final Pattern expendedLinkPattern = Pattern.compile("\\[.+]<.+>");
  private final Pattern mentionPattern = Pattern.compile("<@[a-zA-Z0-9]+>");

  private int linkColor;

  public LinkMessage(int linkColor) {
    this.linkColor = linkColor;
  }

  @Override
  public SpannableStringBuilder parse(SpannableStringBuilder span) {

    Matcher linkMatcher = linkPattern.matcher(span);

    while (linkMatcher.find()) {
      try {
        int start = linkMatcher.start();
        int end = linkMatcher.end();

        String matchedText = span.toString().substring(start, end);
        String linkableText;
        String plainText = span.toString();
        Matcher expendedLinkMatcher = expendedLinkPattern.matcher(matchedText);

        if (expendedLinkMatcher.find()) {
          int center = plainText.indexOf("]<") + 1;
          linkableText = plainText.substring(center + 1, end - 1);

          span.delete(center, end);
          end = center;
          span.delete(end - 1, end);
          span.delete(start, start + 1);
        } else {
          linkableText = plainText.substring(start + 1, end - 1);

          span.delete(end - 1, end);
          span.delete(start, start + 1);
        }

        if (!mentionPattern.matcher(matchedText).find()) {
          span.setSpan(
              new LinkSpan(linkableText, getLinkType(linkableText), linkColor),
              start,
              end - 2,
              Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
          span.setSpan(new UnderlineSpan(), start, end - 2, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
        }

        linkMatcher = linkPattern.matcher(span);

      } catch (IndexOutOfBoundsException indexException) {
        L.e(indexException.getMessage());
        return span;
      }
    }

    return span;
  }

  private LinkType getLinkType(String linkText) {
    Matcher webMatcher = Patterns.WEB_URL.matcher(linkText);
    Matcher emailMatcher = Patterns.EMAIL_ADDRESS.matcher(linkText);
    Matcher phoneMatcher = Patterns.PHONE.matcher(linkText);

    if (emailMatcher.find()) {
      return LinkType.EMAIL;
    } else if (webMatcher.find()) {
      return LinkType.URL;
    } else if (phoneMatcher.find()) {
      return LinkType.PHONE;
    } else {
      return LinkType.PLAIN_TEXT;
    }
  }
}

