/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.view.View;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnSendingMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.UserMessageHolder;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.com.bumptech.glide.BitmapRequestBuilder;
import com.zoyi.com.bumptech.glide.Glide;

public class SendingMessageHolder
extends UserMessageHolder
implements View.OnClickListener {
    private View resendTextButton;
    private View resendImageButton;
    private OnSendingMessageClickListener onSendingMessageClickListener;

    public SendingMessageHolder(View itemView, OnSendingMessageClickListener listener, int backColor, int textColor) {
        super(itemView, null, backColor, textColor);
        this.onSendingMessageClickListener = listener;
        this.resendTextButton = itemView.findViewById(R.id.button_text_resend);
        this.resendImageButton = itemView.findViewById(R.id.button_image_resend);
        this.resendTextButton.setOnClickListener((View.OnClickListener)this);
        this.resendImageButton.setOnClickListener((View.OnClickListener)this);
    }

    public void set(SendingMessageItem item) {
        this.sendingMessageItem = item;
        this.message = null;
        this.setLayout(true, null);
        if (item.isImage()) {
            this.messageView.setVisibility(8);
            this.contentLayout.setVisibility(0);
            for (int i = 0; i < this.contentLayout.getChildCount(); ++i) {
                this.contentLayout.getChildAt(i).setVisibility(8);
            }
            ((BitmapRequestBuilder)((BitmapRequestBuilder)Glide.with(this.itemView.getContext()).load(item.getString()).asBitmap().dontAnimate()).centerCrop()).into(this.imageUploading);
            this.uploadLayout.setVisibility(0);
            this.imagePlaceholder.setVisibility(8);
            this.progressUpload.setVisibility(UIUtils.getVisible(item.isSending(), true));
            this.imageUploadFailed.setVisibility(UIUtils.getVisible(!item.isSending(), true));
        } else {
            this.messageView.setVisibility(0);
            this.contentLayout.setVisibility(8);
            this.setText(item.getString());
        }
        this.resendTextButton.setVisibility(UIUtils.getVisible(!item.isSending(), true));
        this.resendImageButton.setVisibility(UIUtils.getVisible(!item.isSending(), true));
    }

    @Override
    public void onClick(View v) {
        if (this.onSendingMessageClickListener != null && this.sendingMessageItem != null) {
            this.onSendingMessageClickListener.sendingMessageClicked(this.sendingMessageItem);
        }
    }
}

