/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListActivity;
import com.zoyi.channel.plugin.android.event.BadgeBus;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.PushBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.external.fab.FloatingActionButton;
import com.zoyi.channel.plugin.android.view.handler.SimpleAnimationListener;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;

public class ChannelView
extends RelativeLayout {
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    private int gravity;
    private int topMargin;
    private int bottomMargin;
    private int leftMargin;
    private int rightMargin;
    private View pushLayout;
    private AvatarLayout avatarLayout;
    private TextView textName;
    private TextView textMessage;
    private View fabLayout;
    private TextView badge;
    private FloatingActionButton fab;
    private Context context;
    private Animation pushAnimation;
    private Subscription subscription;
    private UserChat userChat;

    public ChannelView(Context context) {
        super(context);
        this.init(context, null);
    }

    public ChannelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ChannelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(final Context context, AttributeSet attrs) {
        this.context = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_channel_view, (ViewGroup)this);
        this.fabLayout = view.findViewById(R.id.fab_layout);
        this.badge = (TextView)view.findViewById(R.id.text_badge);
        this.fab = (FloatingActionButton)view.findViewById(R.id.fab);
        this.fab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChannelPlugin.launch(ChannelView.this.context);
            }
        });
        int defaultMargin = context.getResources().getDimensionPixelSize(R.dimen.ch_default_channel_button_margin);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ChannelView, 0, 0);
        try {
            this.gravity = a.getInteger(R.styleable.ChannelView_channel_button_gravity, 3);
            this.topMargin = a.getDimensionPixelSize(R.styleable.ChannelView_channel_button_top_margin, defaultMargin);
            this.bottomMargin = a.getDimensionPixelSize(R.styleable.ChannelView_channel_button_bottom_margin, defaultMargin);
            this.leftMargin = a.getDimensionPixelSize(R.styleable.ChannelView_channel_button_left_margin, defaultMargin);
            this.rightMargin = a.getDimensionPixelSize(R.styleable.ChannelView_channel_button_right_margin, defaultMargin);
            this.setTopMargin(this.topMargin);
            this.setBottomMargin(this.bottomMargin);
            this.setLeftMargin(this.leftMargin);
            this.setRightMargin(this.rightMargin);
            this.setButtonGravity(this.gravity);
        }
        finally {
            if (a != null) {
                a.recycle();
            }
        }
        this.pushLayout = view.findViewById(R.id.push_layout);
        this.avatarLayout = (AvatarLayout)view.findViewById(R.id.push_avatar);
        this.textName = (TextView)view.findViewById(R.id.push_name);
        this.textMessage = (TextView)view.findViewById(R.id.push_message);
        this.pushAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.ch_plugin_push);
        this.pushAnimation.setAnimationListener((Animation.AnimationListener)new SimpleAnimationListener(){

            @Override
            public void onAnimationStart(Animation animation) {
                ChannelView.this.pushLayout.setVisibility(0);
            }

            @Override
            public void onAnimationEnd(Animation animation) {
                ChannelView.this.hidePush();
            }
        });
        view.findViewById(R.id.push_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChannelView.this.hidePush();
            }
        });
        this.pushLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String chatId = ChannelView.this.userChat != null ? ChannelView.this.userChat.getId() : null;
                IntentUtils.setNextActivity(context, UserChatListActivity.class).putExtra("chatId", chatId).startActivity();
            }
        });
    }

    public void setButtonGravity(int gravity) {
        if (!CompareUtils.exists((Comparable)Integer.valueOf(gravity), (Comparable[])new Integer[]{0, 1, 2, 3})) {
            return;
        }
        this.gravity = gravity;
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.fabLayout.getLayoutParams();
        switch (gravity) {
            case 0: 
            case 1: {
                params.addRule(10);
                params.addRule(12, 0);
                break;
            }
            case 2: 
            case 3: {
                params.addRule(12);
                params.addRule(10, 0);
            }
        }
        switch (gravity) {
            case 0: 
            case 2: {
                if (Build.VERSION.SDK_INT >= 17) {
                    params.addRule(20);
                    params.addRule(21, 0);
                }
                params.addRule(9);
                params.addRule(11, 0);
                break;
            }
            case 1: 
            case 3: {
                if (Build.VERSION.SDK_INT >= 17) {
                    params.addRule(20, 0);
                    params.addRule(21);
                }
                params.addRule(9, 0);
                params.addRule(11);
            }
        }
        this.fabLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        this.fabLayout.requestLayout();
        this.badge.bringToFront();
    }

    public void setTopMargin(int topMargin) {
        this.topMargin = topMargin;
        this.refreshSize();
    }

    public void setBottomMargin(int bottomMargin) {
        this.bottomMargin = bottomMargin;
        this.refreshSize();
    }

    public void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
        this.refreshSize();
    }

    public void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
        this.refreshSize();
    }

    private void refreshSize() {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.fabLayout.getLayoutParams();
        switch (this.gravity) {
            case 0: {
                params.setMargins(this.leftMargin, this.topMargin, 0, 0);
                break;
            }
            case 1: {
                params.setMargins(0, this.topMargin, this.rightMargin, 0);
                break;
            }
            case 2: {
                params.setMargins(this.leftMargin, 0, 0, this.bottomMargin);
                break;
            }
            case 3: {
                params.setMargins(0, 0, this.rightMargin, this.bottomMargin);
            }
        }
        this.fabLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        this.fabLayout.requestLayout();
        this.badge.bringToFront();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.subscription = RxBus.observable().onBackpressureBuffer().observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<Object>(){

            public void call(Object o) {
                if (o instanceof CommandBus) {
                    CommandBus commandBus = (CommandBus)o;
                    switch (commandBus.getCommand()) {
                        case CHECKED_IN: {
                            if (commandBus.getObject() == null || !(commandBus.getObject() instanceof Plugin)) break;
                            ChannelView.this.checkedIn((Plugin)commandBus.getObject());
                            break;
                        }
                        case CHECKED_OUT: {
                            ChannelView.this.checkedOut();
                        }
                    }
                }
                if (o instanceof PushBus && !ChannelStore.isMainRunning()) {
                    PushBus pushBus = (PushBus)o;
                    ChannelView.this.showPush(pushBus.getProfileEntity(), pushBus.getMessage(), pushBus.getUserChat());
                }
                if (o instanceof BadgeBus) {
                    ChannelView.this.setBadge(((BadgeBus)o).getCount());
                }
            }
        });
        if (ChannelStore.getPlugin() != null) {
            this.checkedIn(ChannelStore.getPlugin());
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.subscription != null && !this.subscription.isUnsubscribed()) {
            this.subscription.unsubscribe();
        }
    }

    private void checkedIn(Plugin plugin) {
        if (plugin != null) {
            this.setVisibility(0);
            this.fab.setColorNormal(plugin.getBackgroundColor());
            this.fab.setColorPressed(Utils.addBlackMask(plugin.getBackgroundColor()));
            this.fab.setColorRipple(-1);
            this.fab.setImageResource(plugin.getTextColor() == -16777216 ? R.drawable.ch_plugin_balloon_black : R.drawable.ch_plugin_balloon);
            this.refreshCount();
            this.fabLayout.setVisibility(0);
        }
    }

    public void refreshCount() {
        this.setBadge(ChannelStore.getCount());
    }

    private void setBadge(int count) {
        if (count <= 0) {
            this.badge.setVisibility(8);
        } else {
            this.badge.setVisibility(0);
            this.badge.setText((CharSequence)Utils.getCount(count, true));
        }
    }

    private void checkedOut() {
        this.setVisibility(8);
    }

    private void showPush(ProfileEntity person, String message, UserChat userChat) {
        this.userChat = userChat;
        this.avatarLayout.set(person);
        if (person != null && person.getName() != null) {
            this.textName.setText((CharSequence)person.getName());
        } else {
            this.textName.setText((CharSequence)ResUtils.getString(this.context, "ch.unknown"));
        }
        this.textMessage.setText((CharSequence)(message != null ? message : ""));
        this.pushLayout.setVisibility(0);
        this.pushLayout.startAnimation(this.pushAnimation);
    }

    private void hidePush() {
        this.userChat = null;
        this.pushLayout.clearAnimation();
        this.pushLayout.setVisibility(8);
    }
}

