/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.external.photoview;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import com.zoyi.channel.plugin.android.view.external.photoview.DefaultOnDoubleTapListener;
import com.zoyi.channel.plugin.android.view.external.photoview.IPhotoView;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher$1;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher$AnimatedZoomRunnable;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher$FlingRunnable;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher$OnMatrixChangedListener;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher$OnPhotoTapListener;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher$OnScaleChangeListener;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher$OnSingleFlingListener;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher$OnViewTapListener;
import com.zoyi.channel.plugin.android.view.external.photoview.gestures.GestureDetector;
import com.zoyi.channel.plugin.android.view.external.photoview.gestures.OnGestureListener;
import com.zoyi.channel.plugin.android.view.external.photoview.gestures.VersionedGestureDetector;
import com.zoyi.channel.plugin.android.view.external.photoview.log.LogManager;
import java.lang.ref.WeakReference;

public class PhotoViewAttacher
implements View.OnTouchListener,
ViewTreeObserver.OnGlobalLayoutListener,
IPhotoView,
OnGestureListener {
    private static final String LOG_TAG = "PhotoViewAttacher";
    private static final boolean DEBUG = Log.isLoggable((String)"PhotoViewAttacher", (int)3);
    private Interpolator mInterpolator = new AccelerateDecelerateInterpolator();
    int ZOOM_DURATION = 200;
    static final int EDGE_NONE = -1;
    static final int EDGE_LEFT = 0;
    static final int EDGE_RIGHT = 1;
    static final int EDGE_BOTH = 2;
    static int SINGLE_TOUCH = 1;
    private float mMinScale = 1.0f;
    private float mMidScale = 1.75f;
    private float mMaxScale = 3.0f;
    private boolean mAllowParentInterceptOnEdge = true;
    private boolean mBlockParentIntercept = false;
    private WeakReference<ImageView> mImageView;
    private android.view.GestureDetector mGestureDetector;
    private GestureDetector mScaleDragDetector;
    private final Matrix mBaseMatrix = new Matrix();
    private final Matrix mDrawMatrix = new Matrix();
    private final Matrix mSuppMatrix = new Matrix();
    private final RectF mDisplayRect = new RectF();
    private final float[] mMatrixValues = new float[9];
    private PhotoViewAttacher$OnMatrixChangedListener mMatrixChangeListener;
    private PhotoViewAttacher$OnPhotoTapListener mPhotoTapListener;
    private PhotoViewAttacher$OnViewTapListener mViewTapListener;
    private View.OnLongClickListener mLongClickListener;
    private PhotoViewAttacher$OnScaleChangeListener mScaleChangeListener;
    private PhotoViewAttacher$OnSingleFlingListener mSingleFlingListener;
    private int mIvTop;
    private int mIvRight;
    private int mIvBottom;
    private int mIvLeft;
    private PhotoViewAttacher$FlingRunnable mCurrentFlingRunnable;
    private int mScrollEdge = 2;
    private float mBaseRotation;
    private boolean mZoomEnabled;
    private ImageView.ScaleType mScaleType = ImageView.ScaleType.FIT_CENTER;

    private static void checkZoomLevels(float f2, float f3, float f4) {
        if (f2 >= f3) {
            throw new IllegalArgumentException("Minimum zoom has to be less than Medium zoom. Call setMinimumZoom() with a more appropriate value");
        }
        if (f3 >= f4) {
            throw new IllegalArgumentException("Medium zoom has to be less than Maximum zoom. Call setMaximumZoom() with a more appropriate value");
        }
    }

    private static boolean hasDrawable(ImageView imageView) {
        return imageView != null && null != imageView.getDrawable();
    }

    private static boolean isSupportedScaleType(ImageView.ScaleType scaleType) {
        if (scaleType == null) {
            return false;
        }
        switch (scaleType) {
            case MATRIX: {
                throw new IllegalArgumentException(scaleType.name() + " is not supported in PhotoView");
            }
        }
        return true;
    }

    private static void setImageViewScaleTypeMatrix(ImageView imageView) {
        if (imageView != null && !(imageView instanceof IPhotoView) && !ImageView.ScaleType.MATRIX.equals((Object)imageView.getScaleType())) {
            imageView.setScaleType(ImageView.ScaleType.MATRIX);
        }
    }

    public PhotoViewAttacher(ImageView imageView) {
        this(imageView, true);
    }

    public PhotoViewAttacher(ImageView imageView, boolean bl) {
        this.mImageView = new WeakReference<ImageView>(imageView);
        imageView.setDrawingCacheEnabled(true);
        imageView.setOnTouchListener((View.OnTouchListener)this);
        ViewTreeObserver viewTreeObserver = imageView.getViewTreeObserver();
        if (viewTreeObserver != null) {
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        PhotoViewAttacher.setImageViewScaleTypeMatrix(imageView);
        if (imageView.isInEditMode()) {
            return;
        }
        this.mScaleDragDetector = VersionedGestureDetector.newInstance(imageView.getContext(), this);
        this.mGestureDetector = new android.view.GestureDetector(imageView.getContext(), (GestureDetector.OnGestureListener)new PhotoViewAttacher$1(this));
        this.mGestureDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)new DefaultOnDoubleTapListener(this));
        this.mBaseRotation = 0.0f;
        this.setZoomable(bl);
    }

    @Override
    public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener onDoubleTapListener) {
        if (onDoubleTapListener != null) {
            this.mGestureDetector.setOnDoubleTapListener(onDoubleTapListener);
            return;
        }
        this.mGestureDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)new DefaultOnDoubleTapListener(this));
    }

    @Override
    public void setOnScaleChangeListener(PhotoViewAttacher$OnScaleChangeListener photoViewAttacher$OnScaleChangeListener) {
        this.mScaleChangeListener = photoViewAttacher$OnScaleChangeListener;
    }

    @Override
    public void setOnSingleFlingListener(PhotoViewAttacher$OnSingleFlingListener photoViewAttacher$OnSingleFlingListener) {
        this.mSingleFlingListener = photoViewAttacher$OnSingleFlingListener;
    }

    @Override
    public boolean canZoom() {
        return this.mZoomEnabled;
    }

    public void cleanup() {
        if (this.mImageView == null) {
            return;
        }
        ImageView imageView = (ImageView)this.mImageView.get();
        if (imageView != null) {
            ViewTreeObserver viewTreeObserver = imageView.getViewTreeObserver();
            if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            imageView.setOnTouchListener(null);
            this.cancelFling();
        }
        if (this.mGestureDetector != null) {
            this.mGestureDetector.setOnDoubleTapListener(null);
        }
        this.mMatrixChangeListener = null;
        this.mPhotoTapListener = null;
        this.mViewTapListener = null;
        this.mImageView = null;
    }

    @Override
    public RectF getDisplayRect() {
        this.checkMatrixBounds();
        return this.getDisplayRect(this.getDrawMatrix());
    }

    @Override
    public boolean setDisplayMatrix(Matrix matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException("Matrix cannot be null");
        }
        ImageView imageView = this.getImageView();
        if (imageView == null) {
            return false;
        }
        if (null == imageView.getDrawable()) {
            return false;
        }
        this.mSuppMatrix.set(matrix);
        this.setImageViewMatrix(this.getDrawMatrix());
        this.checkMatrixBounds();
        return true;
    }

    public void setBaseRotation(float f2) {
        this.mBaseRotation = f2 % 360.0f;
        this.update();
        this.setRotationBy(this.mBaseRotation);
        this.checkAndDisplayMatrix();
    }

    @Override
    public void setRotationTo(float f2) {
        this.mSuppMatrix.setRotate(f2 % 360.0f);
        this.checkAndDisplayMatrix();
    }

    @Override
    public void setRotationBy(float f2) {
        this.mSuppMatrix.postRotate(f2 % 360.0f);
        this.checkAndDisplayMatrix();
    }

    public ImageView getImageView() {
        ImageView imageView = null;
        if (this.mImageView != null) {
            imageView = (ImageView)this.mImageView.get();
        }
        if (imageView == null) {
            this.cleanup();
            LogManager.getLogger().i(LOG_TAG, "ImageView no longer exists. You should not use this PhotoViewAttacher any more.");
        }
        return imageView;
    }

    @Override
    public float getMinimumScale() {
        return this.mMinScale;
    }

    @Override
    public float getMediumScale() {
        return this.mMidScale;
    }

    @Override
    public float getMaximumScale() {
        return this.mMaxScale;
    }

    @Override
    public float getScale() {
        return (float)Math.sqrt((float)Math.pow(this.getValue(this.mSuppMatrix, 0), 2.0) + (float)Math.pow(this.getValue(this.mSuppMatrix, 3), 2.0));
    }

    @Override
    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    @Override
    public void onDrag(float f2, float f3) {
        if (this.mScaleDragDetector.isScaling()) {
            return;
        }
        if (DEBUG) {
            LogManager.getLogger().d(LOG_TAG, String.format("onDrag: dx: %.2f. dy: %.2f", Float.valueOf(f2), Float.valueOf(f3)));
        }
        ImageView imageView = this.getImageView();
        this.mSuppMatrix.postTranslate(f2, f3);
        this.checkAndDisplayMatrix();
        ViewParent viewParent = imageView.getParent();
        if (this.mAllowParentInterceptOnEdge && !this.mScaleDragDetector.isScaling() && !this.mBlockParentIntercept) {
            if ((this.mScrollEdge == 2 || this.mScrollEdge == 0 && f2 >= 1.0f || this.mScrollEdge == 1 && f2 <= -1.0f) && viewParent != null) {
                viewParent.requestDisallowInterceptTouchEvent(false);
                return;
            }
        } else if (viewParent != null) {
            viewParent.requestDisallowInterceptTouchEvent(true);
        }
    }

    @Override
    public void onFling(float f2, float f3, float f4, float f5) {
        if (DEBUG) {
            LogManager.getLogger().d(LOG_TAG, "onFling. sX: " + f2 + " sY: " + f3 + " Vx: " + f4 + " Vy: " + f5);
        }
        ImageView imageView = this.getImageView();
        this.mCurrentFlingRunnable = new PhotoViewAttacher$FlingRunnable(this, imageView.getContext());
        this.mCurrentFlingRunnable.fling(this.getImageViewWidth(imageView), this.getImageViewHeight(imageView), (int)f4, (int)f5);
        imageView.post((Runnable)this.mCurrentFlingRunnable);
    }

    public void onGlobalLayout() {
        ImageView imageView = this.getImageView();
        if (imageView != null) {
            if (this.mZoomEnabled) {
                int n2 = imageView.getTop();
                int n3 = imageView.getRight();
                int n4 = imageView.getBottom();
                int n5 = imageView.getLeft();
                if (n2 != this.mIvTop || n4 != this.mIvBottom || n5 != this.mIvLeft || n3 != this.mIvRight) {
                    this.updateBaseMatrix(imageView.getDrawable());
                    this.mIvTop = n2;
                    this.mIvRight = n3;
                    this.mIvBottom = n4;
                    this.mIvLeft = n5;
                }
                return;
            }
            this.updateBaseMatrix(imageView.getDrawable());
        }
    }

    @Override
    public void onScale(float f2, float f3, float f4) {
        if (DEBUG) {
            LogManager.getLogger().d(LOG_TAG, String.format("onScale: scale: %.2f. fX: %.2f. fY: %.2f", Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4)));
        }
        if ((this.getScale() < this.mMaxScale || f2 < 1.0f) && (this.getScale() > this.mMinScale || f2 > 1.0f)) {
            if (this.mScaleChangeListener != null) {
                this.mScaleChangeListener.onScaleChange(f2, f3, f4);
            }
            this.mSuppMatrix.postScale(f2, f2, f3, f4);
            this.checkAndDisplayMatrix();
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View view, MotionEvent motionEvent) {
        boolean bl = false;
        if (this.mZoomEnabled && PhotoViewAttacher.hasDrawable((ImageView)view)) {
            ViewParent viewParent = view.getParent();
            switch (motionEvent.getAction()) {
                case 0: {
                    if (viewParent != null) {
                        viewParent.requestDisallowInterceptTouchEvent(true);
                    } else {
                        LogManager.getLogger().i(LOG_TAG, "onTouch getParent() returned null");
                    }
                    this.cancelFling();
                    break;
                }
                case 1: 
                case 3: {
                    if (!(this.getScale() < this.mMinScale) || (viewParent = this.getDisplayRect()) == null) break;
                    view.post((Runnable)new PhotoViewAttacher$AnimatedZoomRunnable(this, this.getScale(), this.mMinScale, viewParent.centerX(), viewParent.centerY()));
                    bl = true;
                }
            }
            if (this.mScaleDragDetector != null) {
                boolean bl2 = this.mScaleDragDetector.isScaling();
                boolean bl3 = this.mScaleDragDetector.isDragging();
                bl = this.mScaleDragDetector.onTouchEvent(motionEvent);
                bl2 = !bl2 && !this.mScaleDragDetector.isScaling();
                bl3 = !bl3 && !this.mScaleDragDetector.isDragging();
                boolean bl4 = this.mBlockParentIntercept = bl2 && bl3;
            }
            if (this.mGestureDetector != null && this.mGestureDetector.onTouchEvent(motionEvent)) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void setAllowParentInterceptOnEdge(boolean bl) {
        this.mAllowParentInterceptOnEdge = bl;
    }

    @Override
    public void setMinimumScale(float f2) {
        PhotoViewAttacher.checkZoomLevels(f2, this.mMidScale, this.mMaxScale);
        this.mMinScale = f2;
    }

    @Override
    public void setMediumScale(float f2) {
        PhotoViewAttacher.checkZoomLevels(this.mMinScale, f2, this.mMaxScale);
        this.mMidScale = f2;
    }

    @Override
    public void setMaximumScale(float f2) {
        PhotoViewAttacher.checkZoomLevels(this.mMinScale, this.mMidScale, f2);
        this.mMaxScale = f2;
    }

    @Override
    public void setScaleLevels(float f2, float f3, float f4) {
        PhotoViewAttacher.checkZoomLevels(f2, f3, f4);
        this.mMinScale = f2;
        this.mMidScale = f3;
        this.mMaxScale = f4;
    }

    @Override
    public void setOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.mLongClickListener = onLongClickListener;
    }

    @Override
    public void setOnMatrixChangeListener(PhotoViewAttacher$OnMatrixChangedListener photoViewAttacher$OnMatrixChangedListener) {
        this.mMatrixChangeListener = photoViewAttacher$OnMatrixChangedListener;
    }

    @Override
    public void setOnPhotoTapListener(PhotoViewAttacher$OnPhotoTapListener photoViewAttacher$OnPhotoTapListener) {
        this.mPhotoTapListener = photoViewAttacher$OnPhotoTapListener;
    }

    @Nullable
    PhotoViewAttacher$OnPhotoTapListener getOnPhotoTapListener() {
        return this.mPhotoTapListener;
    }

    @Override
    public void setOnViewTapListener(PhotoViewAttacher$OnViewTapListener photoViewAttacher$OnViewTapListener) {
        this.mViewTapListener = photoViewAttacher$OnViewTapListener;
    }

    @Nullable
    PhotoViewAttacher$OnViewTapListener getOnViewTapListener() {
        return this.mViewTapListener;
    }

    @Override
    public void setScale(float f2) {
        this.setScale(f2, false);
    }

    @Override
    public void setScale(float f2, boolean bl) {
        ImageView imageView = this.getImageView();
        if (imageView != null) {
            this.setScale(f2, imageView.getRight() / 2, imageView.getBottom() / 2, bl);
        }
    }

    @Override
    public void setScale(float f2, float f3, float f4, boolean bl) {
        ImageView imageView = this.getImageView();
        if (imageView != null) {
            if (f2 < this.mMinScale || f2 > this.mMaxScale) {
                LogManager.getLogger().i(LOG_TAG, "Scale must be within the range of minScale and maxScale");
                return;
            }
            if (bl) {
                imageView.post((Runnable)new PhotoViewAttacher$AnimatedZoomRunnable(this, this.getScale(), f2, f3, f4));
                return;
            }
            this.mSuppMatrix.setScale(f2, f2, f3, f4);
            this.checkAndDisplayMatrix();
        }
    }

    public void setZoomInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    @Override
    public void setScaleType(ImageView.ScaleType scaleType) {
        if (PhotoViewAttacher.isSupportedScaleType(scaleType) && scaleType != this.mScaleType) {
            this.mScaleType = scaleType;
            this.update();
        }
    }

    @Override
    public void setZoomable(boolean bl) {
        this.mZoomEnabled = bl;
        this.update();
    }

    public void update() {
        ImageView imageView = this.getImageView();
        if (imageView != null) {
            if (this.mZoomEnabled) {
                PhotoViewAttacher.setImageViewScaleTypeMatrix(imageView);
                this.updateBaseMatrix(imageView.getDrawable());
                return;
            }
            this.resetMatrix();
        }
    }

    @Override
    public void getDisplayMatrix(Matrix matrix) {
        matrix.set(this.getDrawMatrix());
    }

    public void getSuppMatrix(Matrix matrix) {
        matrix.set(this.mSuppMatrix);
    }

    private Matrix getDrawMatrix() {
        this.mDrawMatrix.set(this.mBaseMatrix);
        this.mDrawMatrix.postConcat(this.mSuppMatrix);
        return this.mDrawMatrix;
    }

    private void cancelFling() {
        if (this.mCurrentFlingRunnable != null) {
            this.mCurrentFlingRunnable.cancelFling();
            this.mCurrentFlingRunnable = null;
        }
    }

    public Matrix getImageMatrix() {
        return this.mDrawMatrix;
    }

    private void checkAndDisplayMatrix() {
        if (this.checkMatrixBounds()) {
            this.setImageViewMatrix(this.getDrawMatrix());
        }
    }

    private void checkImageViewScaleType() {
        ImageView imageView = this.getImageView();
        if (imageView != null && !(imageView instanceof IPhotoView) && !ImageView.ScaleType.MATRIX.equals((Object)imageView.getScaleType())) {
            throw new IllegalStateException("The ImageView's ScaleType has been changed since attaching a PhotoViewAttacher. You should call setScaleType on the PhotoViewAttacher instead of on the ImageView");
        }
    }

    private boolean checkMatrixBounds() {
        ImageView imageView = this.getImageView();
        if (imageView == null) {
            return false;
        }
        RectF rectF = this.getDisplayRect(this.getDrawMatrix());
        if (rectF == null) {
            return false;
        }
        float f2 = rectF.height();
        float f3 = rectF.width();
        float f4 = 0.0f;
        float f5 = 0.0f;
        int n2 = this.getImageViewHeight(imageView);
        if (f2 <= (float)n2) {
            switch (this.mScaleType) {
                case FIT_START: {
                    f5 = -rectF.top;
                    break;
                }
                case FIT_END: {
                    f5 = (float)n2 - f2 - rectF.top;
                    break;
                }
                default: {
                    f5 = ((float)n2 - f2) / 2.0f - rectF.top;
                    break;
                }
            }
        } else if (rectF.top > 0.0f) {
            f5 = -rectF.top;
        } else if (rectF.bottom < (float)n2) {
            f5 = (float)n2 - rectF.bottom;
        }
        int n3 = this.getImageViewWidth(imageView);
        if (f3 <= (float)n3) {
            switch (this.mScaleType) {
                case FIT_START: {
                    f4 = -rectF.left;
                    break;
                }
                case FIT_END: {
                    f4 = (float)n3 - f3 - rectF.left;
                    break;
                }
                default: {
                    f4 = ((float)n3 - f3) / 2.0f - rectF.left;
                }
            }
            this.mScrollEdge = 2;
        } else if (rectF.left > 0.0f) {
            this.mScrollEdge = 0;
            f4 = -rectF.left;
        } else if (rectF.right < (float)n3) {
            f4 = (float)n3 - rectF.right;
            this.mScrollEdge = 1;
        } else {
            this.mScrollEdge = -1;
        }
        this.mSuppMatrix.postTranslate(f4, f5);
        return true;
    }

    private RectF getDisplayRect(Matrix matrix) {
        ImageView imageView = this.getImageView();
        if (imageView != null && (imageView = imageView.getDrawable()) != null) {
            this.mDisplayRect.set(0.0f, 0.0f, (float)imageView.getIntrinsicWidth(), (float)imageView.getIntrinsicHeight());
            matrix.mapRect(this.mDisplayRect);
            return this.mDisplayRect;
        }
        return null;
    }

    @Override
    public Bitmap getVisibleRectangleBitmap() {
        ImageView imageView = this.getImageView();
        if (imageView == null) {
            return null;
        }
        return imageView.getDrawingCache();
    }

    @Override
    public void setZoomTransitionDuration(int n2) {
        if (n2 < 0) {
            n2 = 200;
        }
        this.ZOOM_DURATION = n2;
    }

    @Override
    public IPhotoView getIPhotoViewImplementation() {
        return this;
    }

    private float getValue(Matrix matrix, int n2) {
        matrix.getValues(this.mMatrixValues);
        return this.mMatrixValues[n2];
    }

    private void resetMatrix() {
        this.mSuppMatrix.reset();
        this.setRotationBy(this.mBaseRotation);
        this.setImageViewMatrix(this.getDrawMatrix());
        this.checkMatrixBounds();
    }

    private void setImageViewMatrix(Matrix matrix) {
        ImageView imageView = this.getImageView();
        if (imageView != null) {
            this.checkImageViewScaleType();
            imageView.setImageMatrix(matrix);
            if (this.mMatrixChangeListener != null && (matrix = this.getDisplayRect(matrix)) != null) {
                this.mMatrixChangeListener.onMatrixChanged((RectF)matrix);
            }
        }
    }

    private void updateBaseMatrix(Drawable drawable2) {
        ImageView imageView = this.getImageView();
        if (imageView == null || drawable2 == null) {
            return;
        }
        float f2 = this.getImageViewWidth(imageView);
        float f3 = this.getImageViewHeight(imageView);
        int n2 = drawable2.getIntrinsicWidth();
        int n3 = drawable2.getIntrinsicHeight();
        this.mBaseMatrix.reset();
        float f4 = f2 / (float)n2;
        float f5 = f3 / (float)n3;
        if (this.mScaleType == ImageView.ScaleType.CENTER) {
            this.mBaseMatrix.postTranslate((f2 - (float)n2) / 2.0f, (f3 - (float)n3) / 2.0f);
        } else if (this.mScaleType == ImageView.ScaleType.CENTER_CROP) {
            f4 = Math.max(f4, f5);
            this.mBaseMatrix.postScale(f4, f4);
            this.mBaseMatrix.postTranslate((f2 - (float)n2 * f4) / 2.0f, (f3 - (float)n3 * f4) / 2.0f);
        } else if (this.mScaleType == ImageView.ScaleType.CENTER_INSIDE) {
            f4 = Math.min(1.0f, Math.min(f4, f5));
            this.mBaseMatrix.postScale(f4, f4);
            this.mBaseMatrix.postTranslate((f2 - (float)n2 * f4) / 2.0f, (f3 - (float)n3 * f4) / 2.0f);
        } else {
            RectF rectF = new RectF(0.0f, 0.0f, (float)n2, (float)n3);
            RectF rectF2 = new RectF(0.0f, 0.0f, f2, f3);
            if ((int)this.mBaseRotation % 180 != 0) {
                rectF = new RectF(0.0f, 0.0f, (float)n3, (float)n2);
            }
            switch (this.mScaleType) {
                case FIT_CENTER: {
                    this.mBaseMatrix.setRectToRect(rectF, rectF2, Matrix.ScaleToFit.CENTER);
                    break;
                }
                case FIT_START: {
                    this.mBaseMatrix.setRectToRect(rectF, rectF2, Matrix.ScaleToFit.START);
                    break;
                }
                case FIT_END: {
                    this.mBaseMatrix.setRectToRect(rectF, rectF2, Matrix.ScaleToFit.END);
                    break;
                }
                case FIT_XY: {
                    this.mBaseMatrix.setRectToRect(rectF, rectF2, Matrix.ScaleToFit.FILL);
                }
            }
        }
        this.resetMatrix();
    }

    private int getImageViewWidth(ImageView imageView) {
        if (imageView == null) {
            return 0;
        }
        return imageView.getWidth() - imageView.getPaddingLeft() - imageView.getPaddingRight();
    }

    private int getImageViewHeight(ImageView imageView) {
        if (imageView == null) {
            return 0;
        }
        return imageView.getHeight() - imageView.getPaddingTop() - imageView.getPaddingBottom();
    }

    static /* synthetic */ View.OnLongClickListener access$000(PhotoViewAttacher photoViewAttacher) {
        return photoViewAttacher.mLongClickListener;
    }

    static /* synthetic */ PhotoViewAttacher$OnSingleFlingListener access$100(PhotoViewAttacher photoViewAttacher) {
        return photoViewAttacher.mSingleFlingListener;
    }

    static /* synthetic */ Interpolator access$200(PhotoViewAttacher photoViewAttacher) {
        return photoViewAttacher.mInterpolator;
    }

    static /* synthetic */ boolean access$300() {
        return DEBUG;
    }

    static /* synthetic */ Matrix access$400(PhotoViewAttacher photoViewAttacher) {
        return photoViewAttacher.mSuppMatrix;
    }

    static /* synthetic */ Matrix access$500(PhotoViewAttacher photoViewAttacher) {
        return photoViewAttacher.getDrawMatrix();
    }

    static /* synthetic */ void access$600(PhotoViewAttacher photoViewAttacher, Matrix matrix) {
        photoViewAttacher.setImageViewMatrix(matrix);
    }
}

