/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation;

import android.os.Looper;
import android.util.AndroidRuntimeException;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.Animator;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.Animator$AnimatorListener;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.FloatEvaluator;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.IntEvaluator;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.PropertyValuesHolder;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.TypeEvaluator;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.ValueAnimator$1;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.ValueAnimator$2;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.ValueAnimator$3;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.ValueAnimator$4;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.ValueAnimator$5;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.ValueAnimator$AnimationHandler;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.ValueAnimator$AnimatorUpdateListener;
import java.util.ArrayList;
import java.util.HashMap;

public class ValueAnimator
extends Animator {
    private static final long DEFAULT_FRAME_DELAY = 10L;
    static final int ANIMATION_START = 0;
    static final int ANIMATION_FRAME = 1;
    static final int STOPPED = 0;
    static final int RUNNING = 1;
    static final int SEEKED = 2;
    long mStartTime;
    long mSeekTime = -1L;
    private static ThreadLocal<ValueAnimator$AnimationHandler> sAnimationHandler = new ThreadLocal();
    private static final ThreadLocal<ArrayList<ValueAnimator>> sAnimations = new ValueAnimator$1();
    private static final ThreadLocal<ArrayList<ValueAnimator>> sPendingAnimations = new ValueAnimator$2();
    private static final ThreadLocal<ArrayList<ValueAnimator>> sDelayedAnims = new ValueAnimator$3();
    private static final ThreadLocal<ArrayList<ValueAnimator>> sEndingAnims = new ValueAnimator$4();
    private static final ThreadLocal<ArrayList<ValueAnimator>> sReadyAnims = new ValueAnimator$5();
    private static final Interpolator sDefaultInterpolator = new AccelerateDecelerateInterpolator();
    private static final TypeEvaluator sIntEvaluator = new IntEvaluator();
    private static final TypeEvaluator sFloatEvaluator = new FloatEvaluator();
    private boolean mPlayingBackwards = false;
    private int mCurrentIteration = 0;
    private float mCurrentFraction = 0.0f;
    private boolean mStartedDelay = false;
    private long mDelayStartTime;
    int mPlayingState = 0;
    private boolean mRunning = false;
    private boolean mStarted = false;
    boolean mInitialized = false;
    private long mDuration = 300L;
    private long mStartDelay = 0L;
    private static long sFrameDelay = 10L;
    private int mRepeatCount = 0;
    private int mRepeatMode = 1;
    private Interpolator mInterpolator = sDefaultInterpolator;
    private ArrayList<ValueAnimator$AnimatorUpdateListener> mUpdateListeners = null;
    PropertyValuesHolder[] mValues;
    HashMap<String, PropertyValuesHolder> mValuesMap;
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    public static final int INFINITE = -1;

    public static ValueAnimator ofInt(int ... nArray) {
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setIntValues(nArray);
        return valueAnimator;
    }

    public static ValueAnimator ofFloat(float ... fArray) {
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setFloatValues(fArray);
        return valueAnimator;
    }

    public static ValueAnimator ofPropertyValuesHolder(PropertyValuesHolder ... propertyValuesHolderArray) {
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setValues(propertyValuesHolderArray);
        return valueAnimator;
    }

    public static ValueAnimator ofObject(TypeEvaluator typeEvaluator, Object ... objectArray) {
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setObjectValues(objectArray);
        valueAnimator.setEvaluator(typeEvaluator);
        return valueAnimator;
    }

    public void setIntValues(int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofInt("", nArray));
        } else {
            PropertyValuesHolder propertyValuesHolder = this.mValues[0];
            propertyValuesHolder.setIntValues(nArray);
        }
        this.mInitialized = false;
    }

    public void setFloatValues(float ... fArray) {
        if (fArray == null || fArray.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofFloat("", fArray));
        } else {
            PropertyValuesHolder propertyValuesHolder = this.mValues[0];
            propertyValuesHolder.setFloatValues(fArray);
        }
        this.mInitialized = false;
    }

    public void setObjectValues(Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofObject("", null, objectArray));
        } else {
            PropertyValuesHolder propertyValuesHolder = this.mValues[0];
            propertyValuesHolder.setObjectValues(objectArray);
        }
        this.mInitialized = false;
    }

    public void setValues(PropertyValuesHolder ... propertyValuesHolderArray) {
        int n2 = propertyValuesHolderArray.length;
        this.mValues = propertyValuesHolderArray;
        this.mValuesMap = new HashMap(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            PropertyValuesHolder propertyValuesHolder = propertyValuesHolderArray[i2];
            this.mValuesMap.put(propertyValuesHolder.getPropertyName(), propertyValuesHolder);
        }
        this.mInitialized = false;
    }

    public PropertyValuesHolder[] getValues() {
        return this.mValues;
    }

    void initAnimation() {
        if (!this.mInitialized) {
            int n2 = this.mValues.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.mValues[i2].init();
            }
            this.mInitialized = true;
        }
    }

    @Override
    public ValueAnimator setDuration(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + l2);
        }
        this.mDuration = l2;
        return this;
    }

    @Override
    public long getDuration() {
        return this.mDuration;
    }

    public void setCurrentPlayTime(long l2) {
        this.initAnimation();
        long l3 = AnimationUtils.currentAnimationTimeMillis();
        if (this.mPlayingState != 1) {
            this.mSeekTime = l2;
            this.mPlayingState = 2;
        }
        this.mStartTime = l3 - l2;
        this.animationFrame(l3);
    }

    public long getCurrentPlayTime() {
        if (!this.mInitialized || this.mPlayingState == 0) {
            return 0L;
        }
        return AnimationUtils.currentAnimationTimeMillis() - this.mStartTime;
    }

    @Override
    public long getStartDelay() {
        return this.mStartDelay;
    }

    @Override
    public void setStartDelay(long l2) {
        this.mStartDelay = l2;
    }

    public static long getFrameDelay() {
        return sFrameDelay;
    }

    public static void setFrameDelay(long l2) {
        sFrameDelay = l2;
    }

    public Object getAnimatedValue() {
        if (this.mValues != null && this.mValues.length > 0) {
            return this.mValues[0].getAnimatedValue();
        }
        return null;
    }

    public Object getAnimatedValue(String object) {
        if ((object = this.mValuesMap.get(object)) != null) {
            return ((PropertyValuesHolder)object).getAnimatedValue();
        }
        return null;
    }

    public void setRepeatCount(int n2) {
        this.mRepeatCount = n2;
    }

    public int getRepeatCount() {
        return this.mRepeatCount;
    }

    public void setRepeatMode(int n2) {
        this.mRepeatMode = n2;
    }

    public int getRepeatMode() {
        return this.mRepeatMode;
    }

    public void addUpdateListener(ValueAnimator$AnimatorUpdateListener valueAnimator$AnimatorUpdateListener) {
        if (this.mUpdateListeners == null) {
            this.mUpdateListeners = new ArrayList();
        }
        this.mUpdateListeners.add(valueAnimator$AnimatorUpdateListener);
    }

    public void removeAllUpdateListeners() {
        if (this.mUpdateListeners == null) {
            return;
        }
        this.mUpdateListeners.clear();
        this.mUpdateListeners = null;
    }

    public void removeUpdateListener(ValueAnimator$AnimatorUpdateListener valueAnimator$AnimatorUpdateListener) {
        if (this.mUpdateListeners == null) {
            return;
        }
        this.mUpdateListeners.remove(valueAnimator$AnimatorUpdateListener);
        if (this.mUpdateListeners.size() == 0) {
            this.mUpdateListeners = null;
        }
    }

    @Override
    public void setInterpolator(Interpolator interpolator) {
        if (interpolator != null) {
            this.mInterpolator = interpolator;
            return;
        }
        this.mInterpolator = new LinearInterpolator();
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void setEvaluator(TypeEvaluator typeEvaluator) {
        if (typeEvaluator != null && this.mValues != null && this.mValues.length > 0) {
            this.mValues[0].setEvaluator(typeEvaluator);
        }
    }

    private void start(boolean bl) {
        ValueAnimator$AnimationHandler valueAnimator$AnimationHandler;
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        this.mPlayingBackwards = bl;
        this.mCurrentIteration = 0;
        this.mPlayingState = 0;
        this.mStarted = true;
        this.mStartedDelay = false;
        sPendingAnimations.get().add(this);
        if (this.mStartDelay == 0L) {
            this.setCurrentPlayTime(this.getCurrentPlayTime());
            this.mPlayingState = 0;
            this.mRunning = true;
            if (this.mListeners != null) {
                ArrayList arrayList = (ArrayList)this.mListeners.clone();
                int n2 = arrayList.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    ((Animator$AnimatorListener)arrayList.get(i2)).onAnimationStart(this);
                }
            }
        }
        if ((valueAnimator$AnimationHandler = sAnimationHandler.get()) == null) {
            valueAnimator$AnimationHandler = new ValueAnimator$AnimationHandler(null);
            sAnimationHandler.set(valueAnimator$AnimationHandler);
        }
        valueAnimator$AnimationHandler.sendEmptyMessage(0);
    }

    @Override
    public void start() {
        this.start(false);
    }

    @Override
    public void cancel() {
        if (this.mPlayingState != 0 || sPendingAnimations.get().contains(this) || sDelayedAnims.get().contains(this)) {
            if (this.mRunning && this.mListeners != null) {
                Object object = (ArrayList)this.mListeners.clone();
                object = ((ArrayList)object).iterator();
                while (object.hasNext()) {
                    Animator$AnimatorListener animator$AnimatorListener = (Animator$AnimatorListener)object.next();
                    animator$AnimatorListener.onAnimationCancel(this);
                }
            }
            this.endAnimation();
        }
    }

    @Override
    public void end() {
        if (!sAnimations.get().contains(this) && !sPendingAnimations.get().contains(this)) {
            this.mStartedDelay = false;
            this.startAnimation();
        } else if (!this.mInitialized) {
            this.initAnimation();
        }
        if (this.mRepeatCount > 0 && (this.mRepeatCount & 1) == 1) {
            this.animateValue(0.0f);
        } else {
            this.animateValue(1.0f);
        }
        this.endAnimation();
    }

    @Override
    public boolean isRunning() {
        return this.mPlayingState == 1 || this.mRunning;
    }

    @Override
    public boolean isStarted() {
        return this.mStarted;
    }

    public void reverse() {
        boolean bl = this.mPlayingBackwards = !this.mPlayingBackwards;
        if (this.mPlayingState == 1) {
            long l2 = AnimationUtils.currentAnimationTimeMillis();
            long l3 = l2 - this.mStartTime;
            long l4 = this.mDuration - l3;
            this.mStartTime = l2 - l4;
            return;
        }
        this.start(true);
    }

    private void endAnimation() {
        sAnimations.get().remove(this);
        sPendingAnimations.get().remove(this);
        sDelayedAnims.get().remove(this);
        this.mPlayingState = 0;
        if (this.mRunning && this.mListeners != null) {
            ArrayList arrayList = (ArrayList)this.mListeners.clone();
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((Animator$AnimatorListener)arrayList.get(i2)).onAnimationEnd(this);
            }
        }
        this.mRunning = false;
        this.mStarted = false;
    }

    private void startAnimation() {
        this.initAnimation();
        sAnimations.get().add(this);
        if (this.mStartDelay > 0L && this.mListeners != null) {
            ArrayList arrayList = (ArrayList)this.mListeners.clone();
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((Animator$AnimatorListener)arrayList.get(i2)).onAnimationStart(this);
            }
        }
    }

    private boolean delayedAnimationFrame(long l2) {
        if (!this.mStartedDelay) {
            this.mStartedDelay = true;
            this.mDelayStartTime = l2;
        } else {
            long l3 = l2 - this.mDelayStartTime;
            if (l3 > this.mStartDelay) {
                this.mStartTime = l2 - (l3 - this.mStartDelay);
                this.mPlayingState = 1;
                return true;
            }
        }
        return false;
    }

    boolean animationFrame(long l2) {
        boolean bl = false;
        if (this.mPlayingState == 0) {
            this.mPlayingState = 1;
            if (this.mSeekTime < 0L) {
                this.mStartTime = l2;
            } else {
                this.mStartTime = l2 - this.mSeekTime;
                this.mSeekTime = -1L;
            }
        }
        switch (this.mPlayingState) {
            case 1: 
            case 2: {
                float f2;
                float f3 = f2 = this.mDuration > 0L ? (float)(l2 - this.mStartTime) / (float)this.mDuration : 1.0f;
                if (f3 >= 1.0f) {
                    if (this.mCurrentIteration < this.mRepeatCount || this.mRepeatCount == -1) {
                        if (this.mListeners != null) {
                            int n2 = this.mListeners.size();
                            for (int i2 = 0; i2 < n2; ++i2) {
                                ((Animator$AnimatorListener)this.mListeners.get(i2)).onAnimationRepeat(this);
                            }
                        }
                        if (this.mRepeatMode == 2) {
                            this.mPlayingBackwards = !this.mPlayingBackwards;
                        }
                        this.mCurrentIteration += (int)f2;
                        f2 %= 1.0f;
                        this.mStartTime += this.mDuration;
                    } else {
                        bl = true;
                        f2 = Math.min(f2, 1.0f);
                    }
                }
                if (this.mPlayingBackwards) {
                    f2 = 1.0f - f2;
                }
                this.animateValue(f2);
            }
        }
        return bl;
    }

    public float getAnimatedFraction() {
        return this.mCurrentFraction;
    }

    void animateValue(float f2) {
        int n2;
        this.mCurrentFraction = f2 = this.mInterpolator.getInterpolation(f2);
        int n3 = this.mValues.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.mValues[n2].calculateValue(f2);
        }
        if (this.mUpdateListeners != null) {
            n2 = this.mUpdateListeners.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.mUpdateListeners.get(i2).onAnimationUpdate(this);
            }
        }
    }

    @Override
    public ValueAnimator clone() {
        int n2;
        int n3;
        PropertyValuesHolder[] propertyValuesHolderArray;
        ValueAnimator valueAnimator = (ValueAnimator)super.clone();
        if (this.mUpdateListeners != null) {
            propertyValuesHolderArray = this.mUpdateListeners;
            valueAnimator.mUpdateListeners = new ArrayList();
            n3 = propertyValuesHolderArray.size();
            for (n2 = 0; n2 < n3; ++n2) {
                valueAnimator.mUpdateListeners.add(propertyValuesHolderArray.get(n2));
            }
        }
        valueAnimator.mSeekTime = -1L;
        valueAnimator.mPlayingBackwards = false;
        valueAnimator.mCurrentIteration = 0;
        valueAnimator.mInitialized = false;
        valueAnimator.mPlayingState = 0;
        valueAnimator.mStartedDelay = false;
        propertyValuesHolderArray = this.mValues;
        if (this.mValues != null) {
            n3 = propertyValuesHolderArray.length;
            valueAnimator.mValues = new PropertyValuesHolder[n3];
            valueAnimator.mValuesMap = new HashMap(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                PropertyValuesHolder propertyValuesHolder;
                valueAnimator.mValues[n2] = propertyValuesHolder = propertyValuesHolderArray[n2].clone();
                valueAnimator.mValuesMap.put(propertyValuesHolder.getPropertyName(), propertyValuesHolder);
            }
        }
        return valueAnimator;
    }

    public static int getCurrentAnimationsCount() {
        return sAnimations.get().size();
    }

    public static void clearAllAnimations() {
        sAnimations.get().clear();
        sPendingAnimations.get().clear();
        sDelayedAnims.get().clear();
    }

    public String toString() {
        String string2 = "ValueAnimator@" + Integer.toHexString(this.hashCode());
        if (this.mValues != null) {
            for (int i2 = 0; i2 < this.mValues.length; ++i2) {
                string2 = string2 + "\n    " + this.mValues[i2].toString();
            }
        }
        return string2;
    }

    static /* synthetic */ ThreadLocal access$000() {
        return sAnimations;
    }

    static /* synthetic */ ThreadLocal access$100() {
        return sDelayedAnims;
    }

    static /* synthetic */ ThreadLocal access$200() {
        return sPendingAnimations;
    }

    static /* synthetic */ long access$300(ValueAnimator valueAnimator) {
        return valueAnimator.mStartDelay;
    }

    static /* synthetic */ void access$400(ValueAnimator valueAnimator) {
        valueAnimator.startAnimation();
    }

    static /* synthetic */ ThreadLocal access$500() {
        return sReadyAnims;
    }

    static /* synthetic */ ThreadLocal access$600() {
        return sEndingAnims;
    }

    static /* synthetic */ boolean access$700(ValueAnimator valueAnimator, long l2) {
        return valueAnimator.delayedAnimationFrame(l2);
    }

    static /* synthetic */ boolean access$802(ValueAnimator valueAnimator, boolean bl) {
        valueAnimator.mRunning = bl;
        return valueAnimator.mRunning;
    }

    static /* synthetic */ void access$900(ValueAnimator valueAnimator) {
        valueAnimator.endAnimation();
    }

    static /* synthetic */ long access$1000() {
        return sFrameDelay;
    }
}

