/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.base;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.a;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.MenuButton$ActionType;
import com.zoyi.rx.ab;

public class BaseActivity
extends AppCompatActivity {
    private BigBar bigBar;
    private ProgressDialog progressDialog;
    private ab subscription;
    protected static final int PERMISSION_READ_STORAGE = 1;
    protected static final int PERMISSION_WRITE_STORAGE = 2;
    protected static final int PERMISSION_CAMERA = 3;
    protected static final int PERMISSION_CALL_PHONE = 4;

    protected void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null) {
            this.finish();
        }
        this.subscription = RxBus.observable().b().a(com.zoyi.rx.a.b.a.a()).a(new a(this));
    }

    protected void onDestroy() {
        if (this.subscription != null && !this.subscription.isUnsubscribed()) {
            this.subscription.unsubscribe();
        }
        super.onDestroy();
    }

    protected void init(int n2) {
        this.setContentView(n2);
        this.bigBar = (BigBar)this.findViewById(R.id.big_bar);
    }

    public int getBackgroundColor() {
        Plugin plugin = ChannelStore.getPlugin();
        if (plugin != null) {
            return plugin.getBackgroundColor();
        }
        return -16777216;
    }

    public int getTextColor() {
        Plugin plugin = ChannelStore.getPlugin();
        if (plugin != null) {
            return plugin.getTextColor();
        }
        return -1;
    }

    protected BigBar getBigBar() {
        return this.bigBar;
    }

    protected void setStatusBarColor(int n2) {
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                this.getWindow().setStatusBarColor(Utils.addBlackMask(n2));
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void optionClicked(MenuButton$ActionType menuButton$ActionType) {
        switch (menuButton$ActionType) {
            case BACK: 
            case EXIT: {
                this.onBackPressed();
            }
        }
    }

    public void hideKeyboard(EditText editText) {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getSystemService("input_method");
        inputMethodManager.hideSoftInputFromWindow(editText.getWindowToken(), 2);
    }

    protected Integer getRequestCode() {
        if (this.getIntent() != null) {
            return this.getIntent().getIntExtra("REQUEST_CODE_INTENT_KEY", Integer.MIN_VALUE);
        }
        return null;
    }

    public void receiveCommand(Command command, Object object) {
    }

    public void receiveData(ChannelModel channelModel, boolean bl) {
    }

    public void receiveChatCounter(int n2) {
    }

    @TargetApi(value=23)
    private String getPermission(int n2) {
        switch (n2) {
            case 1: {
                return "android.permission.READ_EXTERNAL_STORAGE";
            }
            case 2: {
                return "android.permission.WRITE_EXTERNAL_STORAGE";
            }
            case 3: {
                return "android.permission.CAMERA";
            }
            case 4: {
                return "android.permission.CALL_PHONE";
            }
        }
        return "";
    }

    protected boolean checkPermission(int ... nArray) {
        if (nArray.length == 0 || Build.VERSION.SDK_INT < 23) {
            return true;
        }
        String[] stringArray = new String[nArray.length];
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            stringArray[i2] = this.getPermission(nArray[i2]);
            if (ContextCompat.checkSelfPermission((Context)this, (String)stringArray[i2]) != 0) continue;
            ++n2;
        }
        if (n2 == nArray.length) {
            return true;
        }
        ActivityCompat.requestPermissions((Activity)this, (String[])stringArray, (int)nArray[0]);
        return false;
    }

    public void onRequestPermissionsResult(int n2, String[] objectArray, int[] nArray) {
        objectArray = nArray;
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            String string = objectArray[i2];
            if (string == false) continue;
            this.permissionRejected(n2);
            return;
        }
        this.permissionAccepted(n2);
    }

    protected void permissionAccepted(int n2) {
    }

    protected void permissionRejected(int n2) {
    }
}

