/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint.network.socket;

import com.splunk.mint.Logger;
import com.splunk.mint.Properties;
import com.splunk.mint.network.Counter;
import com.splunk.mint.network.Metric;
import com.splunk.mint.network.MonitorRegistry;
import com.splunk.mint.network.NetLogManager;
import com.splunk.mint.network.io.InputStreamMonitor;
import com.splunk.mint.network.io.InputStreamMonitorKitKat;
import com.splunk.mint.network.io.OutputStreamMonitor;
import com.splunk.mint.network.util.Delegator;
import com.splunk.mint.network.util.ReflectionUtil;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MonitoringSocketImpl
extends SocketImpl {
    public static final String ENCAPSULATED_SOCKET_IMPL = "java.net.PlainSocketImpl";
    private static final String[] SYSTEM_PACKAGES = new String[]{"android", "java", "org.apache", "splunk", "libcore"};
    private static final String[] HTTP_CLASSES = new String[]{"HttpClient", "URLConnection", "HttpsURLConnectionImpl", "HttpURLConnectionImpl"};
    private InputStreamMonitor mInputStreamMonitor = null;
    private OutputStreamMonitor mOutputStreamMonitor = null;
    private InputStreamMonitorKitKat mInputStreamMonitorKitKat = null;
    private final MonitorRegistry registry;
    private final Delegator delegator;
    private String name = "NA";
    private final String method = ReflectionUtil.extractCallingMethod(SYSTEM_PACKAGES);
    private final boolean http = ReflectionUtil.callingClassAnyOf(HTTP_CLASSES);
    private String protocol = "NA";
    private long startTime;
    private boolean readingDone = false;

    public MonitoringSocketImpl(MonitorRegistry monitorRegistry) {
        this.delegator = new Delegator((Object)this, SocketImpl.class, ENCAPSULATED_SOCKET_IMPL);
        this.registry = monitorRegistry;
    }

    @Override
    protected void create(boolean bl) throws IOException {
        try {
            this.delegator.invoke(bl);
            return;
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            if (exception instanceof IOException) {
                throw (IOException)throwable;
            }
            this.createActionEventFromCollectedStats(this.registry.getMetricsForName(this.name), null, null, System.currentTimeMillis(), NetLogManager.exceptionToString(throwable.getCause()), this.name);
            try {
                throw throwable.getCause();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throwable2.printStackTrace();
                return;
            }
        }
    }

    @Override
    protected void bind(InetAddress serializable, int n2) throws IOException {
        this.name = ((InetAddress)serializable).getHostName();
        try {
            this.delegator.invoke(serializable, n2);
        }
        catch (Exception exception) {
            serializable = exception;
            if (exception instanceof IOException) {
                throw (IOException)serializable;
            }
            this.createActionEventFromCollectedStats(this.registry.getMetricsForName(this.name), null, null, System.currentTimeMillis(), NetLogManager.exceptionToString(((Throwable)serializable).getCause()), this.name);
            try {
                throw ((Throwable)serializable).getCause();
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throwable.printStackTrace();
            }
        }
        this.startTime = System.currentTimeMillis();
    }

    @Override
    protected void accept(SocketImpl object) throws IOException {
        try {
            this.delegator.invoke(object);
            return;
        }
        catch (Exception exception) {
            object = exception;
            if (exception instanceof IOException) {
                throw (IOException)object;
            }
            this.createActionEventFromCollectedStats(this.registry.getMetricsForName(this.name), null, null, System.currentTimeMillis(), NetLogManager.exceptionToString(((Throwable)object).getCause()), this.name);
            try {
                throw ((Throwable)object).getCause();
            }
            catch (Throwable throwable) {
                object = throwable;
                throwable.printStackTrace();
                return;
            }
        }
    }

    @Override
    protected int available() throws IOException {
        try {
            Integer n2 = (Integer)this.delegator.invoke(new Object[0]);
            return n2;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            if (exception instanceof IOException) {
                throw (IOException)exception2;
            }
            return 0;
        }
    }

    @Override
    protected void connect(InetAddress serializable, int n2) throws IOException {
        this.name = ((InetAddress)serializable).getHostName();
        try {
            this.delegator.delegateTo("connect", InetAddress.class, Integer.TYPE).invoke(serializable, n2);
        }
        catch (Exception exception) {
            serializable = exception;
            if (exception instanceof IOException) {
                throw (IOException)serializable;
            }
            this.createActionEventFromCollectedStats(this.registry.getMetricsForName(this.name), null, null, System.currentTimeMillis(), NetLogManager.exceptionToString(((Throwable)serializable).getCause()), this.name);
            try {
                throw ((Throwable)serializable).getCause();
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throwable.printStackTrace();
            }
        }
        this.startTime = System.currentTimeMillis();
        this.setProtocolFromPort(n2);
    }

    @Override
    protected void connect(SocketAddress serializable, int n2) throws IOException {
        Serializable serializable2;
        if (serializable instanceof InetSocketAddress) {
            serializable2 = (InetSocketAddress)serializable;
            this.name = ((InetSocketAddress)serializable2).getHostName();
            this.setProtocolFromPort(((InetSocketAddress)serializable2).getPort());
        } else {
            this.name = serializable.toString();
        }
        try {
            this.delegator.invoke(serializable, n2);
        }
        catch (Exception exception) {
            serializable2 = exception;
            if (exception instanceof IOException) {
                throw (IOException)serializable2;
            }
            this.createActionEventFromCollectedStats(this.registry.getMetricsForName(this.name), null, null, System.currentTimeMillis(), NetLogManager.exceptionToString(((Throwable)serializable2).getCause()), this.name);
            try {
                throw ((Throwable)serializable2).getCause();
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throwable.printStackTrace();
            }
        }
        this.startTime = System.currentTimeMillis();
    }

    @Override
    protected void connect(String object, int n2) throws IOException {
        this.name = object;
        try {
            this.delegator.invoke(object, n2);
        }
        catch (Exception exception) {
            object = exception;
            if (exception instanceof IOException) {
                throw (IOException)object;
            }
            this.createActionEventFromCollectedStats(this.registry.getMetricsForName(this.name), null, null, System.currentTimeMillis(), NetLogManager.exceptionToString(((Throwable)object).getCause()), this.name);
            try {
                throw ((Throwable)object).getCause();
            }
            catch (Throwable throwable) {
                object = throwable;
                throwable.printStackTrace();
            }
        }
        this.startTime = System.currentTimeMillis();
        this.setProtocolFromPort(n2);
    }

    @Override
    protected void close() throws IOException {
        try {
            this.delegator.invoke(new Object[0]);
            return;
        }
        catch (Exception exception) {
            Logger.logError("Error closing socket impl: " + exception.getMessage());
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            this.createActionEventFromCollectedStats(this.registry.getMetricsForName(this.name), null, null, System.currentTimeMillis(), NetLogManager.exceptionToString(exception.getCause()), this.name);
            try {
                throw exception.getCause();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throwable.printStackTrace();
                return;
            }
        }
    }

    public void readingDone() {
        if (!this.readingDone) {
            this.readingDone = true;
            if (Properties.isKitKat) {
                if (this.mOutputStreamMonitor != null && this.mInputStreamMonitorKitKat != null) {
                    this.createActionEventFromCollectedStats(this.registry.getMetricsForName(this.name), this.mOutputStreamMonitor.getHeaders(), this.mInputStreamMonitorKitKat.getHeaders(), System.currentTimeMillis(), this.mInputStreamMonitorKitKat.exception, null);
                    return;
                }
            } else if (this.mOutputStreamMonitor != null && this.mInputStreamMonitor != null) {
                this.createActionEventFromCollectedStats(this.registry.getMetricsForName(this.name), this.mOutputStreamMonitor.getHeaders(), this.mInputStreamMonitor.getHeaders(), System.currentTimeMillis(), this.mInputStreamMonitor.exception, null);
            }
        }
    }

    private void createActionEventFromCollectedStats(ArrayList<Metric<?>> object, HashMap<String, List<String>> hashMap, HashMap<String, List<String>> hashMap2, long l2, String string, String object2) {
        String string2 = "";
        if (hashMap != null) {
            try {
                string2 = hashMap.get("Host").get(0);
            }
            catch (Exception exception) {}
            try {
                string2 = string2 + hashMap.get("splk-host2").get(0);
            }
            catch (Exception exception) {}
        }
        if (string != null) {
            string2 = object2;
        }
        int n2 = 0;
        if (hashMap2 != null) {
            try {
                n2 = Integer.valueOf(hashMap2.get("splk-statuscode").get(0));
            }
            catch (Exception exception) {}
        }
        object2 = 0L;
        long l3 = 0L;
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            Metric metric = (Metric)object.next();
            if (!(metric instanceof Counter)) continue;
            if (((Counter)metric).getName().endsWith("-bytes-out")) {
                object2 = (Long)metric.getValue();
                continue;
            }
            if (!((Counter)metric).getName().endsWith("-bytes-in")) continue;
            l3 = (Long)metric.getValue();
        }
        try {
            l3 = Long.valueOf(hashMap2.get("Content-Length").get(0));
        }
        catch (Exception exception) {
            Logger.logInfo("Could not read the Content-Length HTTP header value");
        }
        NetLogManager.getInstance().logNetworkRequest(string2, this.protocol, this.startTime, l2, n2, (Long)object2, l3, string, null);
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = (InputStream)this.delegator.invoke(new Object[0]);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            if (exception instanceof IOException) {
                throw (IOException)exception2;
            }
            this.createActionEventFromCollectedStats(this.registry.getMetricsForName(this.name), null, null, System.currentTimeMillis(), NetLogManager.exceptionToString(exception2.getCause()), this.name);
        }
        if (inputStream != null) {
            if (Properties.isKitKat) {
                if (this.mInputStreamMonitorKitKat == null) {
                    this.mInputStreamMonitorKitKat = new InputStreamMonitorKitKat(this.name, this.registry, inputStream, this);
                }
                return this.mInputStreamMonitorKitKat;
            }
            if (this.mInputStreamMonitor == null) {
                this.mInputStreamMonitor = new InputStreamMonitor(this.name, this.registry, inputStream, this);
            }
            return this.mInputStreamMonitor;
        }
        return null;
    }

    @Override
    public Object getOption(int n2) throws SocketException {
        try {
            return this.delegator.invoke(n2);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = (OutputStream)this.delegator.invoke(new Object[0]);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            if (exception instanceof IOException) {
                throw (IOException)exception2;
            }
            exception2.printStackTrace();
        }
        if (outputStream != null) {
            if (this.mOutputStreamMonitor == null) {
                this.mOutputStreamMonitor = new OutputStreamMonitor(this.name, this.registry, outputStream);
            }
            return this.mOutputStreamMonitor;
        }
        return null;
    }

    @Override
    protected void listen(int n2) throws IOException {
        try {
            this.delegator.invoke(n2);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            if (exception instanceof IOException) {
                throw (IOException)exception2;
            }
            exception2.printStackTrace();
            return;
        }
    }

    @Override
    protected void sendUrgentData(int n2) throws IOException {
        try {
            this.delegator.invoke(n2);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            if (exception instanceof IOException) {
                throw (IOException)exception2;
            }
            exception2.printStackTrace();
            return;
        }
    }

    @Override
    public void setOption(int n2, Object object) throws SocketException {
        try {
            this.delegator.invoke(n2, object);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    @Override
    protected FileDescriptor getFileDescriptor() {
        try {
            return (FileDescriptor)this.delegator.invoke(new Object[0]);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    protected InetAddress getInetAddress() {
        try {
            return (InetAddress)this.delegator.invoke(new Object[0]);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    protected int getLocalPort() {
        try {
            Integer n2 = (Integer)this.delegator.invoke(new Object[0]);
            return n2;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return -1;
        }
    }

    @Override
    protected int getPort() {
        try {
            Integer n2 = (Integer)this.delegator.invoke(new Object[0]);
            return n2;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return -1;
        }
    }

    @Override
    protected void setPerformancePreferences(int n2, int n3, int n4) {
        try {
            this.delegator.invoke(n2, n3, n4);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    @Override
    protected void shutdownInput() throws IOException {
        if (Properties.isKitKat) {
            if (this.mInputStreamMonitorKitKat != null) {
                this.mInputStreamMonitorKitKat.close();
            }
        } else if (this.mInputStreamMonitor != null) {
            this.mInputStreamMonitor.close();
        }
        try {
            this.delegator.invoke(new Object[0]);
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            throw iOException;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    @Override
    protected void shutdownOutput() throws IOException {
        if (this.mOutputStreamMonitor != null) {
            this.mOutputStreamMonitor.close();
        }
        try {
            this.delegator.invoke(new Object[0]);
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            throw iOException;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    @Override
    protected boolean supportsUrgentData() {
        try {
            Boolean bl = (Boolean)this.delegator.invoke(new Object[0]);
            return bl;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return false;
        }
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isHttp() {
        return this.http;
    }

    private void setProtocolFromPort(int n2) {
        if (n2 == 80) {
            this.protocol = "HTTP";
            return;
        }
        if (n2 == 443) {
            this.protocol = "HTTPS";
        }
    }
}

