package com.zoyi.channel.plugin.android.activity.chat.model;

import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.rest.Message;

/**
 * Created by mika on 2017. 3. 3..
 */
public class LocalMessageItem implements MessageItem {
  private MessageType messageType;

  private Message message;

  protected Long timestamp;
  protected int order;

  public LocalMessageItem(MessageType messageType, Message message, Long timestamp, int order) {
    this.messageType = messageType;
    this.timestamp = timestamp;
    this.message = message;
    this.order = order;
  }

  @Override
  public Long getFirst() {
    return timestamp + order;
  }

  @Override
  public String getSecond() {
    return this.getClass().getSimpleName();
  }

  @Override
  public MessageType getType() {
    return messageType;
  }

  public Message getMessage() {
    return message;
  }

  public void setTimestamp(Long timestamp) {
    this.timestamp = timestamp;
  }

  public int getOrder() {
    return order;
  }
}
