/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import com.zoyi.channel.plugin.android.util.lang.DateUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class TimeUtils {
    public static final SimpleDateFormat FULL_YEAR = new SimpleDateFormat("yyyy", Locale.getDefault());
    public static final SimpleDateFormat FULL_DAY = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
    public static final SimpleDateFormat FULL_MINUTE = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.getDefault());
    public static final SimpleDateFormat SIMPLE_DAY = new SimpleDateFormat("yyyy-M-d", Locale.getDefault());
    public static final SimpleDateFormat SIMPLE_DATE = new SimpleDateFormat("M/d", Locale.getDefault());
    public static final SimpleDateFormat SIMPLE_YEAR = new SimpleDateFormat("yy/M/d", Locale.getDefault());
    public static final SimpleDateFormat SECOND = new SimpleDateFormat("HH:mm:ss", Locale.getDefault());
    public static final SimpleDateFormat MINUTE_24 = new SimpleDateFormat("H:mm", Locale.getDefault());
    public static final SimpleDateFormat MINUTE_12 = new SimpleDateFormat("h:mm", Locale.getDefault());
    public static final Long MAX_MICROSECONDS = 10000000000000000L;
    public static long OFFSET = 0L;

    public static void refreshOffset() {
        OFFSET = TimeZone.getDefault().getRawOffset();
    }

    public static String get(SimpleDateFormat simpleDateFormat, Long l2) {
        return TimeUtils.get(simpleDateFormat, new Date(l2));
    }

    public static String get(SimpleDateFormat simpleDateFormat, Date date) {
        return simpleDateFormat.format(date);
    }

    public static String get(Long comparable) {
        if (comparable == null) {
            return "";
        }
        comparable = new Date((long)comparable);
        Date date = new Date(System.currentTimeMillis());
        if (DateUtils.isSameDay(date, (Date)comparable)) {
            return TimeUtils.getTime((Date)comparable);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)comparable);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        int n2 = calendar.get(1) - 1900;
        int n3 = calendar2.get(1) - 1900;
        if (n2 == n3) {
            return TimeUtils.get(SIMPLE_DATE, (Date)comparable);
        }
        return TimeUtils.get(FULL_DAY, (Date)comparable);
    }

    public static String getTime(Long l2) {
        return TimeUtils.getTime(new Date(l2));
    }

    public static String getTime(Date object) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)object);
        object = TimeUtils.get(MINUTE_12, (Date)object);
        return String.format("%s%s", object, calendar.get(9) == 1 ? "pm" : "am");
    }

    public static String getFullYear(Long object) {
        String string2 = TimeUtils.get(SIMPLE_DAY, (Long)object);
        object = TimeUtils.getTime((Long)object);
        return String.format("%s %s", string2, object);
    }
}

