/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint.network.io;

import com.splunk.mint.network.Counter;
import com.splunk.mint.network.MonitorRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public final class OutputStreamMonitor
extends OutputStream {
    public static final String OUT_POSTFIX = "-bytes-out";
    private final OutputStream original;
    private final Counter counter;
    private List<Byte> chars;
    private StringBuffer body;
    private static final int MAX_POSSIBLE_HEADER_LENGTH = 50;

    public OutputStreamMonitor(String string, MonitorRegistry monitorRegistry, OutputStream outputStream) {
        this.original = outputStream;
        this.counter = new Counter(string + OUT_POSTFIX);
        monitorRegistry.add(this.counter);
        this.chars = new ArrayList<Byte>();
        this.body = new StringBuffer();
    }

    @Override
    public final void write(int n2) throws IOException {
        this.counter.inc();
        this.original.write(n2);
        this.chars.add((byte)n2);
        this.updateBody();
    }

    @Override
    public final void write(byte[] byArray) throws IOException {
        this.counter.inc(byArray.length);
        this.original.write(byArray);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            this.chars.add(byArray[i2]);
        }
        this.updateBody();
    }

    @Override
    public final void write(byte[] byArray, int n2, int n3) throws IOException {
        this.counter.inc(n3);
        this.original.write(byArray, n2, n3);
        while (n2 < n3) {
            this.chars.add(byArray[n2]);
            ++n2;
        }
        this.updateBody();
    }

    private void updateBody() {
        byte[] byArray = new byte[this.chars.size()];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = this.chars.get(i2);
        }
        this.chars.clear();
        this.body.append(new String(byArray));
    }

    @Override
    public final void close() throws IOException {
        this.original.close();
    }

    public final HashMap<String, List<String>> getHeaders() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>(1);
        if (this.body != null && this.body.toString() != null && this.body.toString().length() > 50) {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new StringReader(this.body.toString()));
                boolean bl = false;
                boolean bl2 = false;
                while ((string = bufferedReader.readLine()) != null) {
                    Object object;
                    int n2;
                    if (!bl && string.contains(":") && string.length() < 50 && (n2 = string.indexOf(":")) >= 0 && (object = string.substring(0, n2).trim()).equals("Host")) {
                        String[] stringArray = new String[]{string.substring(n2 + 1, string.length()).trim()};
                        hashMap.put((String)object, Arrays.asList(stringArray));
                        bl = true;
                    }
                    if (!bl2 && (string.contains("POST") || string.contains("GET"))) {
                        String[] stringArray = string.split(" ");
                        object = new String[]{stringArray[1].trim()};
                        hashMap.put("splk-host2", Arrays.asList(object));
                        bl2 = true;
                    }
                    if (!bl || !bl2) continue;
                    break;
                }
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                iOException.printStackTrace();
            }
        }
        return hashMap;
    }
}

