package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.Toast;
import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;

import java.util.List;

/**
 * Created by mika on 2016. 12. 7..
 */
public class UIUtils {
  public static int getVisible(boolean visible, boolean goneWhenFalse) {
    return visible ? View.VISIBLE : (goneWhenFalse ? View.GONE : View.INVISIBLE);
  }

  public static String getNamesString(List<? extends ProfileEntity> profiles) {
    if (profiles == null || profiles.size() == 0) {
      return "Unknown";
    }
    String base = "";
    for (ProfileEntity profileEntity : profiles) {
      if (profileEntity != null && !TextUtils.isEmpty(profileEntity.getName())) {
        if (TextUtils.isEmpty(base)) {
          base = profileEntity.getName();
        } else {
          base = String.format("%s, %s", base, profileEntity.getName());
        }
      }
    }
    if (TextUtils.isEmpty(base)) {
      return "Unknown";
    }
    return base;
  }

  public static void showToast(Context context, String message) {
    Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
  }
}
