/*
 * Decompiled with CFR 0.152.
 */
package com.zorro.networking.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import com.zorro.networking.error.ANError;
import com.zorro.networking.internal.ANImageLoader;

public class ANImageView
extends AppCompatImageView {
    private String mUrl;
    private int mDefaultImageId;
    private int mErrorImageId;
    private ANImageLoader.ImageContainer mImageContainer;

    public ANImageView(Context context) {
        this(context, null);
    }

    public ANImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ANImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setImageUrl(String url) {
        this.mUrl = url;
        this.loadImageIfNecessary(false);
    }

    public void setDefaultImageResId(int defaultImage) {
        this.mDefaultImageId = defaultImage;
    }

    public void setErrorImageResId(int errorImage) {
        this.mErrorImageId = errorImage;
    }

    void loadImageIfNecessary(final boolean isInLayoutPass) {
        ANImageLoader.ImageContainer newContainer;
        boolean isFullyWrapContent;
        int width = this.getWidth();
        int height = this.getHeight();
        ImageView.ScaleType scaleType = this.getScaleType();
        boolean wrapWidth = false;
        boolean wrapHeight = false;
        if (this.getLayoutParams() != null) {
            wrapWidth = this.getLayoutParams().width == -2;
            wrapHeight = this.getLayoutParams().height == -2;
        }
        boolean bl = isFullyWrapContent = wrapWidth && wrapHeight;
        if (width == 0 && height == 0 && !isFullyWrapContent) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
            if (this.mImageContainer != null) {
                this.mImageContainer.cancelRequest();
                this.mImageContainer = null;
            }
            this.setDefaultImageOrNull();
            return;
        }
        if (this.mImageContainer != null && this.mImageContainer.getRequestUrl() != null) {
            if (this.mImageContainer.getRequestUrl().equals(this.mUrl)) {
                return;
            }
            this.mImageContainer.cancelRequest();
            this.setDefaultImageOrNull();
        }
        int maxWidth = wrapWidth ? 0 : width;
        int maxHeight = wrapHeight ? 0 : height;
        this.mImageContainer = newContainer = ANImageLoader.getInstance().get(this.mUrl, new ANImageLoader.ImageListener(){

            @Override
            public void onResponse(final ANImageLoader.ImageContainer response, boolean isImmediate) {
                if (isImmediate && isInLayoutPass) {
                    ANImageView.this.post(new Runnable(){

                        @Override
                        public void run() {
                            this.onResponse(response, false);
                        }
                    });
                    return;
                }
                if (response.getBitmap() != null) {
                    ANImageView.this.setImageBitmap(response.getBitmap());
                } else if (ANImageView.this.mDefaultImageId != 0) {
                    ANImageView.this.setImageResource(ANImageView.this.mDefaultImageId);
                }
            }

            @Override
            public void onError(ANError error) {
                if (ANImageView.this.mErrorImageId != 0) {
                    ANImageView.this.setImageResource(ANImageView.this.mErrorImageId);
                }
            }
        }, maxWidth, maxHeight, scaleType);
    }

    private void setDefaultImageOrNull() {
        if (this.mDefaultImageId != 0) {
            this.setImageResource(this.mDefaultImageId);
        } else {
            this.setImageBitmap(null);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.loadImageIfNecessary(true);
    }

    protected void onDetachedFromWindow() {
        if (this.mImageContainer != null) {
            this.mImageContainer.cancelRequest();
            this.setImageBitmap(null);
            this.mImageContainer = null;
        }
        super.onDetachedFromWindow();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }
}

