/*
 * Decompiled with CFR 0.152.
 */
package com.zorro.networking.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.widget.ImageView;
import com.zorro.networking.common.ANRequest;
import com.zorro.networking.common.ANResponse;
import com.zorro.networking.core.Core;
import com.zorro.networking.error.ANError;
import com.zorro.networking.interfaces.AnalyticsListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URLConnection;
import okhttp3.Cache;
import okhttp3.Response;
import okio.Okio;
import okio.Source;

public class Utils {
    public static File getDiskCacheDir(Context context, String uniqueName) {
        return new File(context.getCacheDir(), uniqueName);
    }

    public static Cache getCache(Context context, int maxCacheSize, String uniqueName) {
        return new Cache(Utils.getDiskCacheDir(context, uniqueName), (long)maxCacheSize);
    }

    public static String getMimeType(String path) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String contentTypeFor = fileNameMap.getContentTypeFor(path);
        if (contentTypeFor == null) {
            contentTypeFor = "application/octet-stream";
        }
        return contentTypeFor;
    }

    public static ANResponse<Bitmap> decodeBitmap(Response response, int maxWidth, int maxHeight, Bitmap.Config decodeConfig, ImageView.ScaleType scaleType) {
        return Utils.decodeBitmap(response, maxWidth, maxHeight, decodeConfig, new BitmapFactory.Options(), scaleType);
    }

    public static ANResponse<Bitmap> decodeBitmap(Response response, int maxWidth, int maxHeight, Bitmap.Config decodeConfig, BitmapFactory.Options decodeOptions, ImageView.ScaleType scaleType) {
        byte[] data = new byte[]{};
        try {
            data = Okio.buffer((Source)response.body().source()).readByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Bitmap bitmap = null;
        if (maxWidth == 0 && maxHeight == 0) {
            decodeOptions.inPreferredConfig = decodeConfig;
            bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)decodeOptions);
        } else {
            decodeOptions.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)decodeOptions);
            int actualWidth = decodeOptions.outWidth;
            int actualHeight = decodeOptions.outHeight;
            int desiredWidth = Utils.getResizedDimension(maxWidth, maxHeight, actualWidth, actualHeight, scaleType);
            int desiredHeight = Utils.getResizedDimension(maxHeight, maxWidth, actualHeight, actualWidth, scaleType);
            decodeOptions.inJustDecodeBounds = false;
            decodeOptions.inSampleSize = Utils.findBestSampleSize(actualWidth, actualHeight, desiredWidth, desiredHeight);
            Bitmap tempBitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)decodeOptions);
            if (tempBitmap != null && (tempBitmap.getWidth() > desiredWidth || tempBitmap.getHeight() > desiredHeight)) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)tempBitmap, (int)desiredWidth, (int)desiredHeight, (boolean)true);
                tempBitmap.recycle();
            } else {
                bitmap = tempBitmap;
            }
        }
        if (bitmap == null) {
            return ANResponse.failed(Utils.getErrorForParse(new ANError(response)));
        }
        return ANResponse.success(bitmap);
    }

    private static int getResizedDimension(int maxPrimary, int maxSecondary, int actualPrimary, int actualSecondary, ImageView.ScaleType scaleType) {
        if (maxPrimary == 0 && maxSecondary == 0) {
            return actualPrimary;
        }
        if (scaleType == ImageView.ScaleType.FIT_XY) {
            if (maxPrimary == 0) {
                return actualPrimary;
            }
            return maxPrimary;
        }
        if (maxPrimary == 0) {
            double ratio = (double)maxSecondary / (double)actualSecondary;
            return (int)((double)actualPrimary * ratio);
        }
        if (maxSecondary == 0) {
            return maxPrimary;
        }
        double ratio = (double)actualSecondary / (double)actualPrimary;
        int resized = maxPrimary;
        if (scaleType == ImageView.ScaleType.CENTER_CROP) {
            if ((double)resized * ratio < (double)maxSecondary) {
                resized = (int)((double)maxSecondary / ratio);
            }
            return resized;
        }
        if ((double)resized * ratio > (double)maxSecondary) {
            resized = (int)((double)maxSecondary / ratio);
        }
        return resized;
    }

    public static int findBestSampleSize(int actualWidth, int actualHeight, int desiredWidth, int desiredHeight) {
        double wr = (double)actualWidth / (double)desiredWidth;
        double hr = (double)actualHeight / (double)desiredHeight;
        double ratio = Math.min(wr, hr);
        float n = 1.0f;
        while ((double)(n * 2.0f) <= ratio) {
            n *= 2.0f;
        }
        return (int)n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(Response response, String dirPath, String fileName) throws IOException {
        InputStream is = null;
        byte[] buf = new byte[2048];
        FileOutputStream fos = null;
        try {
            int len;
            is = response.body().byteStream();
            File dir = new File(dirPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(dir, fileName);
            fos = new FileOutputStream(file);
            while ((len = is.read(buf)) != -1) {
                fos.write(buf, 0, len);
            }
            fos.flush();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void sendAnalytics(final AnalyticsListener analyticsListener, final long timeTakenInMillis, final long bytesSent, final long bytesReceived, final boolean isFromCache) {
        Core.getInstance().getExecutorSupplier().forMainThreadTasks().execute(new Runnable(){

            @Override
            public void run() {
                if (analyticsListener != null) {
                    analyticsListener.onReceived(timeTakenInMillis, bytesSent, bytesReceived, isFromCache);
                }
            }
        });
    }

    public static ANError getErrorForConnection(ANError error) {
        error.setErrorDetail("connectionError");
        error.setErrorCode(0);
        return error;
    }

    public static ANError getErrorForServerResponse(ANError error, ANRequest request, int code) {
        error = request.parseNetworkError(error);
        error.setErrorCode(code);
        error.setErrorDetail("responseFromServerError");
        return error;
    }

    public static ANError getErrorForParse(ANError error) {
        error.setErrorCode(0);
        error.setErrorDetail("parseError");
        return error;
    }
}

