/*
 * Decompiled with CFR 0.152.
 */
package com.zorro.networking.internal;

import com.zorro.networking.common.ANRequest;
import com.zorro.networking.common.ANResponse;
import com.zorro.networking.common.ResponseType;
import com.zorro.networking.error.ANError;
import com.zorro.networking.internal.InternalNetworking;
import com.zorro.networking.utils.SourceCloseUtil;
import com.zorro.networking.utils.Utils;
import okhttp3.Response;

public final class SynchronousCall {
    private SynchronousCall() {
    }

    public static <T> ANResponse<T> execute(ANRequest request) {
        switch (request.getRequestType()) {
            case 0: {
                return SynchronousCall.executeSimpleRequest(request);
            }
            case 1: {
                return SynchronousCall.executeDownloadRequest(request);
            }
            case 2: {
                return SynchronousCall.executeUploadRequest(request);
            }
        }
        return new ANResponse(new ANError());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> ANResponse<T> executeSimpleRequest(ANRequest request) {
        Response okHttpResponse = null;
        try {
            okHttpResponse = InternalNetworking.performSimpleRequest(request);
            if (okHttpResponse == null) {
                ANResponse aNResponse = new ANResponse(Utils.getErrorForConnection(new ANError()));
                return aNResponse;
            }
            if (request.getResponseAs() == ResponseType.OK_HTTP_RESPONSE) {
                ANResponse<Response> response = new ANResponse<Response>(okHttpResponse);
                response.setOkHttpResponse(okHttpResponse);
                ANResponse<Response> aNResponse = response;
                return aNResponse;
            }
            if (okHttpResponse.code() >= 400) {
                ANResponse response = new ANResponse(Utils.getErrorForServerResponse(new ANError(okHttpResponse), request, okHttpResponse.code()));
                response.setOkHttpResponse(okHttpResponse);
                ANResponse aNResponse = response;
                return aNResponse;
            }
            ANResponse response = request.parseResponse(okHttpResponse);
            response.setOkHttpResponse(okHttpResponse);
            ANResponse aNResponse = response;
            return aNResponse;
        }
        catch (ANError se) {
            ANResponse aNResponse = new ANResponse(Utils.getErrorForConnection(new ANError(se)));
            return aNResponse;
        }
        catch (Exception e) {
            ANResponse aNResponse = new ANResponse(Utils.getErrorForConnection(new ANError(e)));
            return aNResponse;
        }
        finally {
            SourceCloseUtil.close(okHttpResponse, request);
        }
    }

    private static <T> ANResponse<T> executeDownloadRequest(ANRequest request) {
        try {
            Response okHttpResponse = InternalNetworking.performDownloadRequest(request);
            if (okHttpResponse == null) {
                return new ANResponse(Utils.getErrorForConnection(new ANError()));
            }
            if (okHttpResponse.code() >= 400) {
                ANResponse response = new ANResponse(Utils.getErrorForServerResponse(new ANError(okHttpResponse), request, okHttpResponse.code()));
                response.setOkHttpResponse(okHttpResponse);
                return response;
            }
            ANResponse<String> response = new ANResponse<String>("success");
            response.setOkHttpResponse(okHttpResponse);
            return response;
        }
        catch (ANError se) {
            return new ANResponse(Utils.getErrorForConnection(new ANError(se)));
        }
        catch (Exception e) {
            return new ANResponse(Utils.getErrorForConnection(new ANError(e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> ANResponse<T> executeUploadRequest(ANRequest request) {
        Response okHttpResponse = null;
        try {
            okHttpResponse = InternalNetworking.performUploadRequest(request);
            if (okHttpResponse == null) {
                ANResponse aNResponse = new ANResponse(Utils.getErrorForConnection(new ANError()));
                return aNResponse;
            }
            if (request.getResponseAs() == ResponseType.OK_HTTP_RESPONSE) {
                ANResponse<Response> response = new ANResponse<Response>(okHttpResponse);
                response.setOkHttpResponse(okHttpResponse);
                ANResponse<Response> aNResponse = response;
                return aNResponse;
            }
            if (okHttpResponse.code() >= 400) {
                ANResponse response = new ANResponse(Utils.getErrorForServerResponse(new ANError(okHttpResponse), request, okHttpResponse.code()));
                response.setOkHttpResponse(okHttpResponse);
                ANResponse aNResponse = response;
                return aNResponse;
            }
            ANResponse response = request.parseResponse(okHttpResponse);
            response.setOkHttpResponse(okHttpResponse);
            ANResponse aNResponse = response;
            return aNResponse;
        }
        catch (ANError se) {
            ANResponse aNResponse = new ANResponse(Utils.getErrorForConnection(se));
            return aNResponse;
        }
        catch (Exception e) {
            ANResponse aNResponse = new ANResponse(Utils.getErrorForConnection(new ANError(e)));
            return aNResponse;
        }
        finally {
            SourceCloseUtil.close(okHttpResponse, request);
        }
    }
}

