/*
 * Decompiled with CFR 0.152.
 */
package com.zorro.networking.gsonparserfactory;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.zorro.networking.gsonparserfactory.GsonRequestBodyParser;
import com.zorro.networking.gsonparserfactory.GsonResponseBodyParser;
import com.zorro.networking.interfaces.Parser;
import java.lang.reflect.Type;
import java.util.HashMap;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;

public final class GsonParserFactory
extends Parser.Factory {
    private final Gson gson;

    public GsonParserFactory() {
        this.gson = new Gson();
    }

    public GsonParserFactory(Gson gson) {
        this.gson = gson;
    }

    @Override
    public Parser<ResponseBody, ?> responseBodyParser(Type type) {
        TypeAdapter adapter = this.gson.getAdapter(TypeToken.get((Type)type));
        return new GsonResponseBodyParser(this.gson, adapter);
    }

    @Override
    public Parser<?, RequestBody> requestBodyParser(Type type) {
        TypeAdapter adapter = this.gson.getAdapter(TypeToken.get((Type)type));
        return new GsonRequestBodyParser(this.gson, adapter);
    }

    @Override
    public Object getObject(String string, Type type) {
        try {
            return this.gson.fromJson(string, type);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getString(Object object) {
        try {
            return this.gson.toJson(object);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public HashMap<String, String> getStringMap(Object object) {
        try {
            Type type = new TypeToken<HashMap<String, String>>(){}.getType();
            return (HashMap)this.gson.fromJson(this.gson.toJson(object), type);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap<String, String>();
        }
    }
}

