/*
 * Decompiled with CFR 0.152.
 */
package com.zorro.networking.core;

import com.zorro.networking.core.ANExecutor;
import com.zorro.networking.core.ExecutorSupplier;
import com.zorro.networking.core.MainThreadExecutor;
import com.zorro.networking.core.PriorityThreadFactory;
import java.util.concurrent.Executor;

public class DefaultExecutorSupplier
implements ExecutorSupplier {
    public static final int DEFAULT_MAX_NUM_THREADS = 2 * Runtime.getRuntime().availableProcessors() + 1;
    private final ANExecutor mNetworkExecutor;
    private final ANExecutor mImmediateNetworkExecutor;
    private final Executor mMainThreadExecutor;

    public DefaultExecutorSupplier() {
        PriorityThreadFactory backgroundPriorityThreadFactory = new PriorityThreadFactory(10);
        this.mNetworkExecutor = new ANExecutor(DEFAULT_MAX_NUM_THREADS, backgroundPriorityThreadFactory);
        this.mImmediateNetworkExecutor = new ANExecutor(2, backgroundPriorityThreadFactory);
        this.mMainThreadExecutor = new MainThreadExecutor();
    }

    @Override
    public ANExecutor forNetworkTasks() {
        return this.mNetworkExecutor;
    }

    @Override
    public ANExecutor forImmediateNetworkTasks() {
        return this.mImmediateNetworkExecutor;
    }

    @Override
    public Executor forMainThreadTasks() {
        return this.mMainThreadExecutor;
    }
}

