/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.webp.decoder;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.util.Log;
import com.bumptech.glide.integration.webp.WebpBitmapFactory;
import com.bumptech.glide.integration.webp.WebpHeaderParser;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.ImageHeaderParser;
import com.bumptech.glide.load.ImageHeaderParserUtils;
import com.bumptech.glide.load.Option;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.bumptech.glide.load.resource.bitmap.DownsampleStrategy;
import com.bumptech.glide.load.resource.bitmap.Downsampler;
import com.bumptech.glide.load.resource.bitmap.TransformationUtils;
import com.bumptech.glide.util.LogTime;
import com.bumptech.glide.util.Preconditions;
import com.bumptech.glide.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Queue;

public final class WebpDownsampler {
    private static final String TAG = "WebpDownsampler";
    public static final Option<Boolean> DISABLE_DECODER = Option.memory((String)"com.bumptech.glide.integration.webp.decoder.WebpDownsampler.DisableDecoder", (Object)false);
    private static final Downsampler.DecodeCallbacks EMPTY_CALLBACKS = new Downsampler.DecodeCallbacks(){

        public void onObtainBounds() {
        }

        public void onDecodeComplete(BitmapPool bitmapPool, Bitmap downsampled) throws IOException {
        }
    };
    private static final Queue<BitmapFactory.Options> OPTIONS_QUEUE = Util.createQueue((int)0);
    private static final int MARK_POSITION = 0xA00000;
    private static final int DENSITY_PRECISION_MULTIPLIER = 1000000000;
    private final BitmapPool bitmapPool;
    private final DisplayMetrics displayMetrics;
    private final ArrayPool byteArrayPool;
    private final List<ImageHeaderParser> parsers;

    public WebpDownsampler(List<ImageHeaderParser> parsers, DisplayMetrics displayMetrics, BitmapPool bitmapPool, ArrayPool byteArrayPool) {
        this.parsers = parsers;
        this.displayMetrics = (DisplayMetrics)Preconditions.checkNotNull((Object)displayMetrics);
        this.bitmapPool = (BitmapPool)Preconditions.checkNotNull((Object)bitmapPool);
        this.byteArrayPool = (ArrayPool)Preconditions.checkNotNull((Object)byteArrayPool);
    }

    public boolean handles(InputStream is, Options options) throws IOException {
        if (((Boolean)options.get(DISABLE_DECODER)).booleanValue() || WebpHeaderParser.sIsExtendedWebpSupported) {
            return false;
        }
        WebpHeaderParser.WebpImageType webpType = WebpHeaderParser.getType(is, this.byteArrayPool);
        return WebpHeaderParser.isStaticWebpType(webpType) && webpType != WebpHeaderParser.WebpImageType.WEBP_SIMPLE;
    }

    public boolean handles(ByteBuffer byteBuffer, Options options) throws IOException {
        if (((Boolean)options.get(DISABLE_DECODER)).booleanValue() || WebpHeaderParser.sIsExtendedWebpSupported) {
            return false;
        }
        WebpHeaderParser.WebpImageType webpType = WebpHeaderParser.getType(byteBuffer);
        return WebpHeaderParser.isStaticWebpType(webpType) && webpType != WebpHeaderParser.WebpImageType.WEBP_SIMPLE;
    }

    public Resource<Bitmap> decode(InputStream is, int outWidth, int outHeight, Options options) throws IOException {
        return this.decode(is, outWidth, outHeight, options, EMPTY_CALLBACKS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource<Bitmap> decode(InputStream is, int requestedWidth, int requestedHeight, Options options, Downsampler.DecodeCallbacks callbacks) throws IOException {
        boolean isHardwareConfigAllowed;
        Preconditions.checkArgument((boolean)is.markSupported(), (String)"You must provide an InputStream that supports mark()");
        byte[] bytesForOptions = (byte[])this.byteArrayPool.get(65536, byte[].class);
        BitmapFactory.Options bitmapFactoryOptions = WebpDownsampler.getDefaultOptions();
        bitmapFactoryOptions.inTempStorage = bytesForOptions;
        DecodeFormat decodeFormat = (DecodeFormat)options.get(Downsampler.DECODE_FORMAT);
        DownsampleStrategy downsampleStrategy = (DownsampleStrategy)options.get(Downsampler.DOWNSAMPLE_STRATEGY);
        boolean fixBitmapToRequestedDimensions = (Boolean)options.get(Downsampler.FIX_BITMAP_SIZE_TO_REQUESTED_DIMENSIONS);
        boolean bl = isHardwareConfigAllowed = options.get(Downsampler.ALLOW_HARDWARE_CONFIG) != null && (Boolean)options.get(Downsampler.ALLOW_HARDWARE_CONFIG) != false;
        if (decodeFormat == DecodeFormat.PREFER_ARGB_8888_DISALLOW_HARDWARE) {
            isHardwareConfigAllowed = false;
        }
        try {
            Bitmap result = this.decodeFromWrappedStreams(is, bitmapFactoryOptions, downsampleStrategy, decodeFormat, isHardwareConfigAllowed, requestedWidth, requestedHeight, fixBitmapToRequestedDimensions, callbacks);
            BitmapResource bitmapResource = BitmapResource.obtain((Bitmap)result, (BitmapPool)this.bitmapPool);
            return bitmapResource;
        }
        finally {
            WebpDownsampler.releaseOptions(bitmapFactoryOptions);
            this.byteArrayPool.put((Object)bytesForOptions, byte[].class);
        }
    }

    private Bitmap decodeFromWrappedStreams(InputStream is, BitmapFactory.Options options, DownsampleStrategy downsampleStrategy, DecodeFormat decodeFormat, boolean isHardwareConfigAllowed, int requestedWidth, int requestedHeight, boolean fixBitmapToRequestedDimensions, Downsampler.DecodeCallbacks callbacks) throws IOException {
        boolean isKitKatOrGreater;
        long startTime = LogTime.getLogTime();
        int[] sourceDimensions = WebpDownsampler.getDimensions(is, options, callbacks, this.bitmapPool);
        int sourceWidth = sourceDimensions[0];
        int sourceHeight = sourceDimensions[1];
        String sourceMimeType = options.outMimeType;
        if (sourceWidth == -1 || sourceHeight == -1) {
            isHardwareConfigAllowed = false;
        }
        int orientation = ImageHeaderParserUtils.getOrientation(this.parsers, (InputStream)is, (ArrayPool)this.byteArrayPool);
        int degreesToRotate = TransformationUtils.getExifOrientationDegrees((int)orientation);
        boolean isExifOrientationRequired = TransformationUtils.isExifOrientationRequired((int)orientation);
        int targetWidth = requestedWidth == Integer.MIN_VALUE ? sourceWidth : requestedWidth;
        int targetHeight = requestedHeight == Integer.MIN_VALUE ? sourceHeight : requestedHeight;
        ImageHeaderParser.ImageType imageType = ImageHeaderParserUtils.getType(this.parsers, (InputStream)is, (ArrayPool)this.byteArrayPool);
        WebpDownsampler.calculateScaling(imageType, is, callbacks, this.bitmapPool, downsampleStrategy, degreesToRotate, sourceWidth, sourceHeight, targetWidth, targetHeight, options);
        this.calculateConfig(is, decodeFormat, isHardwareConfigAllowed, isExifOrientationRequired, options, targetWidth, targetHeight);
        boolean bl = isKitKatOrGreater = Build.VERSION.SDK_INT >= 19;
        if ((options.inSampleSize == 1 || isKitKatOrGreater) && this.shouldUsePool(imageType)) {
            int expectedHeight;
            int expectedWidth;
            if (fixBitmapToRequestedDimensions && isKitKatOrGreater) {
                expectedWidth = targetWidth;
                expectedHeight = targetHeight;
            } else {
                float densityMultiplier = WebpDownsampler.isScaling(options) ? (float)options.inTargetDensity / (float)options.inDensity : 1.0f;
                int sampleSize = options.inSampleSize;
                int downsampledWidth = (int)Math.ceil((float)sourceWidth / (float)sampleSize);
                int downsampledHeight = (int)Math.ceil((float)sourceHeight / (float)sampleSize);
                expectedWidth = Math.round((float)downsampledWidth * densityMultiplier);
                expectedHeight = Math.round((float)downsampledHeight * densityMultiplier);
                if (Log.isLoggable((String)TAG, (int)2)) {
                    Log.v((String)TAG, (String)("Calculated target [" + expectedWidth + "x" + expectedHeight + "] for source [" + sourceWidth + "x" + sourceHeight + "], sampleSize: " + sampleSize + ", targetDensity: " + options.inTargetDensity + ", density: " + options.inDensity + ", density multiplier: " + densityMultiplier));
                }
            }
            if (expectedWidth > 0 && expectedHeight > 0) {
                WebpDownsampler.setInBitmap(options, this.bitmapPool, expectedWidth, expectedHeight);
            }
        }
        Bitmap downsampled = WebpDownsampler.decodeStream(is, options, callbacks, this.bitmapPool);
        callbacks.onDecodeComplete(this.bitmapPool, downsampled);
        if (Log.isLoggable((String)TAG, (int)2)) {
            WebpDownsampler.logDecode(sourceWidth, sourceHeight, sourceMimeType, options, downsampled, requestedWidth, requestedHeight, startTime);
        }
        Bitmap rotated = null;
        if (downsampled != null) {
            downsampled.setDensity(this.displayMetrics.densityDpi);
            rotated = TransformationUtils.rotateImageExif((BitmapPool)this.bitmapPool, (Bitmap)downsampled, (int)orientation);
            if (!downsampled.equals(rotated)) {
                this.bitmapPool.put(downsampled);
            }
        }
        return rotated;
    }

    static void calculateScaling(ImageHeaderParser.ImageType imageType, InputStream is, Downsampler.DecodeCallbacks decodeCallbacks, BitmapPool bitmapPool, DownsampleStrategy downsampleStrategy, int degreesToRotate, int sourceWidth, int sourceHeight, int targetWidth, int targetHeight, BitmapFactory.Options options) throws IOException {
        int powerOfTwoHeight;
        int powerOfTwoWidth;
        if (sourceWidth <= 0 || sourceHeight <= 0) {
            return;
        }
        float exactScaleFactor = degreesToRotate == 90 || degreesToRotate == 270 ? downsampleStrategy.getScaleFactor(sourceHeight, sourceWidth, targetWidth, targetHeight) : downsampleStrategy.getScaleFactor(sourceWidth, sourceHeight, targetWidth, targetHeight);
        if (exactScaleFactor <= 0.0f) {
            throw new IllegalArgumentException("Cannot scale with factor: " + exactScaleFactor + " from: " + downsampleStrategy + ", source: [" + sourceWidth + "x" + sourceHeight + "], target: [" + targetWidth + "x" + targetHeight + "]");
        }
        DownsampleStrategy.SampleSizeRounding rounding = downsampleStrategy.getSampleSizeRounding(sourceWidth, sourceHeight, targetWidth, targetHeight);
        if (rounding == null) {
            throw new IllegalArgumentException("Cannot round with null rounding");
        }
        int outWidth = WebpDownsampler.round(exactScaleFactor * (float)sourceWidth);
        int outHeight = WebpDownsampler.round(exactScaleFactor * (float)sourceHeight);
        int widthScaleFactor = sourceWidth / outWidth;
        int heightScaleFactor = sourceHeight / outHeight;
        int scaleFactor = rounding == DownsampleStrategy.SampleSizeRounding.MEMORY ? Math.max(widthScaleFactor, heightScaleFactor) : Math.min(widthScaleFactor, heightScaleFactor);
        int powerOfTwoSampleSize = Math.max(1, Integer.highestOneBit(scaleFactor));
        if (rounding == DownsampleStrategy.SampleSizeRounding.MEMORY && (float)powerOfTwoSampleSize < 1.0f / exactScaleFactor) {
            powerOfTwoSampleSize <<= 1;
        }
        options.inSampleSize = powerOfTwoSampleSize;
        if (imageType == ImageHeaderParser.ImageType.JPEG) {
            int nativeScaling = Math.min(powerOfTwoSampleSize, 8);
            powerOfTwoWidth = (int)Math.ceil((float)sourceWidth / (float)nativeScaling);
            powerOfTwoHeight = (int)Math.ceil((float)sourceHeight / (float)nativeScaling);
            int secondaryScaling = powerOfTwoSampleSize / 8;
            if (secondaryScaling > 0) {
                powerOfTwoWidth /= secondaryScaling;
                powerOfTwoHeight /= secondaryScaling;
            }
        } else if (imageType == ImageHeaderParser.ImageType.PNG || imageType == ImageHeaderParser.ImageType.PNG_A) {
            powerOfTwoWidth = (int)Math.floor((float)sourceWidth / (float)powerOfTwoSampleSize);
            powerOfTwoHeight = (int)Math.floor((float)sourceHeight / (float)powerOfTwoSampleSize);
        } else if (imageType == ImageHeaderParser.ImageType.WEBP || imageType == ImageHeaderParser.ImageType.WEBP_A) {
            if (Build.VERSION.SDK_INT >= 24) {
                powerOfTwoWidth = Math.round((float)sourceWidth / (float)powerOfTwoSampleSize);
                powerOfTwoHeight = Math.round((float)sourceHeight / (float)powerOfTwoSampleSize);
            } else {
                powerOfTwoWidth = (int)Math.floor((float)sourceWidth / (float)powerOfTwoSampleSize);
                powerOfTwoHeight = (int)Math.floor((float)sourceHeight / (float)powerOfTwoSampleSize);
            }
        } else if (sourceWidth % powerOfTwoSampleSize != 0 || sourceHeight % powerOfTwoSampleSize != 0) {
            int[] dimensions = WebpDownsampler.getDimensions(is, options, decodeCallbacks, bitmapPool);
            powerOfTwoWidth = dimensions[0];
            powerOfTwoHeight = dimensions[1];
        } else {
            powerOfTwoWidth = sourceWidth / powerOfTwoSampleSize;
            powerOfTwoHeight = sourceHeight / powerOfTwoSampleSize;
        }
        double adjustedScaleFactor = downsampleStrategy.getScaleFactor(powerOfTwoWidth, powerOfTwoHeight, targetWidth, targetHeight);
        if (Build.VERSION.SDK_INT >= 19) {
            options.inTargetDensity = WebpDownsampler.adjustTargetDensityForError(adjustedScaleFactor);
            options.inDensity = 1000000000;
        }
        if (WebpDownsampler.isScaling(options)) {
            options.inScaled = true;
        } else {
            options.inTargetDensity = 0;
            options.inDensity = 0;
        }
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("Calculate scaling, source: [" + sourceWidth + "x" + sourceHeight + "], target: [" + targetWidth + "x" + targetHeight + "], power of two scaled: [" + powerOfTwoWidth + "x" + powerOfTwoHeight + "], exact scale factor: " + exactScaleFactor + ", power of 2 sample size: " + powerOfTwoSampleSize + ", adjusted scale factor: " + adjustedScaleFactor + ", target density: " + options.inTargetDensity + ", density: " + options.inDensity));
        }
    }

    private static int adjustTargetDensityForError(double adjustedScaleFactor) {
        int targetDensity = WebpDownsampler.round(1.0E9 * adjustedScaleFactor);
        float scaleFactorWithError = (float)targetDensity / 1.0E9f;
        double difference = adjustedScaleFactor / (double)scaleFactorWithError;
        return WebpDownsampler.round(difference * (double)targetDensity);
    }

    private static int round(double value) {
        return (int)(value + 0.5);
    }

    private boolean shouldUsePool(ImageHeaderParser.ImageType imageType) throws IOException {
        return Build.VERSION.SDK_INT >= 19;
    }

    private void calculateConfig(InputStream is, DecodeFormat format, boolean isHardwareConfigAllowed, boolean isExifOrientationRequired, BitmapFactory.Options optionsWithScaling, int targetWidth, int targetHeight) throws IOException {
        boolean hasAlpha;
        block4: {
            if (format == DecodeFormat.PREFER_ARGB_8888 || format == DecodeFormat.PREFER_ARGB_8888_DISALLOW_HARDWARE || Build.VERSION.SDK_INT == 16) {
                optionsWithScaling.inPreferredConfig = Bitmap.Config.ARGB_8888;
                return;
            }
            hasAlpha = false;
            try {
                hasAlpha = ImageHeaderParserUtils.getType(this.parsers, (InputStream)is, (ArrayPool)this.byteArrayPool).hasAlpha();
            }
            catch (IOException e) {
                if (!Log.isLoggable((String)TAG, (int)3)) break block4;
                Log.d((String)TAG, (String)("Cannot determine whether the image has alpha or not from header, format " + format), (Throwable)e);
            }
        }
        Bitmap.Config config = optionsWithScaling.inPreferredConfig = hasAlpha ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        if (optionsWithScaling.inPreferredConfig == Bitmap.Config.RGB_565 || optionsWithScaling.inPreferredConfig == Bitmap.Config.ARGB_4444 || optionsWithScaling.inPreferredConfig == Bitmap.Config.ALPHA_8) {
            optionsWithScaling.inDither = true;
        }
    }

    private static int[] getDimensions(InputStream is, BitmapFactory.Options options, Downsampler.DecodeCallbacks decodeCallbacks, BitmapPool bitmapPool) throws IOException {
        options.inJustDecodeBounds = true;
        WebpDownsampler.decodeStream(is, options, decodeCallbacks, bitmapPool);
        options.inJustDecodeBounds = false;
        return new int[]{options.outWidth, options.outHeight};
    }

    private static Bitmap decodeStream(InputStream is, BitmapFactory.Options options, Downsampler.DecodeCallbacks callbacks, BitmapPool bitmapPool) throws IOException {
        Bitmap result;
        if (options.inJustDecodeBounds) {
            is.mark(0xA00000);
        } else {
            callbacks.onObtainBounds();
        }
        int sourceWidth = options.outWidth;
        int sourceHeight = options.outHeight;
        String outMimeType = options.outMimeType;
        TransformationUtils.getBitmapDrawableLock().lock();
        try {
            result = WebpBitmapFactory.decodeStream(is, null, options);
        }
        catch (IllegalArgumentException e) {
            IOException bitmapAssertionException = WebpDownsampler.newIoExceptionForInBitmapAssertion(e, sourceWidth, sourceHeight, outMimeType, options);
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Failed to decode with inBitmap, trying again without Bitmap re-use", (Throwable)bitmapAssertionException);
            }
            if (options.inBitmap != null) {
                try {
                    is.reset();
                    bitmapPool.put(options.inBitmap);
                    options.inBitmap = null;
                    Bitmap bitmap = WebpDownsampler.decodeStream(is, options, callbacks, bitmapPool);
                    return bitmap;
                }
                catch (IOException resetException) {
                    throw bitmapAssertionException;
                }
            }
            throw bitmapAssertionException;
        }
        finally {
            TransformationUtils.getBitmapDrawableLock().unlock();
        }
        if (options.inJustDecodeBounds) {
            is.reset();
        }
        return result;
    }

    private static boolean isScaling(BitmapFactory.Options options) {
        return options.inTargetDensity > 0 && options.inDensity > 0 && options.inTargetDensity != options.inDensity;
    }

    private static void logDecode(int sourceWidth, int sourceHeight, String outMimeType, BitmapFactory.Options options, Bitmap result, int requestedWidth, int requestedHeight, long startTime) {
        Log.v((String)TAG, (String)("Decoded " + WebpDownsampler.getBitmapString(result) + " from [" + sourceWidth + "x" + sourceHeight + "] " + outMimeType + " with inBitmap " + WebpDownsampler.getInBitmapString(options) + " for [" + requestedWidth + "x" + requestedHeight + "], sample size: " + options.inSampleSize + ", density: " + options.inDensity + ", target density: " + options.inTargetDensity + ", thread: " + Thread.currentThread().getName() + ", duration: " + LogTime.getElapsedMillis((long)startTime)));
    }

    private static String getInBitmapString(BitmapFactory.Options options) {
        return WebpDownsampler.getBitmapString(options.inBitmap);
    }

    @Nullable
    @TargetApi(value=19)
    private static String getBitmapString(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        String sizeString = Build.VERSION.SDK_INT >= 19 ? " (" + bitmap.getAllocationByteCount() + ")" : "";
        return "[" + bitmap.getWidth() + "x" + bitmap.getHeight() + "] " + bitmap.getConfig() + sizeString;
    }

    private static IOException newIoExceptionForInBitmapAssertion(IllegalArgumentException e, int outWidth, int outHeight, String outMimeType, BitmapFactory.Options options) {
        return new IOException("Exception decoding bitmap, outWidth: " + outWidth + ", outHeight: " + outHeight + ", outMimeType: " + outMimeType + ", inBitmap: " + WebpDownsampler.getInBitmapString(options), e);
    }

    @TargetApi(value=26)
    private static void setInBitmap(BitmapFactory.Options options, BitmapPool bitmapPool, int width, int height) {
        if (Build.VERSION.SDK_INT >= 26 && options.inPreferredConfig == Bitmap.Config.HARDWARE) {
            return;
        }
        options.inBitmap = bitmapPool.getDirty(width, height, options.inPreferredConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized BitmapFactory.Options getDefaultOptions() {
        BitmapFactory.Options decodeBitmapOptions;
        Queue<BitmapFactory.Options> queue = OPTIONS_QUEUE;
        synchronized (queue) {
            decodeBitmapOptions = OPTIONS_QUEUE.poll();
        }
        if (decodeBitmapOptions == null) {
            decodeBitmapOptions = new BitmapFactory.Options();
            WebpDownsampler.resetOptions(decodeBitmapOptions);
        }
        return decodeBitmapOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseOptions(BitmapFactory.Options decodeBitmapOptions) {
        WebpDownsampler.resetOptions(decodeBitmapOptions);
        Queue<BitmapFactory.Options> queue = OPTIONS_QUEUE;
        synchronized (queue) {
            OPTIONS_QUEUE.offer(decodeBitmapOptions);
        }
    }

    private static void resetOptions(BitmapFactory.Options decodeBitmapOptions) {
        decodeBitmapOptions.inTempStorage = null;
        decodeBitmapOptions.inDither = false;
        decodeBitmapOptions.inScaled = false;
        decodeBitmapOptions.inSampleSize = 1;
        decodeBitmapOptions.inPreferredConfig = null;
        decodeBitmapOptions.inJustDecodeBounds = false;
        decodeBitmapOptions.inDensity = 0;
        decodeBitmapOptions.inTargetDensity = 0;
        decodeBitmapOptions.outWidth = 0;
        decodeBitmapOptions.outHeight = 0;
        decodeBitmapOptions.outMimeType = null;
        decodeBitmapOptions.inBitmap = null;
        decodeBitmapOptions.inMutable = true;
    }
}

