/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.webp.decoder;

import android.support.annotation.Nullable;
import android.util.Log;
import com.bumptech.glide.integration.webp.WebpHeaderParser;
import com.bumptech.glide.integration.webp.decoder.WebpDrawable;
import com.bumptech.glide.load.Option;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class StreamWebpDecoder
implements ResourceDecoder<InputStream, WebpDrawable> {
    private static final String TAG = "StreamWebpDecoder";
    public static final Option<Boolean> DISABLE_ANIMATION = Option.memory((String)"com.bumptech.glide.integration.webp.decoder.StreamWebpDecoder.DisableAnimation", (Object)false);
    private final ResourceDecoder<ByteBuffer, WebpDrawable> byteBufferDecoder;
    private final ArrayPool byteArrayPool;

    public StreamWebpDecoder(ResourceDecoder<ByteBuffer, WebpDrawable> byteBufferDecoder, ArrayPool byteArrayPool) {
        this.byteBufferDecoder = byteBufferDecoder;
        this.byteArrayPool = byteArrayPool;
    }

    public boolean handles(InputStream inputStream, Options options) throws IOException {
        if (((Boolean)options.get(DISABLE_ANIMATION)).booleanValue()) {
            return false;
        }
        WebpHeaderParser.WebpImageType webpType = WebpHeaderParser.getType(inputStream, this.byteArrayPool);
        return WebpHeaderParser.isAnimatedWebpType(webpType);
    }

    @Nullable
    public Resource<WebpDrawable> decode(InputStream inputStream, int width, int height, Options options) throws IOException {
        byte[] data = StreamWebpDecoder.inputStreamToBytes(inputStream);
        if (data == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        return this.byteBufferDecoder.decode((Object)byteBuffer, width, height, options);
    }

    private static byte[] inputStreamToBytes(InputStream is) {
        int bufferSize = 16384;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(16384);
        try {
            int nRead;
            byte[] data = new byte[16384];
            while ((nRead = is.read(data)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
        }
        catch (IOException e) {
            if (Log.isLoggable((String)TAG, (int)5)) {
                Log.w((String)TAG, (String)"Error reading data from stream", (Throwable)e);
            }
            return null;
        }
        return buffer.toByteArray();
    }
}

