/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.webp.decoder;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.util.Log;
import com.bumptech.glide.gifdecoder.GifDecoder;
import com.bumptech.glide.gifdecoder.GifHeader;
import com.bumptech.glide.integration.webp.WebpFrame;
import com.bumptech.glide.integration.webp.WebpFrameInfo;
import com.bumptech.glide.integration.webp.WebpImage;
import com.bumptech.glide.util.LruCache;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class WebpDecoder
implements GifDecoder {
    private static final String TAG = "WebpDecoder";
    private static final int MAX_FRAME_BITMAP_SIZE = 5;
    private ByteBuffer rawData;
    private WebpImage mWebPImage;
    private GifDecoder.BitmapProvider mBitmapProvider;
    private int mFramePointer;
    private final int[] mFrameDurations;
    private final WebpFrameInfo[] mFrameInfos;
    private int sampleSize;
    private int downsampledHeight;
    private int downsampledWidth;
    private final Paint mBackgroundPaint;
    private final Paint mTransparentFillPaint;
    private Bitmap.Config mBitmapConfig = Bitmap.Config.ARGB_8888;
    private LruCache<Integer, Bitmap> mFrameBitmapCache;

    public WebpDecoder(GifDecoder.BitmapProvider provider, WebpImage webPImage, ByteBuffer rawData, int sampleSize) {
        this.mBitmapProvider = provider;
        this.mWebPImage = webPImage;
        this.mFrameDurations = webPImage.getFrameDurations();
        this.mFrameInfos = new WebpFrameInfo[webPImage.getFrameCount()];
        for (int i = 0; i < this.mWebPImage.getFrameCount(); ++i) {
            this.mFrameInfos[i] = this.mWebPImage.getFrameInfo(i);
            Log.i((String)TAG, (String)("mFrameInfos: " + this.mFrameInfos[i].toString()));
        }
        this.mBackgroundPaint = new Paint();
        this.mBackgroundPaint.setColor(this.mWebPImage.getBackgroundColor());
        this.mBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mBackgroundPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
        this.mTransparentFillPaint = new Paint(this.mBackgroundPaint);
        this.mTransparentFillPaint.setColor(0);
        this.mFrameBitmapCache = new LruCache(5L);
        this.setData(new GifHeader(), rawData, sampleSize);
    }

    public int getWidth() {
        return this.mWebPImage.getWidth();
    }

    public int getHeight() {
        return this.mWebPImage.getHeight();
    }

    public ByteBuffer getData() {
        return this.rawData;
    }

    public int getStatus() {
        return 0;
    }

    public void advance() {
        this.mFramePointer = (this.mFramePointer + 1) % this.mWebPImage.getFrameCount();
    }

    public int getDelay(int n) {
        int delay = -1;
        if (n >= 0 && n < this.mFrameDurations.length) {
            delay = this.mFrameDurations[n];
        }
        return delay;
    }

    public int getNextDelay() {
        if (this.mFrameDurations.length == 0 || this.mFramePointer < 0) {
            return 0;
        }
        return this.getDelay(this.mFramePointer);
    }

    public int getFrameCount() {
        return this.mWebPImage.getFrameCount();
    }

    public int getCurrentFrameIndex() {
        return this.mFramePointer;
    }

    public void resetFrameIndex() {
        this.mFramePointer = -1;
    }

    public int getLoopCount() {
        return this.mWebPImage.getLoopCount();
    }

    public int getNetscapeLoopCount() {
        return this.mWebPImage.getLoopCount();
    }

    public int getTotalIterationCount() {
        if (this.mWebPImage.getLoopCount() == 0) {
            return 0;
        }
        return this.mWebPImage.getFrameCount() + 1;
    }

    public int getByteSize() {
        return this.mWebPImage.getSizeInBytes();
    }

    public void setDefaultBitmapConfig(Bitmap.Config config) {
        if (config != Bitmap.Config.ARGB_8888) {
            throw new IllegalArgumentException("Unsupported format: " + config + ", must be one of " + Bitmap.Config.ARGB_8888);
        }
        this.mBitmapConfig = config;
    }

    public Bitmap getNextFrame() {
        int frameNumber = this.getCurrentFrameIndex();
        Bitmap bitmap = this.mBitmapProvider.obtain(this.downsampledWidth, this.downsampledHeight, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(0, PorterDuff.Mode.SRC);
        int nextIndex = !this.isKeyFrame(frameNumber) ? this.prepareCanvasWithBlending(frameNumber - 1, canvas) : frameNumber;
        Log.i((String)TAG, (String)("frameNumber=" + frameNumber + ", nextIndex=" + nextIndex));
        for (int index = nextIndex; index < frameNumber; ++index) {
            WebpFrameInfo frameInfo = this.mFrameInfos[index];
            if (!frameInfo.blendPreviousFrame) {
                this.noBlendingPreviousFrame(canvas, frameInfo);
            }
            this.renderFrame(index, canvas);
            Log.i((String)TAG, (String)("renderFrame, index=" + index + ", blend=" + frameInfo.blendPreviousFrame + ", dispose=" + frameInfo.disposeBackgroundColor));
            if (!frameInfo.disposeBackgroundColor) continue;
            this.disposeToBackground(canvas, frameInfo);
        }
        WebpFrameInfo frameInfo = this.mFrameInfos[frameNumber];
        if (!frameInfo.blendPreviousFrame) {
            this.noBlendingPreviousFrame(canvas, frameInfo);
        }
        this.renderFrame(frameNumber, canvas);
        Log.i((String)TAG, (String)("renderFrame, index=" + frameNumber + ", blend=" + frameInfo.blendPreviousFrame + ", dispose=" + frameInfo.disposeBackgroundColor));
        this.mFrameBitmapCache.put((Object)frameNumber, (Object)bitmap);
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderFrame(int frameNumber, Canvas canvas) {
        WebpFrameInfo frameInfo = this.mFrameInfos[frameNumber];
        int frameWidth = frameInfo.width / this.sampleSize;
        int frameHeight = frameInfo.height / this.sampleSize;
        int xOffset = frameInfo.xOffset / this.sampleSize;
        int yOffset = frameInfo.yOffset / this.sampleSize;
        Log.i((String)TAG, (String)"render frame with native method");
        WebpFrame webpFrame = this.mWebPImage.getFrame(frameNumber);
        try {
            Bitmap frameBitmap = this.mBitmapProvider.obtain(frameWidth, frameHeight, this.mBitmapConfig);
            frameBitmap.eraseColor(0);
            webpFrame.renderFrame(frameWidth, frameHeight, frameBitmap);
            canvas.drawBitmap(frameBitmap, (float)xOffset, (float)yOffset, null);
            this.mBitmapProvider.release(frameBitmap);
        }
        finally {
            webpFrame.dispose();
        }
    }

    public int read(InputStream inputStream, int i) {
        return 0;
    }

    public void clear() {
        this.mWebPImage.dispose();
        this.mWebPImage = null;
        this.mFrameBitmapCache.clearMemory();
        this.rawData = null;
    }

    public void setData(GifHeader header, byte[] data) {
        this.setData(header, ByteBuffer.wrap(data));
    }

    public void setData(GifHeader header, ByteBuffer buffer) {
        this.setData(header, buffer, 1);
    }

    public void setData(GifHeader header, ByteBuffer buffer, int sampleSize) {
        if (sampleSize <= 0) {
            throw new IllegalArgumentException("Sample size must be >=0, not: " + sampleSize);
        }
        sampleSize = Integer.highestOneBit(sampleSize);
        this.rawData = buffer.asReadOnlyBuffer();
        this.rawData.position(0);
        this.sampleSize = sampleSize;
        this.downsampledWidth = this.mWebPImage.getWidth() / sampleSize;
        this.downsampledHeight = this.mWebPImage.getHeight() / sampleSize;
    }

    public int read(byte[] bytes) {
        return 0;
    }

    private int prepareCanvasWithBlending(int previousFrameNumber, Canvas canvas) {
        for (int index = previousFrameNumber; index >= 0; --index) {
            WebpFrameInfo frameInfo = this.mFrameInfos[index];
            if (!frameInfo.disposeBackgroundColor || !this.isFullFrame(frameInfo)) {
                Bitmap bitmap = (Bitmap)this.mFrameBitmapCache.get((Object)index);
                if (bitmap != null && !bitmap.isRecycled()) {
                    Log.i((String)TAG, (String)("draw previous frame to the canvas, index=" + index));
                    canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
                    if (frameInfo.disposeBackgroundColor) {
                        this.disposeToBackground(canvas, frameInfo);
                    }
                    return index + 1;
                }
                if (!this.isKeyFrame(index)) continue;
                return index;
            }
            return index + 1;
        }
        return 0;
    }

    private void noBlendingPreviousFrame(Canvas canvas, WebpFrameInfo frameInfo) {
        float left = frameInfo.xOffset / this.sampleSize;
        float top = frameInfo.yOffset / this.sampleSize;
        float right = (frameInfo.xOffset + frameInfo.width) / this.sampleSize;
        float bottom = (frameInfo.yOffset + frameInfo.height) / this.sampleSize;
        canvas.drawRect(left, top, right, bottom, this.mTransparentFillPaint);
    }

    private void disposeToBackground(Canvas canvas, WebpFrameInfo frameInfo) {
        float left = frameInfo.xOffset / this.sampleSize;
        float top = frameInfo.yOffset / this.sampleSize;
        float right = (frameInfo.xOffset + frameInfo.width) / this.sampleSize;
        float bottom = (frameInfo.yOffset + frameInfo.height) / this.sampleSize;
        canvas.drawRect(left, top, right, bottom, this.mBackgroundPaint);
    }

    private boolean isKeyFrame(int index) {
        if (index == 0) {
            return true;
        }
        WebpFrameInfo curFrameInfo = this.mFrameInfos[index];
        WebpFrameInfo prevFrameInfo = this.mFrameInfos[index - 1];
        if (!curFrameInfo.blendPreviousFrame && this.isFullFrame(curFrameInfo)) {
            return true;
        }
        return prevFrameInfo.disposeBackgroundColor && this.isFullFrame(prevFrameInfo);
    }

    private boolean isFullFrame(WebpFrameInfo frameInfo) {
        return frameInfo.xOffset == 0 && frameInfo.yOffset == 0 && frameInfo.width == this.mWebPImage.getWidth() && frameInfo.height == this.mWebPImage.getHeight();
    }
}

