/*
 * Decompiled with CFR 0.152.
 */
package com.zintow.dingding;

import com.alibaba.fastjson.JSONObject;
import com.zintow.dingding.DingdingService;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import jenkins.model.Jenkins;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingdingServiceImpl
implements DingdingService {
    private Logger logger = LoggerFactory.getLogger(DingdingService.class);
    private String jsonFilePath;
    private FilePath workspace;
    private static final String apiUrl = "https://oapi.dingtalk.com/robot/send?access_token=";
    private String accessTokens;

    public DingdingServiceImpl(String token, String jsonFilePath, TaskListener listener, FilePath workspace) {
        this.jsonFilePath = jsonFilePath;
        this.accessTokens = token;
        this.workspace = workspace;
    }

    @Override
    public void success() {
        this.notifyLinkMessageToAll(this.accessTokens);
    }

    private void notifyLinkMessageToAll(String accesstokens) {
        String[] tokens;
        for (String token : tokens = accesstokens.split(",")) {
            this.sendMessage(token);
        }
    }

    private void sendMessage(String accesstoken) {
        HttpClient client = this.getHttpClient();
        PostMethod post = new PostMethod(apiUrl + accesstoken);
        try {
            JSONObject body = this.readJsonFilePathWay();
            if (body != null) {
                post.setRequestEntity((RequestEntity)new StringRequestEntity(body.toJSONString(), "application/json", "UTF-8"));
            } else {
                this.logger.error("Failed to parse json file");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            this.logger.error("build request error", (Throwable)e);
        }
        try {
            client.executeMethod((HttpMethod)post);
            this.logger.info(post.getResponseBodyAsString());
        }
        catch (IOException e) {
            this.logger.error("send msg error", (Throwable)e);
        }
        post.releaseConnection();
    }

    private HttpClient getHttpClient() {
        ProxyConfiguration proxy;
        HttpClient client = new HttpClient();
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null && jenkins.proxy != null && (proxy = jenkins.proxy) != null && client.getHostConfiguration() != null) {
            client.getHostConfiguration().setProxy(proxy.name, proxy.port);
            String username = proxy.getUserName();
            String password = proxy.getPassword();
            if (username != null && !"".equals(username.trim())) {
                this.logger.info("Using proxy authentication (user=" + username + ")");
                client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            }
        }
        return client;
    }

    private JSONObject readJson() {
        JSONObject dataJson = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.jsonFilePath), "utf-8"));
            String s = null;
            StringBuffer tempStr = new StringBuffer();
            while ((s = br.readLine()) != null) {
                tempStr.append(s);
            }
            dataJson = JSONObject.parseObject((String)tempStr.toString());
            br.close();
        }
        catch (Exception e) {
            this.logger.error("Read json error", (Throwable)e);
        }
        return dataJson;
    }

    private JSONObject readJsonFilePathWay() {
        JSONObject dataJson = null;
        try {
            FilePath dingding = new FilePath(this.workspace, this.jsonFilePath);
            dataJson = JSONObject.parseObject((String)dingding.readToString());
        }
        catch (Exception e) {
            this.logger.error("Read json error through file path way", (Throwable)e);
        }
        return dataJson;
    }

    private void writeJson(String s) {
        try {
            FilePath dingding = new FilePath(this.workspace, this.jsonFilePath);
            dingding.write(s, null);
        }
        catch (Exception e) {
            this.logger.error("Write json error", (Throwable)e);
        }
    }
}

