/*
 * Decompiled with CFR 0.152.
 */
package me.zalo.startuphelper;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.text.TextUtils;
import com.zing.zalo.devicetrackingsdk.DeviceTracking;
import com.zing.zalo.devicetrackingsdk.model.PreloadInfo;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.DeviceHelper;
import com.zing.zalo.zalosdk.core.helper.Utils;
import java.util.Date;
import java.util.Locale;
import org.json.JSONObject;

class GenerateTrackingParamsAsyncTask
extends AsyncTask<Context, Void, String> {
    private final Callback callback;
    private final String wakerDeviceId;

    GenerateTrackingParamsAsyncTask(String wakerDeviceId, Callback callback) {
        this.callback = callback;
        this.wakerDeviceId = wakerDeviceId;
    }

    protected String doInBackground(Context ... contexts) {
        JSONObject data = new JSONObject();
        try {
            Context context = contexts[0];
            if (!TextUtils.isEmpty((CharSequence)this.wakerDeviceId)) {
                data.put("wakeupZdid", (Object)this.wakerDeviceId);
            }
            data.put("pkgName", (Object)context.getPackageName());
            data.put("appId", (Object)AppInfo.getAppId((Context)context));
            data.put("pl", (Object)"android");
            data.put("osv", (Object)DeviceHelper.getOSVersion());
            data.put("sdkv", (Object)Utils.getSDKVersion());
            data.put("sdkId", (Object)DeviceTracking.getInstance().getSDKId());
            data.put("an", (Object)AppInfo.getAppName((Context)context));
            data.put("av", (Object)AppInfo.getVersionName((Context)context));
            data.put("dId", (Object)DeviceHelper.getAdvertiseID((Context)context));
            data.put("aId", (Object)DeviceHelper.getAndroidId((Context)context));
            data.put("ser", (Object)DeviceHelper.getSerial());
            data.put("mod", (Object)DeviceHelper.getModel());
            data.put("ss", (Object)DeviceHelper.getScreenSize((Context)context));
            data.put("mac", (Object)DeviceHelper.getWLANMACAddress((Context)context));
            data.put("conn", (Object)DeviceHelper.getConnectionType((Context)context));
            data.put("mno", (Object)DeviceHelper.getMobileNetworkCode((Context)context));
            data.put("zdid", (Object)DeviceTracking.getInstance().getDeviceId());
            data.put("adid", (Object)DeviceHelper.getAdvertiseID((Context)context));
            data.put("ts", (Object)String.valueOf(new Date().getTime()));
            data.put("brd", (Object)DeviceHelper.getBrand());
            data.put("dev", (Object)Build.DEVICE);
            data.put("prd", (Object)DeviceHelper.getProduct());
            data.put("adk_ver", Build.VERSION.SDK_INT);
            data.put("mnft", (Object)DeviceHelper.getManufacturer());
            data.put("dev_type", (Object)Build.TYPE);
            data.put("avc", AppInfo.getVersionCode((Context)context));
            data.put("lang", (Object)Locale.getDefault().toString());
            data.put("dpi", (double)context.getResources().getDisplayMetrics().density);
            PreloadInfo preloadInfo = DeviceHelper.getPreloadInfo((Context)context);
            data.put("preload", (Object)preloadInfo.preload);
            data.put("preloadDefault", (Object)AppInfo.getPreloadChannel((Context)context));
            if (!preloadInfo.isPreloaded()) {
                data.put("preloadFailed", (Object)preloadInfo.error);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data.toString();
    }

    protected void onPostExecute(String s) {
        if (this.callback != null) {
            this.callback.onCompleted(s);
        }
        super.onPostExecute((Object)s);
    }

    static interface Callback {
        public void onCompleted(String var1);
    }
}

