package me.zalo.startuphelper;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build.VERSION;
import android.text.TextUtils;
import com.zing.zalo.devicetrackingsdk.DeviceTracking;
import com.zing.zalo.devicetrackingsdk.DeviceTracking.GetInfoListener;
import com.zing.zalo.zalosdk.core.SettingsManager;
import com.zing.zalo.zalosdk.core.helper.Utils;
import java.util.List;
import java.util.Map;

public class StartupHelperUtil {
    private static final String ACTION_STARTUP_PROVIDER = "me.zalo.startuphelper.intent.action.STARTUP_HELPER_PROVIDER";
    static final boolean DEBUG = false;
    private static final String EXTRA_KEY_FIREBASE_TOKEN_TYPE = "z_firebaseToken";
    private static final String EXTRA_KEY_SOURCE_DEVICE_DATA = "z_source_deviceData";
    private static final String EXTRA_KEY_SOURCE_WAKEUP_TYPE = "z_source_wakeup";
    private static final String EXTRA_KEY_START_FROM = "z_startFrom";
    private static final String EXTRA_KEY_START_TYPE = "z_startType";
    private static final String EXTRA_KEY_Z_DEVICE_ID = "z_deviceid";
    private static final String EXTRA_KEY_Z_DEVICE_ID_EXPIRED_TIME = "z_deviceid_expiredTime";
    private static final String START_TYPE_CALLBACK_EVENT = "callback_event";
    private static final String START_TYPE_INSTALL_EVENT = "install_event";
    private static final String START_TYPE_STARTUP = "startup";
    private static final String[] SUPPORTED_APPS = new String[]{"com.demowakeup1", "com.demowakeup2", "com.zing.zalo", "com.epi", "com.zing.mp3", "com.zing.tv3", "com.vng.inputmethod.labankey"};
    public static final String TAG = "wakeuplib";
    private static long lastWakeup = 0;
    private static final Object receiverLocker = new Object();
    private static StartUpTracker startUpTracker;
    private static StartupHelperReceiver startupHelperReceiver;

    public static void onApplicationCreate(final Context context) {
        try {
            getStartUpTracker(context);
            if (context != null) {
                TaskExecutor.queueRunnable(new Runnable() {
                    public void run() {
                        try {
                            StartupHelperUtil.lastWakeup = SettingsManager.getInstance().getLastTimeWakeup(context);
                            long wakeupInterval = SettingsManager.getInstance().getWakeUpInterval(context);
                            if (Installation.isFirstCall(context) || (SettingsManager.getInstance().getWakeupSetting(context) && wakeupInterval > 0 && StartupHelperUtil.lastWakeup + wakeupInterval < System.currentTimeMillis())) {
                                DeviceTracking.getInstance().getDeviceId(new GetInfoListener() {
                                    public void onGetDeviceIdComplete(String deviceId) {
                                        StartupHelperUtil.lastWakeup = System.currentTimeMillis();
                                        SettingsManager.getInstance().saveLastTimeWakeUp(context, StartupHelperUtil.lastWakeup);
                                        StartupHelperUtil.startHelperProviders(context);
                                    }
                                });
                            }
                        } catch (Exception e) {
                        }
                    }
                });
                ApplicationInfo applicationInfo = context.getApplicationInfo();
                if (VERSION.SDK_INT >= 26 && applicationInfo.targetSdkVersion >= 26) {
                    synchronized (receiverLocker) {
                        if (startupHelperReceiver != null) {
                            return;
                        }
                        startupHelperReceiver = new StartupHelperReceiver();
                        IntentFilter intentFilter = new IntentFilter();
                        intentFilter.addAction("android.intent.action.PACKAGE_ADDED");
                        intentFilter.addDataScheme("package");
                        context.registerReceiver(startupHelperReceiver, intentFilter);
                    }
                }
            }
        } catch (Exception e) {
        }
    }

    public static void onApplicationTerminate(Context context) {
        try {
            getStartUpTracker(context).onTerminate();
            if (context != null) {
                synchronized (receiverLocker) {
                    if (startupHelperReceiver != null) {
                        context.unregisterReceiver(startupHelperReceiver);
                        startupHelperReceiver = null;
                    }
                }
            }
        } catch (Exception e) {
        }
    }

    @TargetApi(19)
    private static void startHelperProviders(Context context) {
        try {
            Intent intent = new Intent(ACTION_STARTUP_PROVIDER);
            PackageManager pm = context.getPackageManager();
            List<ResolveInfo> resolveInfoList = null;
            if (VERSION.SDK_INT >= 19) {
                resolveInfoList = pm.queryIntentContentProviders(intent, 0);
            }
            if (resolveInfoList != null && resolveInfoList.size() != 0) {
                for (ResolveInfo providerInfo : resolveInfoList) {
                    try {
                        String packageName = providerInfo.providerInfo.packageName;
                        if (isSupportedApp(context.getPackageName()) && !packageName.equals(context.getPackageName())) {
                            Uri uri = Uri.parse("content://" + providerInfo.providerInfo.authority + "?" + EXTRA_KEY_START_FROM + "=" + context.getPackageName() + "&" + EXTRA_KEY_START_TYPE + "=" + START_TYPE_STARTUP + buildParamUriZDeviceID());
                            if (uri != null) {
                                Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
                                if (cursor != null) {
                                    cursor.close();
                                }
                            }
                        }
                    } catch (Exception e) {
                    }
                }
            }
        } catch (Exception e2) {
        }
    }

    private static boolean isSupportedApp(String packageName) {
        for (String pkg : SUPPORTED_APPS) {
            if (pkg.equals(packageName)) {
                return true;
            }
        }
        return false;
    }

    private static String buildParamUriZDeviceID() {
        String uriStr = "";
        String deviceId = DeviceTracking.getInstance().getDeviceId();
        if (TextUtils.isEmpty(deviceId)) {
            return uriStr;
        }
        long expireTime = DeviceTracking.getInstance().getDeviceIdExpireTime();
        return (uriStr + "&z_deviceid=" + deviceId) + "&z_deviceid_expiredTime=" + String.valueOf(expireTime);
    }

    static void startHelperProvider(Context context, int appUID) {
        try {
            String packageName = context.getPackageManager().getNameForUid(appUID);
            if (packageName != null) {
                int index = packageName.indexOf(58);
                if (index > 0) {
                    packageName = packageName.substring(0, index);
                }
                if (isSupportedApp(packageName)) {
                    startHelperProvider(context, packageName);
                }
            }
        } catch (Exception e) {
        }
    }

    @TargetApi(19)
    private static void startHelperProvider(Context context, String targetPackage) {
        try {
            List<ResolveInfo> resolveInfoList = context.getPackageManager().queryIntentContentProviders(new Intent(ACTION_STARTUP_PROVIDER), 0);
            if (resolveInfoList != null && resolveInfoList.size() != 0) {
                for (ResolveInfo providerInfo : resolveInfoList) {
                    try {
                        String packageName = providerInfo.providerInfo.packageName;
                        if (!packageName.equals(context.getPackageName()) && packageName.equals(targetPackage)) {
                            Uri uri = Uri.parse("content://" + providerInfo.providerInfo.authority + "?" + EXTRA_KEY_START_FROM + "=" + context.getPackageName() + "&" + EXTRA_KEY_START_TYPE + "=" + START_TYPE_INSTALL_EVENT + buildParamUriZDeviceID());
                            if (uri != null) {
                                Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
                                if (cursor != null) {
                                    cursor.close();
                                    return;
                                }
                                return;
                            }
                        }
                    } catch (Exception e) {
                    }
                }
            }
        } catch (Exception e2) {
        }
    }

    public static void setFirebaseToken(Context context, String firebaseToken) {
        getStartUpTracker(context).setFirebaseToken(firebaseToken);
    }

    public static boolean isOpenAppNotificationData(Context context, Map<String, String> stringMap) {
        if (stringMap == null) {
            return false;
        }
        return getStartUpTracker(context).isOpenAppNotificationData(stringMap);
    }

    public static Intent createOpenAppNotificationDataIntent(Context context, Map<String, String> stringMap) {
        if (stringMap == null) {
            return null;
        }
        return getStartUpTracker(context).createOpenAppNotificationDataIntent(context, stringMap);
    }

    public static void setOpenAppSource(Context context, Intent intent) {
        getStartUpTracker(context).onAppOpenedFromNotification(intent);
    }

    public static boolean isOpenNotificationIntent(Context context, Intent intent) {
        return getStartUpTracker(context).isOpenNotificationIntent(intent);
    }

    public static void sendEventOpenApp(Context context, Map<String, String> params) {
        getStartUpTracker(context).onAppOpened(params);
    }

    public static void wakeUpQueryContentProvider(Context context, Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        getStartUpTracker(context);
        String query = uri.getQuery();
        if (!TextUtils.isEmpty(query)) {
            StartUpTracker tracker = getStartUpTracker(context);
            String fromPkg = uri.getQueryParameter(EXTRA_KEY_START_FROM);
            if (!query.contains(START_TYPE_CALLBACK_EVENT)) {
                String fromDeviceId = null;
                if (query.contains(EXTRA_KEY_Z_DEVICE_ID)) {
                    fromDeviceId = uri.getQueryParameter(EXTRA_KEY_Z_DEVICE_ID);
                }
                tracker.onWakeUp(fromPkg, fromDeviceId);
            }
        }
    }

    public static String getVersionZaloSDK() {
        return Utils.getSDKVersion();
    }

    private static synchronized StartUpTracker getStartUpTracker(Context context) {
        StartUpTracker startUpTracker;
        synchronized (StartupHelperUtil.class) {
            if (startUpTracker == null) {
                startUpTracker = new StartUpTracker(context);
            }
            startUpTracker = startUpTracker;
        }
        return startUpTracker;
    }
}
