package me.zalo.startuphelper;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Build.VERSION;
import android.text.TextUtils;
import com.zing.zalo.devicetrackingsdk.DeviceTracking;
import com.zing.zalo.devicetrackingsdk.model.PreloadInfo;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.DeviceHelper;
import com.zing.zalo.zalosdk.core.helper.Utils;
import java.util.Date;
import java.util.Locale;
import org.json.JSONObject;

class GenerateTrackingParamsAsyncTask extends AsyncTask<Context, Void, String> {
    private final Callback callback;
    private final String wakerDeviceId;

    interface Callback {
        void onCompleted(String str);
    }

    GenerateTrackingParamsAsyncTask(String wakerDeviceId, Callback callback) {
        this.callback = callback;
        this.wakerDeviceId = wakerDeviceId;
    }

    protected String doInBackground(Context... contexts) {
        JSONObject data = new JSONObject();
        try {
            Context context = contexts[0];
            if (!TextUtils.isEmpty(this.wakerDeviceId)) {
                data.put("wakeupZdid", this.wakerDeviceId);
            }
            data.put("pkgName", context.getPackageName());
            data.put("appId", AppInfo.getAppId(context));
            data.put("pl", "android");
            data.put("osv", DeviceHelper.getOSVersion());
            data.put("sdkv", Utils.getSDKVersion());
            data.put("sdkId", DeviceTracking.getInstance().getSDKId());
            data.put("an", AppInfo.getAppName(context));
            data.put("av", AppInfo.getVersionName(context));
            data.put("dId", DeviceHelper.getAdvertiseID(context));
            data.put("aId", DeviceHelper.getAndroidId(context));
            data.put("ser", DeviceHelper.getSerial());
            data.put("mod", DeviceHelper.getModel());
            data.put("ss", DeviceHelper.getScreenSize(context));
            data.put("mac", DeviceHelper.getWLANMACAddress(context));
            data.put("conn", DeviceHelper.getConnectionType(context));
            data.put("mno", DeviceHelper.getMobileNetworkCode(context));
            data.put("zdid", DeviceTracking.getInstance().getDeviceId());
            data.put("adid", DeviceHelper.getAdvertiseID(context));
            data.put("ts", String.valueOf(new Date().getTime()));
            data.put("brd", DeviceHelper.getBrand());
            data.put("dev", Build.DEVICE);
            data.put("prd", DeviceHelper.getProduct());
            data.put("adk_ver", VERSION.SDK_INT);
            data.put("mnft", DeviceHelper.getManufacturer());
            data.put("dev_type", Build.TYPE);
            data.put("avc", AppInfo.getVersionCode(context));
            data.put("lang", Locale.getDefault().toString());
            data.put("dpi", (double) context.getResources().getDisplayMetrics().density);
            PreloadInfo preloadInfo = DeviceHelper.getPreloadInfo(context);
            data.put("preload", preloadInfo.preload);
            data.put("preloadDefault", AppInfo.getPreloadChannel(context));
            if (!preloadInfo.isPreloaded()) {
                data.put("preloadFailed", preloadInfo.error);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return data.toString();
    }

    protected void onPostExecute(String s) {
        if (this.callback != null) {
            this.callback.onCompleted(s);
        }
        super.onPostExecute(s);
    }
}
