/*
 * Decompiled with CFR 0.152.
 */
package me.zalo.startuphelper;

import android.os.Build;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class TaskExecutor {
    private static ThreadPoolExecutor mExecutor = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));

    TaskExecutor() {
    }

    public static void queueRunnable(Runnable runnable) {
        mExecutor.execute(runnable);
    }

    static {
        mExecutor.setThreadFactory(new MyThreadFactory("TaskExecutor"));
        if (Build.VERSION.SDK_INT >= 9) {
            mExecutor.allowCoreThreadTimeOut(true);
        }
    }

    static class MyThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        public MyThreadFactory(String poolName) {
            this.namePrefix = "pool-" + poolName + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.namePrefix + this.threadNumber.getAndIncrement());
            t.setPriority(10);
            return t;
        }
    }
}

