/*
 * Decompiled with CFR 0.152.
 */
package me.zalo.startuphelper;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.text.TextUtils;
import com.zing.zalo.devicetrackingsdk.DeviceTracking;
import com.zing.zalo.devicetrackingsdk.ZingAnalyticsManager;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.log.Log;
import java.util.HashMap;
import java.util.Map;
import me.zalo.startuphelper.GenerateTrackingParamsAsyncTask;
import me.zalo.startuphelper.SubmitFirebaseTokenAsyncTask;
import me.zalo.startuphelper.SubmitOpenAppEventAsyncTask;
import org.json.JSONObject;

class StartUpTracker {
    private static final String KEY_FIREBASE_TOKEN = "com.zing.zalo.sdk.wakeup.firebasetoken";
    private static final String KEY_CHECK_SUBMIT_TOKEN = "com.zing.zalo.sdk.wakeup.isSubmitFirebaseToken";
    public static final String WK_PGK_NAME = "wk_pgk_name";
    public static final String WK_NOTIF = "wk_notif";
    public static final String WK_SOURCE = "wk_source";
    public static final String WK_URL = "wk_url";
    private static final String WK_GLOBAL_ID = "wk_globalid";
    public static final String WK_OPEN_PS = "wk_open_ps";
    private String wakerPkgName;
    private String wakerDeviceId;
    private boolean isNotifOpen = false;
    private boolean isWakeUp = false;
    private boolean isOpenApp = false;
    private boolean isSubmittingToken = false;
    private Context context;

    StartUpTracker(Context context) {
        this.context = context.getApplicationContext();
        this.tryToInitZaloSDK();
    }

    private void tryToInitZaloSDK() {
        try {
            Application app = (Application)this.context.getApplicationContext();
            if (!Utils.initZaloSDK((Application)app)) {
                ZingAnalyticsManager.getInstance().init(app);
            }
        }
        catch (Exception ex) {
            Log.v((String)ex.getMessage());
        }
    }

    void onAppOpenedFromNotification(Intent intent) {
        if (intent == null || !intent.hasExtra(WK_SOURCE)) {
            return;
        }
        String sourceNotif = intent.getStringExtra(WK_SOURCE);
        if (TextUtils.isEmpty((CharSequence)sourceNotif)) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sourceFrom", sourceNotif);
        params.put("wakeupInfo", Utils.loadListDeviceIDWakeUp((Context)this.context));
        if (intent.hasExtra(WK_GLOBAL_ID)) {
            String globalIDReceived = intent.getStringExtra(WK_GLOBAL_ID);
            params.put("sourceGid", globalIDReceived);
        }
        ZingAnalyticsManager.getInstance().addEvent("open_app_by_notification", params);
        ZingAnalyticsManager.getInstance().dispatchEvents();
        this.isNotifOpen = true;
        this.wakerPkgName = sourceNotif;
        String token = this.getSavedFirebaseToken();
        if (!TextUtils.isEmpty((CharSequence)token) && !this.isFirebaseTokenSubmitted()) {
            this.submitFirebaseToken(token);
        }
    }

    void onAppOpened(Map<String, String> extra) {
        this.isOpenApp = true;
        this.wakerPkgName = "";
        SubmitOpenAppEventAsyncTask task = new SubmitOpenAppEventAsyncTask(extra);
        task.execute(new Context[]{this.context});
        String token = this.getSavedFirebaseToken();
        if (!TextUtils.isEmpty((CharSequence)token) && !this.isFirebaseTokenSubmitted()) {
            this.submitFirebaseToken(token);
        }
    }

    void onWakeUp(String fromPkg, String fromDeviceId) {
        this.isWakeUp = true;
        this.wakerPkgName = fromPkg;
        this.wakerDeviceId = fromDeviceId;
        this.saveListDeviceIdWakeUp(fromDeviceId, System.currentTimeMillis(), fromPkg);
        String token = this.getSavedFirebaseToken();
        if (!TextUtils.isEmpty((CharSequence)token) && !this.isFirebaseTokenSubmitted()) {
            this.submitFirebaseToken(token);
        }
    }

    void setFirebaseToken(String firebaseToken) {
        String oldFirebaseToken = this.getSavedFirebaseToken();
        if (!(TextUtils.isEmpty((CharSequence)firebaseToken) || firebaseToken.equals(oldFirebaseToken) && this.isFirebaseTokenSubmitted())) {
            this.saveFirebaseToken(firebaseToken);
            this.setFirebaseTokenSubmitted(false);
            this.submitFirebaseToken(firebaseToken);
        }
    }

    private void submitFirebaseToken(final String token) {
        boolean isSubmitFirebaseBefore = this.isFirebaseTokenSubmitted();
        if (isSubmitFirebaseBefore || this.isSubmittingToken) {
            return;
        }
        this.isSubmittingToken = true;
        DeviceTracking.getInstance().getDeviceId(new DeviceTracking.GetInfoListener(){

            public void onGetDeviceIdComplete(String deviceId) {
                if (TextUtils.isEmpty((CharSequence)deviceId)) {
                    Log.e((String)"Submit fb token: Can't get device id");
                    StartUpTracker.this.isSubmittingToken = false;
                    return;
                }
                GenerateTrackingParamsAsyncTask task = new GenerateTrackingParamsAsyncTask(StartUpTracker.this.wakerDeviceId, new GenerateTrackingParamsAsyncTask.Callback(){

                    @Override
                    public void onCompleted(String params) {
                        SubmitFirebaseTokenAsyncTask.Type type = SubmitFirebaseTokenAsyncTask.Type.OPEN_APP;
                        if (StartUpTracker.this.isNotifOpen) {
                            type = SubmitFirebaseTokenAsyncTask.Type.NOTIF;
                        } else if (!StartUpTracker.this.isOpenApp && StartUpTracker.this.isWakeUp) {
                            type = SubmitFirebaseTokenAsyncTask.Type.WAKE_UP;
                        }
                        SubmitFirebaseTokenAsyncTask task = new SubmitFirebaseTokenAsyncTask(type, params, token, StartUpTracker.this.wakerPkgName, new SubmitFirebaseTokenAsyncTask.Callback(){

                            @Override
                            public void onCompleted(boolean success) {
                                StartUpTracker.this.isSubmittingToken = false;
                                if (success) {
                                    StartUpTracker.this.setFirebaseTokenSubmitted(true);
                                }
                            }
                        });
                        task.execute(new Void[0]);
                    }
                });
                task.execute(new Context[]{StartUpTracker.this.context});
            }
        });
    }

    void onTerminate() {
    }

    boolean isOpenAppNotificationData(Map<String, String> stringMap) {
        return stringMap.containsKey(WK_NOTIF) && stringMap.containsKey(WK_SOURCE) && (stringMap.containsKey(WK_URL) || stringMap.containsKey(WK_PGK_NAME));
    }

    private boolean isResolveIntent(Context context, Intent intent) {
        PackageManager packageManager = context.getPackageManager();
        return intent != null && intent.resolveActivity(packageManager) != null;
    }

    public void putDeviceIDIntoIntent(Intent intent) {
        String deviceID;
        if (intent != null && !TextUtils.isEmpty((CharSequence)(deviceID = DeviceTracking.getInstance().getDeviceId()))) {
            intent.putExtra(WK_GLOBAL_ID, deviceID);
        }
    }

    private Intent createIntentOpenPlayStore(Context context, Map<String, String> stringMap) {
        Intent intent = null;
        if (stringMap != null && stringMap.containsKey(WK_OPEN_PS)) {
            String packageName = stringMap.get(WK_OPEN_PS);
            intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + packageName)));
            boolean isResolveIntent = this.isResolveIntent(context, intent);
            if (!isResolveIntent) {
                intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + packageName)));
            }
            if (!(isResolveIntent = this.isResolveIntent(context, intent))) {
                return null;
            }
            if (stringMap.containsKey(WK_PGK_NAME)) {
                if (intent != null) {
                    intent.putExtra(WK_NOTIF, stringMap.get(WK_NOTIF));
                    intent.putExtra(WK_SOURCE, stringMap.get(WK_SOURCE));
                    this.putDeviceIDIntoIntent(intent);
                }
            } else if (stringMap.containsKey(WK_URL)) {
                intent.putExtra(WK_NOTIF, stringMap.get(WK_NOTIF));
                intent.putExtra(WK_SOURCE, stringMap.get(WK_SOURCE));
                this.putDeviceIDIntoIntent(intent);
            }
        }
        return intent;
    }

    Intent createOpenAppNotificationDataIntent(Context context, Map<String, String> stringMap) {
        if (stringMap.containsKey(WK_PGK_NAME)) {
            Intent intent = context.getPackageManager().getLaunchIntentForPackage(stringMap.get(WK_PGK_NAME));
            if (intent != null) {
                intent.putExtra(WK_NOTIF, stringMap.get(WK_NOTIF));
                intent.putExtra(WK_SOURCE, stringMap.get(WK_SOURCE));
                this.putDeviceIDIntoIntent(intent);
            }
            boolean isResolveIntent = this.isResolveIntent(context, intent);
            stringMap.put("can_open", String.valueOf(isResolveIntent));
            ZingAnalyticsManager.getInstance().addEvent("receive_notification", stringMap);
            ZingAnalyticsManager.getInstance().dispatchEvents();
            if (!isResolveIntent) {
                intent = this.createIntentOpenPlayStore(context, stringMap);
                return intent;
            }
            return intent;
        }
        if (stringMap.containsKey(WK_URL)) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setFlags(0x10000000);
            String uriStr = stringMap.get(WK_URL);
            uriStr = uriStr.contains("?") ? uriStr + "&" : uriStr + "?";
            uriStr = uriStr + "wk_source=" + stringMap.get(WK_SOURCE) + "&" + WK_NOTIF + "=" + stringMap.get(WK_NOTIF);
            intent.setData(Uri.parse((String)uriStr));
            intent.putExtra(WK_NOTIF, stringMap.get(WK_NOTIF));
            intent.putExtra(WK_SOURCE, stringMap.get(WK_SOURCE));
            this.putDeviceIDIntoIntent(intent);
            boolean isResolveIntent = this.isResolveIntent(context, intent);
            stringMap.put("can_open", String.valueOf(isResolveIntent));
            ZingAnalyticsManager.getInstance().addEvent("receive_notification", stringMap);
            ZingAnalyticsManager.getInstance().dispatchEvents();
            if (!isResolveIntent) {
                intent = this.createIntentOpenPlayStore(context, stringMap);
                return intent;
            }
            return intent;
        }
        return null;
    }

    boolean isOpenNotificationIntent(Intent intent) {
        return intent != null && intent.hasExtra(WK_SOURCE) && intent.hasExtra(WK_NOTIF);
    }

    private void saveListDeviceIdWakeUp(String deviceIDWakeUp, long timeStamp, String packageName) {
        try {
            JSONObject oldObj;
            String str = Utils.loadListDeviceIDWakeUp((Context)this.context);
            try {
                oldObj = new JSONObject(str);
            }
            catch (Exception ex) {
                oldObj = new JSONObject();
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("zdid", (Object)deviceIDWakeUp);
            jsonObject.put("ts", timeStamp);
            oldObj.put(packageName, (Object)jsonObject);
            Utils.saveString((Context)this.context, (String)"com.zing.zalo.sdk.preload.wakeup", (String)"com.zing.zalo.sdk.wakeup.listdeviceid_wk", (String)oldObj.toString());
        }
        catch (Exception exx) {
            exx.printStackTrace();
        }
    }

    private void saveFirebaseToken(String firebaseToken) {
        Utils.saveString((Context)this.context, (String)"com.zing.zalo.sdk.preload.wakeup", (String)KEY_FIREBASE_TOKEN, (String)firebaseToken);
    }

    private String getSavedFirebaseToken() {
        return Utils.getSavedString((Context)this.context, (String)"com.zing.zalo.sdk.preload.wakeup", (String)KEY_FIREBASE_TOKEN);
    }

    private boolean isFirebaseTokenSubmitted() {
        return Utils.getSavedBoolean((Context)this.context, (String)"com.zing.zalo.sdk.preload.wakeup", (String)KEY_CHECK_SUBMIT_TOKEN);
    }

    private void setFirebaseTokenSubmitted(boolean isSubmit) {
        Utils.saveBoolean((Context)this.context, (String)"com.zing.zalo.sdk.preload.wakeup", (String)KEY_CHECK_SUBMIT_TOKEN, (boolean)isSubmit);
    }
}

