package me.zalo.startuphelper;

import android.os.Build.VERSION;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class TaskExecutor {
    private static ThreadPoolExecutor mExecutor = new ThreadPoolExecutor(1, 1, 30, TimeUnit.SECONDS, new ArrayBlockingQueue(100));

    static class MyThreadFactory implements ThreadFactory {
        private final String namePrefix;
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        public MyThreadFactory(String poolName) {
            this.namePrefix = "pool-" + poolName + "-thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.namePrefix + this.threadNumber.getAndIncrement());
            t.setPriority(10);
            return t;
        }
    }

    TaskExecutor() {
    }

    static {
        mExecutor.setThreadFactory(new MyThreadFactory("TaskExecutor"));
        if (VERSION.SDK_INT >= 9) {
            mExecutor.allowCoreThreadTimeOut(true);
        }
    }

    public static void queueRunnable(Runnable runnable) {
        mExecutor.execute(runnable);
    }
}
