package me.zalo.startuphelper;

import android.os.AsyncTask;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.json.JSONObject;

public class SubmitFirebaseTokenAsyncTask extends AsyncTask<Void, Void, Boolean> {
    private static final String CENTRALIZED_FIREBASE_SUBMIT_NOTIFICATION_PATH = "/firebase/submit/notification";
    private static final String CENTRALIZED_FIREBASE_SUBMIT_OPENAPP_PATH = "/firebase/submit/openapp";
    private static final String CENTRALIZED_FIREBASE_SUBMIT_WAKEUP_PATH = "/firebase/submit/wakeup";
    private final Callback callback;
    private final String firebaseToken;
    private final String params;
    private final String sourceFrom;
    private final Type type;

    interface Callback {
        void onCompleted(boolean z);
    }

    public enum Type {
        OPEN_APP,
        NOTIF,
        WAKE_UP
    }

    SubmitFirebaseTokenAsyncTask(Type type, String params, String firebaseToken, String _sourceFrom, Callback callback) {
        this.type = type;
        this.params = params;
        this.firebaseToken = firebaseToken;
        this.sourceFrom = _sourceFrom;
        this.callback = callback;
    }

    protected Boolean doInBackground(Void... voids) {
        try {
            String requestURL;
            if (this.type == Type.NOTIF) {
                requestURL = ServiceMapManager.getInstance().urlFor("centralized_http_s", CENTRALIZED_FIREBASE_SUBMIT_NOTIFICATION_PATH);
            } else if (this.type == Type.WAKE_UP) {
                requestURL = ServiceMapManager.getInstance().urlFor("centralized_http_s", CENTRALIZED_FIREBASE_SUBMIT_WAKEUP_PATH);
            } else {
                requestURL = ServiceMapManager.getInstance().urlFor("centralized_http_s", CENTRALIZED_FIREBASE_SUBMIT_OPENAPP_PATH);
            }
            String response = "";
            HttpURLConnection conn = (HttpURLConnection) new URL(requestURL).openConnection();
            conn.setReadTimeout(120000);
            conn.setConnectTimeout(120000);
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            OutputStream os = conn.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            String postDataParams = "firebaseToken=" + URLEncoder.encode(this.firebaseToken, "UTF-8") + "&deviceData=" + URLEncoder.encode(this.params.toString(), "UTF-8") + "&";
            if (this.sourceFrom != null) {
                postDataParams = postDataParams + "sourceFrom=" + URLEncoder.encode(this.sourceFrom, "UTF-8") + "&";
            }
            writer.write(postDataParams);
            writer.flush();
            writer.close();
            os.close();
            if (conn.getResponseCode() == 200) {
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while (true) {
                    String line = br.readLine();
                    if (line != null) {
                        response = response + line;
                    } else {
                        try {
                            break;
                        } catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                JSONObject jsonObject = new JSONObject(response);
                if (jsonObject.has("error") && jsonObject.getInt("error") == 1) {
                    return Boolean.valueOf(true);
                }
            }
            return Boolean.valueOf(false);
        } catch (Exception ex2) {
            Log.e(ex2);
            return Boolean.valueOf(false);
        }
    }

    protected void onPostExecute(Boolean success) {
        super.onPostExecute(success);
        if (this.callback != null) {
            this.callback.onCompleted(success.booleanValue());
        }
    }
}
