/*
 * Decompiled with CFR 0.152.
 */
package me.zalo.startuphelper;

import android.content.Context;
import android.os.Build;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.UUID;

class Installation {
    private static String sID = null;
    private static final String INSTALLATION = "ZALO-STARTUP-HELPER-INSTALLATION";

    Installation() {
    }

    public static synchronized boolean isFirstCall(Context context) {
        boolean firstLaunch = false;
        if (sID == null) {
            File installation = new File(Build.VERSION.SDK_INT >= 21 ? context.getNoBackupFilesDir() : context.getFilesDir(), INSTALLATION);
            try {
                if (!installation.exists()) {
                    Installation.writeInstallationFile(installation);
                    firstLaunch = true;
                }
                try {
                    sID = Installation.readInstallationFile(installation);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (installation.delete()) {
                        Installation.writeInstallationFile(installation);
                        sID = Installation.readInstallationFile(installation);
                        firstLaunch = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return firstLaunch;
    }

    private static String readInstallationFile(File installation) throws IOException {
        RandomAccessFile f = new RandomAccessFile(installation, "r");
        byte[] bytes = new byte[(int)f.length()];
        f.readFully(bytes);
        f.close();
        return new String(bytes, "utf-8");
    }

    private static void writeInstallationFile(File installation) throws IOException {
        FileOutputStream out = new FileOutputStream(installation);
        String id = UUID.randomUUID().toString();
        out.write(id.getBytes("utf-8"));
        out.close();
    }
}

