/*
 * Decompiled with CFR 0.152.
 */
package me.zalo.startuphelper;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.zing.zalo.devicetrackingsdk.DeviceTracking;
import com.zing.zalo.zalosdk.core.helper.Utils;
import java.util.List;
import java.util.Map;
import me.zalo.startuphelper.Installation;
import me.zalo.startuphelper.StartUpTracker;
import me.zalo.startuphelper.StartupHelperReceiver;
import me.zalo.startuphelper.TaskExecutor;

public class StartupHelperUtil {
    static final boolean DEBUG = false;
    private static final String ACTION_STARTUP_PROVIDER = "me.zalo.startuphelper.intent.action.STARTUP_HELPER_PROVIDER";
    private static final String START_TYPE_STARTUP = "startup";
    private static final String START_TYPE_INSTALL_EVENT = "install_event";
    private static final String START_TYPE_CALLBACK_EVENT = "callback_event";
    private static final String EXTRA_KEY_START_FROM = "z_startFrom";
    private static final String EXTRA_KEY_START_TYPE = "z_startType";
    private static final String EXTRA_KEY_FIREBASE_TOKEN_TYPE = "z_firebaseToken";
    private static final String EXTRA_KEY_SOURCE_WAKEUP_TYPE = "z_source_wakeup";
    private static final String EXTRA_KEY_SOURCE_DEVICE_DATA = "z_source_deviceData";
    private static final String EXTRA_KEY_Z_DEVICE_ID = "z_deviceid";
    private static final String EXTRA_KEY_Z_DEVICE_ID_EXPIRED_TIME = "z_deviceid_expiredTime";
    public static final String TAG = "wakeuplib";
    private static final String[] SUPPORTED_APPS = new String[]{"com.demowakeup1", "com.demowakeup2", "com.zing.zalo", "com.epi", "com.zing.mp3", "com.zing.tv3", "com.vng.inputmethod.labankey"};
    private static StartUpTracker startUpTracker;
    private static StartupHelperReceiver startupHelperReceiver;
    private static final Object receiverLocker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onApplicationCreate(final Context context) {
        try {
            StartupHelperUtil.getStartUpTracker(context);
            if (context == null) {
                return;
            }
            TaskExecutor.queueRunnable(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (Installation.isFirstCall(context)) {
                            StartupHelperUtil.startHelperProviders(context);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            if (Build.VERSION.SDK_INT < 26 || applicationInfo.targetSdkVersion < 26) {
                return;
            }
            Object object = receiverLocker;
            synchronized (object) {
                if (startupHelperReceiver != null) {
                    return;
                }
                startupHelperReceiver = new StartupHelperReceiver();
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.intent.action.PACKAGE_ADDED");
                intentFilter.addDataScheme("package");
                context.registerReceiver((BroadcastReceiver)startupHelperReceiver, intentFilter);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onApplicationTerminate(Context context) {
        try {
            StartupHelperUtil.getStartUpTracker(context).onTerminate();
            if (context == null) {
                return;
            }
            Object object = receiverLocker;
            synchronized (object) {
                if (startupHelperReceiver != null) {
                    context.unregisterReceiver((BroadcastReceiver)startupHelperReceiver);
                    startupHelperReceiver = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @TargetApi(value=19)
    private static void startHelperProviders(Context context) {
        try {
            Intent intent = new Intent(ACTION_STARTUP_PROVIDER);
            PackageManager pm = context.getPackageManager();
            List resolveInfoList = null;
            if (Build.VERSION.SDK_INT >= 19) {
                resolveInfoList = pm.queryIntentContentProviders(intent, 0);
            }
            if (resolveInfoList == null) {
                return;
            }
            if (resolveInfoList.size() == 0) {
                return;
            }
            for (ResolveInfo providerInfo : resolveInfoList) {
                try {
                    Cursor cursor;
                    String uriStr;
                    Uri uri;
                    String packageName = providerInfo.providerInfo.packageName;
                    if (!StartupHelperUtil.isSupportedApp(context.getPackageName()) || packageName.equals(context.getPackageName()) || (uri = Uri.parse((String)(uriStr = "content://" + providerInfo.providerInfo.authority + "?" + EXTRA_KEY_START_FROM + "=" + context.getPackageName() + "&" + EXTRA_KEY_START_TYPE + "=" + START_TYPE_STARTUP + StartupHelperUtil.buildParamUriZDeviceID()))) == null || (cursor = context.getContentResolver().query(uri, null, null, null, null)) == null) continue;
                    cursor.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isSupportedApp(String packageName) {
        for (String pkg : SUPPORTED_APPS) {
            if (!pkg.equals(packageName)) continue;
            return true;
        }
        return false;
    }

    private static String buildParamUriZDeviceID() {
        String uriStr = "";
        String deviceId = DeviceTracking.getInstance().getDeviceId();
        if (!TextUtils.isEmpty((CharSequence)deviceId)) {
            long expireTime = DeviceTracking.getInstance().getDeviceIdExpireTime();
            uriStr = uriStr + "&z_deviceid=" + deviceId;
            uriStr = uriStr + "&z_deviceid_expiredTime=" + String.valueOf(expireTime);
        }
        return uriStr;
    }

    static void startHelperProvider(Context context, int appUID) {
        try {
            PackageManager pm = context.getPackageManager();
            String packageName = pm.getNameForUid(appUID);
            if (packageName == null) {
                return;
            }
            int index = -1;
            index = packageName.indexOf(58);
            if (index > 0) {
                packageName = packageName.substring(0, index);
            }
            if (StartupHelperUtil.isSupportedApp(packageName)) {
                StartupHelperUtil.startHelperProvider(context, packageName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @TargetApi(value=19)
    private static void startHelperProvider(Context context, String targetPackage) {
        try {
            Intent intent = new Intent(ACTION_STARTUP_PROVIDER);
            PackageManager pm = context.getPackageManager();
            List resolveInfoList = pm.queryIntentContentProviders(intent, 0);
            if (resolveInfoList == null) {
                return;
            }
            if (resolveInfoList.size() == 0) {
                return;
            }
            for (ResolveInfo providerInfo : resolveInfoList) {
                try {
                    String uriStr;
                    Uri uri;
                    String packageName = providerInfo.providerInfo.packageName;
                    if (packageName.equals(context.getPackageName()) || !packageName.equals(targetPackage) || (uri = Uri.parse((String)(uriStr = "content://" + providerInfo.providerInfo.authority + "?" + EXTRA_KEY_START_FROM + "=" + context.getPackageName() + "&" + EXTRA_KEY_START_TYPE + "=" + START_TYPE_INSTALL_EVENT + StartupHelperUtil.buildParamUriZDeviceID()))) == null) continue;
                    Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
                    if (cursor != null) {
                        cursor.close();
                    }
                    return;
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setFirebaseToken(Context context, String firebaseToken) {
        StartupHelperUtil.getStartUpTracker(context).setFirebaseToken(firebaseToken);
    }

    public static boolean isOpenAppNotificationData(Context context, Map<String, String> stringMap) {
        if (stringMap == null) {
            return false;
        }
        return StartupHelperUtil.getStartUpTracker(context).isOpenAppNotificationData(stringMap);
    }

    public static Intent createOpenAppNotificationDataIntent(Context context, Map<String, String> stringMap) {
        if (stringMap == null) {
            return null;
        }
        return StartupHelperUtil.getStartUpTracker(context).createOpenAppNotificationDataIntent(context, stringMap);
    }

    public static void setOpenAppSource(Context context, Intent intent) {
        StartupHelperUtil.getStartUpTracker(context).onAppOpenedFromNotification(intent);
    }

    public static boolean isOpenNotificationIntent(Context context, Intent intent) {
        return StartupHelperUtil.getStartUpTracker(context).isOpenNotificationIntent(intent);
    }

    public static void sendEventOpenApp(Context context, Map<String, String> params) {
        StartupHelperUtil.getStartUpTracker(context).onAppOpened(params);
    }

    public static void wakeUpQueryContentProvider(Context context, Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        String query = uri.getQuery();
        if (TextUtils.isEmpty((CharSequence)query)) {
            return;
        }
        StartUpTracker tracker = StartupHelperUtil.getStartUpTracker(context);
        String fromPkg = uri.getQueryParameter(EXTRA_KEY_START_FROM);
        if (query.contains(START_TYPE_CALLBACK_EVENT)) {
            String firebaseToken = uri.getQueryParameter(EXTRA_KEY_FIREBASE_TOKEN_TYPE);
            String jsonStringDeviceData = uri.getQueryParameter(EXTRA_KEY_SOURCE_DEVICE_DATA);
            tracker.onWakeeCallback(fromPkg, firebaseToken, jsonStringDeviceData);
        } else {
            String fromDeviceId = null;
            if (query.contains(EXTRA_KEY_Z_DEVICE_ID)) {
                fromDeviceId = uri.getQueryParameter(EXTRA_KEY_Z_DEVICE_ID);
            }
            tracker.onWakeUp(fromPkg, fromDeviceId);
        }
    }

    @TargetApi(value=19)
    static void callbackToWaker(Context context, String jsonStringDeviceData, String fireBaseToken, String sourceWakeUp) {
        Intent intent = new Intent(ACTION_STARTUP_PROVIDER);
        PackageManager pm = context.getPackageManager();
        List resolveInfoList = pm.queryIntentContentProviders(intent, 0);
        if (resolveInfoList == null || resolveInfoList.size() == 0) {
            return;
        }
        for (ResolveInfo providerInfo : resolveInfoList) {
            try {
                Cursor cursor;
                Uri uri;
                String packageName = providerInfo.providerInfo.packageName;
                if (packageName.equals(context.getPackageName()) || !packageName.equals(sourceWakeUp) || (uri = Uri.parse((String)("content://" + providerInfo.providerInfo.authority + "?" + EXTRA_KEY_START_FROM + "=" + context.getPackageName() + "&" + EXTRA_KEY_START_TYPE + "=" + START_TYPE_CALLBACK_EVENT + "&" + EXTRA_KEY_FIREBASE_TOKEN_TYPE + "=" + fireBaseToken + "&" + EXTRA_KEY_SOURCE_WAKEUP_TYPE + "=" + sourceWakeUp + "&" + EXTRA_KEY_SOURCE_DEVICE_DATA + "=" + jsonStringDeviceData))) == null || (cursor = context.getContentResolver().query(uri, null, null, null, null)) == null) continue;
                cursor.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getVersionZaloSDK() {
        return Utils.getSDKVersion();
    }

    private static synchronized StartUpTracker getStartUpTracker(Context context) {
        if (startUpTracker == null) {
            startUpTracker = new StartUpTracker(context);
        }
        return startUpTracker;
    }

    static {
        receiverLocker = new Object();
    }
}

