package me.zalo.startuphelper;

import android.os.AsyncTask;
import com.zing.zalo.zalosdk.core.log.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.json.JSONObject;

public class SubmitFirebaseTokenAsyncTask extends AsyncTask<Void, Void, Boolean> {
    private final Callback callback;
    private final String firebaseToken;
    private final String params;
    private final String sourceFrom;
    private final Type type;

    interface Callback {
        void onCompleted(boolean z);
    }

    public enum Type {
        OPEN_APP,
        NOTIF,
        WAKE_UP
    }

    SubmitFirebaseTokenAsyncTask(Type type, String params, String firebaseToken, String sourceFrom, Callback callback) {
        this.type = type;
        this.params = params;
        this.firebaseToken = firebaseToken;
        this.sourceFrom = sourceFrom;
        this.callback = callback;
    }

    protected Boolean doInBackground(Void... voids) {
        try {
            String requestURL;
            if (this.type == Type.NOTIF) {
                requestURL = "https://centralized.zaloapp.com/firebase/submit/notification";
            } else if (this.type == Type.WAKE_UP) {
                requestURL = "https://centralized.zaloapp.com/firebase/submit/wakeup";
            } else {
                requestURL = "https://centralized.zaloapp.com/firebase/submit/openapp";
            }
            String response = "";
            HttpURLConnection conn = (HttpURLConnection) new URL(requestURL).openConnection();
            conn.setReadTimeout(120000);
            conn.setConnectTimeout(120000);
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            OutputStream os = conn.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            String postDataParams = "firebaseToken=" + URLEncoder.encode(this.firebaseToken, "UTF-8") + "&deviceData=" + URLEncoder.encode(this.params.toString(), "UTF-8") + "&sourceFrom=" + URLEncoder.encode(this.sourceFrom, "UTF-8") + "&";
            Log.logUpdateText(StartupHelperUtil.TAG, "[submitfirebasetoken] requestURL: " + requestURL);
            Log.logUpdateText(StartupHelperUtil.TAG, "[submitfirebasetoken] postDataParams: " + postDataParams);
            writer.write(postDataParams);
            writer.flush();
            writer.close();
            os.close();
            if (conn.getResponseCode() == 200) {
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while (true) {
                    String line = br.readLine();
                    if (line != null) {
                        response = response + line;
                    } else {
                        try {
                            break;
                        } catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                Log.logUpdateText(StartupHelperUtil.TAG, "[submitfirebasetoken] response: " + response);
                JSONObject jsonObject = new JSONObject(response);
                if (jsonObject.has("error") && jsonObject.getInt("error") == 1) {
                    return Boolean.valueOf(true);
                }
            }
            return Boolean.valueOf(true);
        } catch (Exception ex2) {
            Log.e(ex2);
            return Boolean.valueOf(false);
        }
    }

    protected void onPostExecute(Boolean success) {
        super.onPostExecute(success);
        if (this.callback != null) {
            this.callback.onCompleted(success.booleanValue());
        }
    }
}
