package me.zalo.startuphelper;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.zing.zalo.devicetrackingsdk.DeviceTracking;
import com.zing.zalo.devicetrackingsdk.DeviceTracking.GetInfoListener;
import com.zing.zalo.devicetrackingsdk.ZingAnalyticsManager;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.log.Log;
import java.util.HashMap;
import java.util.Map;
import me.zalo.startuphelper.SubmitFirebaseTokenAsyncTask.Type;
import org.json.JSONObject;

class StartUpTracker {
    private static final String KEY_CHECK_SUBMIT_TOKEN = "com.zing.zalo.sdk.wakeup.isSubmitFirebaseToken";
    private static final String KEY_FIREBASE_TOKEN = "com.zing.zalo.sdk.wakeup.firebasetoken";
    private static final String WK_NOTIF = "wk_notif";
    private static final String WK_PGK_NAME = "wk_pgk_name";
    private static final String WK_SOURCE = "wk_source";
    private static final String WK_URL = "wk_url";
    private Context context;
    private boolean isNotifOpen = false;
    private boolean isOpenApp = false;
    private boolean isSubmittingToken = false;
    private boolean isWakeUp = false;
    private String wakerDeviceId;
    private String wakerPkgName;

    StartUpTracker(Context context) {
        this.context = context.getApplicationContext();
        tryToInitZaloSDK();
    }

    private void tryToInitZaloSDK() {
        try {
            Application app = (Application) this.context.getApplicationContext();
            if (!Utils.initZaloSDK(app)) {
                ZingAnalyticsManager.getInstance().init(app);
            }
        } catch (Exception ex) {
            Log.v(ex.getMessage());
        }
    }

    void onAppOpenedFromNotification(Intent intent) {
        if (intent != null && intent.hasExtra(WK_SOURCE)) {
            String sourceNotif = intent.getStringExtra(WK_SOURCE);
            if (!TextUtils.isEmpty(sourceNotif)) {
                Map<String, String> params = new HashMap();
                params.put("sourceFrom", sourceNotif);
                params.put("wakeupInfo", Utils.loadListDeviceIDWakeUp(this.context));
                ZingAnalyticsManager.getInstance().addEvent("open_app_by_notification", params);
                ZingAnalyticsManager.getInstance().dispatchEvents();
                this.isNotifOpen = true;
                this.wakerPkgName = sourceNotif;
                String token = getSavedFirebaseToken();
                if (!TextUtils.isEmpty(token) && !isFirebaseTokenSubmitted()) {
                    submitFirebaseToken(token);
                }
            }
        }
    }

    void onAppOpened(Map<String, String> extra) {
        this.isOpenApp = true;
        this.wakerPkgName = "";
        new SubmitOpenAppEventAsyncTask(extra).execute(new Context[]{this.context});
        String token = getSavedFirebaseToken();
        if (!TextUtils.isEmpty(token) && !isFirebaseTokenSubmitted()) {
            submitFirebaseToken(token);
        }
    }

    void onWakeUp(String fromPkg, String fromDeviceId) {
        this.isWakeUp = true;
        this.wakerPkgName = fromPkg;
        this.wakerDeviceId = fromDeviceId;
        saveListDeviceIdWakeUp(fromDeviceId, System.currentTimeMillis(), fromPkg);
        String token = getSavedFirebaseToken();
        if (!TextUtils.isEmpty(token) && !isFirebaseTokenSubmitted()) {
            submitFirebaseToken(token);
        }
    }

    void onWakeeCallback(String fromPkg, String firebaseToken, String jsonStringDeviceData) {
        new SubmitFirebaseTokenAsyncTask(Type.WAKE_UP, jsonStringDeviceData, firebaseToken, fromPkg, new Callback() {
            public void onCompleted(boolean success) {
                if (success) {
                    StartUpTracker.this.setFirebaseTokenSubmitted(true);
                }
            }
        }).execute(new Void[0]);
    }

    void setFirebaseToken(String firebaseToken) {
        String oldFirebaseToken = getSavedFirebaseToken();
        if (!TextUtils.isEmpty(firebaseToken) && !firebaseToken.equals(oldFirebaseToken)) {
            saveFirebaseToken(firebaseToken);
            setFirebaseTokenSubmitted(false);
            submitFirebaseToken(firebaseToken);
        }
    }

    private void submitFirebaseToken(final String token) {
        if (!isFirebaseTokenSubmitted() && !this.isSubmittingToken) {
            this.isSubmittingToken = true;
            DeviceTracking.getInstance().getDeviceId(new GetInfoListener() {
                public void onGetDeviceIdComplete(String deviceId) {
                    if (TextUtils.isEmpty(deviceId)) {
                        Log.e("Submit fb token: Can't get device id");
                        StartUpTracker.this.isSubmittingToken = false;
                        return;
                    }
                    new GenerateTrackingParamsAsyncTask(StartUpTracker.this.wakerDeviceId, new Callback() {
                        public void onCompleted(String params) {
                            Type type = Type.OPEN_APP;
                            if (StartUpTracker.this.isNotifOpen) {
                                type = Type.NOTIF;
                            } else if (!StartUpTracker.this.isOpenApp && StartUpTracker.this.isWakeUp) {
                                type = Type.WAKE_UP;
                            }
                            new SubmitFirebaseTokenAsyncTask(type, params, token, StartUpTracker.this.wakerPkgName, new Callback() {
                                public void onCompleted(boolean success) {
                                    StartUpTracker.this.isSubmittingToken = false;
                                    if (success) {
                                        StartUpTracker.this.setFirebaseTokenSubmitted(true);
                                    }
                                }
                            }).execute(new Void[0]);
                        }
                    }).execute(new Context[]{StartUpTracker.this.context});
                }
            });
        }
    }

    void onTerminate() {
    }

    boolean isOpenAppNotificationData(Map<String, String> stringMap) {
        return stringMap.containsKey(WK_NOTIF) && stringMap.containsKey(WK_SOURCE) && (stringMap.containsKey(WK_URL) || stringMap.containsKey(WK_PGK_NAME));
    }

    private boolean isResolveIntent(Context context, Intent intent) {
        return (intent == null || intent.resolveActivity(context.getPackageManager()) == null) ? false : true;
    }

    Intent createOpenAppNotificationDataIntent(Context context, Map<String, String> stringMap) {
        Intent intent;
        if (stringMap.containsKey(WK_PGK_NAME)) {
            intent = context.getPackageManager().getLaunchIntentForPackage((String) stringMap.get(WK_PGK_NAME));
            if (intent != null) {
                intent.putExtra(WK_NOTIF, (String) stringMap.get(WK_NOTIF));
                intent.putExtra(WK_SOURCE, (String) stringMap.get(WK_SOURCE));
            }
            return !isResolveIntent(context, intent) ? null : intent;
        } else if (!stringMap.containsKey(WK_URL)) {
            return null;
        } else {
            intent = new Intent("android.intent.action.VIEW");
            intent.setFlags(268435456);
            intent.setData(Uri.parse(((String) stringMap.get(WK_URL)) + "?" + WK_SOURCE + "=" + ((String) stringMap.get(WK_SOURCE)) + "&" + WK_NOTIF + "=" + ((String) stringMap.get(WK_NOTIF))));
            intent.putExtra(WK_NOTIF, (String) stringMap.get(WK_NOTIF));
            intent.putExtra(WK_SOURCE, (String) stringMap.get(WK_SOURCE));
            if (isResolveIntent(context, intent)) {
                return intent;
            }
            return null;
        }
    }

    boolean isOpenNotificationIntent(Intent intent) {
        return intent != null && intent.hasExtra(WK_SOURCE) && intent.hasExtra(WK_NOTIF);
    }

    private void saveListDeviceIdWakeUp(String deviceIDWakeUp, long timeStamp, String packageName) {
        try {
            JSONObject oldObj;
            try {
                oldObj = new JSONObject(Utils.loadListDeviceIDWakeUp(this.context));
            } catch (Exception e) {
                oldObj = new JSONObject();
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("zdid", deviceIDWakeUp);
            jsonObject.put("ts", timeStamp);
            oldObj.put(packageName, jsonObject);
            Utils.saveString(this.context, "com.zing.zalo.sdk.preload.wakeup", "com.zing.zalo.sdk.wakeup.listdeviceid_wk", oldObj.toString());
        } catch (Exception exx) {
            exx.printStackTrace();
        }
    }

    private void saveFirebaseToken(String firebaseToken) {
        Utils.saveString(this.context, "com.zing.zalo.sdk.preload.wakeup", KEY_FIREBASE_TOKEN, firebaseToken);
    }

    private String getSavedFirebaseToken() {
        return Utils.getSavedString(this.context, "com.zing.zalo.sdk.preload.wakeup", KEY_FIREBASE_TOKEN);
    }

    private boolean isFirebaseTokenSubmitted() {
        return Utils.getSavedBoolean(this.context, "com.zing.zalo.sdk.preload.wakeup", KEY_CHECK_SUBMIT_TOKEN);
    }

    private void setFirebaseTokenSubmitted(boolean isSubmit) {
        Utils.saveBoolean(this.context, "com.zing.zalo.sdk.preload.wakeup", KEY_CHECK_SUBMIT_TOKEN, isSubmit);
    }
}
