/*
 * Decompiled with CFR 0.152.
 */
package me.zalo.startuphelper;

import android.os.AsyncTask;
import com.zing.zalo.zalosdk.core.log.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.json.JSONObject;

public class SubmitFirebaseTokenAsyncTask
extends AsyncTask<Void, Void, Boolean> {
    private final Type type;
    private final String params;
    private final String sourceFrom;
    private final String firebaseToken;
    private final Callback callback;

    SubmitFirebaseTokenAsyncTask(Type type, String params, String firebaseToken, String _sourceFrom, Callback callback) {
        this.type = type;
        this.params = params;
        this.firebaseToken = firebaseToken;
        this.sourceFrom = _sourceFrom;
        Log.logUpdateText((String)"wakeuplib", (String)("SubmitFirebaseTokenAsyncTask sourceFrom " + this.sourceFrom));
        this.callback = callback;
    }

    protected Boolean doInBackground(Void ... voids) {
        try {
            String requestURL = this.type == Type.NOTIF ? "https://centralized.zaloapp.com/firebase/submit/notification" : (this.type == Type.WAKE_UP ? "https://centralized.zaloapp.com/firebase/submit/wakeup" : "https://centralized.zaloapp.com/firebase/submit/openapp");
            String response = "";
            URL url = new URL(requestURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setReadTimeout(120000);
            conn.setConnectTimeout(120000);
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            OutputStream os = conn.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            String postDataParams = "firebaseToken=" + URLEncoder.encode(this.firebaseToken, "UTF-8") + "&deviceData=" + URLEncoder.encode(this.params.toString(), "UTF-8") + "&";
            if (this.sourceFrom != null) {
                postDataParams = postDataParams + "sourceFrom=" + URLEncoder.encode(this.sourceFrom, "UTF-8") + "&";
            }
            Log.logUpdateText((String)"wakeuplib", (String)("[submitfirebasetoken] requestURL: " + requestURL));
            Log.logUpdateText((String)"wakeuplib", (String)("[submitfirebasetoken] postDataParams: " + postDataParams));
            writer.write(postDataParams);
            writer.flush();
            writer.close();
            os.close();
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((line = br.readLine()) != null) {
                    response = response + line;
                }
                try {
                    int errorCode;
                    Log.logUpdateText((String)"wakeuplib", (String)("[submitfirebasetoken] response: " + response));
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.has("error") && (errorCode = jsonObject.getInt("error")) == 1) {
                        Log.logUpdateText((String)"wakeuplib", (String)"[submitfirebasetoken] return true");
                        return true;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Log.logUpdateText((String)"wakeuplib", (String)"[submitfirebasetoken] return false");
            return false;
        }
        catch (Exception ex) {
            Log.e((Exception)ex);
            Log.logUpdateText((String)"wakeuplib", (String)"[submitfirebasetoken] return false");
            return false;
        }
    }

    protected void onPostExecute(Boolean success) {
        super.onPostExecute((Object)success);
        if (this.callback != null) {
            this.callback.onCompleted(success);
        }
    }

    public static enum Type {
        OPEN_APP,
        NOTIF,
        WAKE_UP;

    }

    static interface Callback {
        public void onCompleted(boolean var1);
    }
}

